/*
 * Decompiled with CFR 0.152.
 */
package org.jtwig.functions;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jtwig.functions.EmptyExpressionResolver;
import org.jtwig.model.expression.Expression;
import org.jtwig.reflection.model.Value;

public class FunctionArguments {
    private final Function<Expression, Object> expressionResolver;
    private final List<Expression> expressions;
    private final Value[] values;

    public static FunctionArguments empty() {
        return new FunctionArguments(EmptyExpressionResolver.instance(), Collections.emptyList());
    }

    public FunctionArguments(Function<Expression, Object> expressionResolver, List<Expression> expressions) {
        this.expressionResolver = expressionResolver;
        this.expressions = expressions;
        this.values = new Value[expressions.size()];
    }

    public Expression getExpression(int index) {
        return this.expressions.get(index);
    }

    public Object getValue(int index) {
        if (this.values[index] == null) {
            this.values[index] = new Value(this.expressionResolver.apply(this.expressions.get(index)));
        }
        return this.values[index].getValue();
    }

    public Object[] getRemainingArguments(int start) {
        if (this.expressions.size() <= 0) {
            return new Object[0];
        }
        Object[] objects = new Object[this.expressions.size() - start];
        for (int i = start; i < this.expressions.size(); ++i) {
            objects[i - start] = this.getValue(i);
        }
        return objects;
    }

    public int size() {
        return this.expressions.size();
    }

    public List<Object> getValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < this.expressions.size(); ++i) {
            values.add(this.getValue(i));
        }
        return values;
    }

    public List<Expression> getExpressions() {
        return ImmutableList.copyOf(this.expressions);
    }
}

