/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.con.api;

import de.mhus.con.api.Conductor;
import de.mhus.con.api.Project;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MValidator;
import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.util.MUri;
import de.mhus.lib.errors.NotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;

public class ConUtil {
    public static final Object consoleLock = new Object();
    private static final Log log = Log.getLog(Conductor.class);
    public static final String PROPERTY_FAE = "conductor.fae";
    public static final String PROPERTY_CMD_PATH = "conductor.cmd.";
    public static final String PROPERTY_PATH = "conductor.path";
    public static final String DEFAULT_PATHES_UNIX = "/usr/local/bin:/usr/bin:/bin:/usr/sbin:/sbin";
    public static final String DEFAULT_PATHES_WINDOWS = "C:\\Program Files;C:\\Winnt;C:\\Winnt\\System32";
    public static final String PROPERTY_VERSION = "conductor.version";
    public static final String PROPERTY_LIFECYCLE = "conductor.lifecycle";
    public static final String PROPERTY_DOWNLOAD_SNAPSHOTS = "conductor.downloadSnapshots";
    public static final String ENV_HOME = "CONDUCTOR_HOME";
    public static final String ENV_HOME_DEFAULT = ".conductor";
    public static final String PROPERTY_ROOT = "conductor.root";
    public static final String PROPERTY_HOME = "conductor.home";
    public static final String PROPERTY_VALIDATORS = "conductor.validators";
    public static final String PROPERTY_PARALLEL = "conductor.parallel";
    public static final String PROPERTY_THREADS = "conductor.threads";
    private static final Object[] SCAN_PACKAGES = new Object[]{"de.mhus.con"};
    public static final String PROPERTY_TRY = "conductor.try";
    public static final String PROPERTY_STEP_IGNORE_RETURN_CODE = "step.ignoreReturnCode";

    public static void orderProjects(List<Project> projects, final String order, final boolean orderAsc) {
        projects.sort(new Comparator<Project>(){

            @Override
            public int compare(Project o1, Project o2) {
                int ret = this.compare((String)o1.getLabels().getOrNull(order), (String)o2.getLabels().getOrNull(order));
                if (!orderAsc) {
                    ret *= -1;
                }
                return ret;
            }

            @Override
            private int compare(String o1, String o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (MValidator.isNumber((String)o1) && MValidator.isNumber((String)o2)) {
                    return Double.compare(MCast.todouble((Object)o1, (double)0.0), MCast.todouble((Object)o2, (double)0.0));
                }
                return o1.compareTo(o2);
            }
        });
    }

    public static String[] execute(String name, File rootDir, String cmd, boolean infoOut) throws IOException {
        log.i(new Object[]{name, "execute", cmd, rootDir});
        final String shortName = MString.truncateNice((String)name, (int)40, (int)15);
        final Console console = ConUtil.getConsole();
        final boolean output = infoOut || log.isLevelEnabled(Log.LEVEL.DEBUG);
        final StringBuilder stdOutBuilder = new StringBuilder();
        final StringBuilder stdErrBuilder = new StringBuilder();
        int exitCode = MSystem.execute((String)shortName, (File)rootDir, (String)cmd, (MSystem.ExecuteControl)new MSystem.ExecuteControl(){

            public void stdin(PrintWriter writer) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stdout(String line) {
                if (output) {
                    Object object = consoleLock;
                    synchronized (object) {
                        console.print("[");
                        console.setColor(Console.COLOR.GREEN, null);
                        console.print(shortName);
                        console.cleanup();
                        console.print("] ");
                        console.println(line);
                        console.flush();
                    }
                }
                if (stdOutBuilder.length() > 0) {
                    stdOutBuilder.append("\n");
                }
                stdOutBuilder.append(line);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stderr(String line) {
                if (output) {
                    Object object = consoleLock;
                    synchronized (object) {
                        console.print("[");
                        console.setColor(Console.COLOR.RED, null);
                        console.print(shortName);
                        console.cleanup();
                        console.print("] ");
                        console.println(line);
                        console.flush();
                    }
                }
                if (stdErrBuilder.length() > 0) {
                    stdErrBuilder.append("\n");
                }
                stdErrBuilder.append(line);
            }
        });
        String stderr = stdErrBuilder.toString();
        String stdout = stdOutBuilder.toString();
        log.i(new Object[]{name, "exitCode", exitCode});
        return new String[]{stdout, stderr, String.valueOf(exitCode)};
    }

    public static Console getConsole() {
        Console ret = Console.get();
        log.t(new Object[]{"Console", ret.getClass()});
        return ret;
    }

    public static String cmdLocationOrNull(Conductor con, String cmd) {
        try {
            return ConUtil.cmdLocation(con, cmd);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    public static String cmdLocation(Conductor con, String cmd) throws NotFoundException {
        String path;
        if (con != null && (path = con.getProperties().getString(PROPERTY_CMD_PATH + cmd.toUpperCase(), null)) != null) {
            return path;
        }
        String[] pathes = null;
        String systemPath = System.getenv("PATH");
        pathes = MSystem.isWindows() ? con.getProperties().getString(PROPERTY_PATH, DEFAULT_PATHES_WINDOWS + (String)(systemPath == null ? "" : ";" + systemPath)).split(";") : con.getProperties().getString(PROPERTY_PATH, DEFAULT_PATHES_UNIX + (String)(systemPath == null ? "" : ":" + systemPath)).split(":");
        for (String path2 : pathes) {
            File file = new File(path2 + File.separator + cmd);
            if (!file.exists() || !file.isFile() || !file.canExecute() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        throw new NotFoundException(new Object[]{"Command not found", cmd});
    }

    public static MUri getDefaultConfiguration(String name) {
        String ext = MString.afterLastIndex((String)name, (char)'.');
        name = MString.beforeLastIndex((String)name, (char)'.');
        MUri uri = MUri.toUri((String)("mvn:de.mhus.conductor/conductor-plugin/1.0.0/" + ext + "/" + name));
        return uri;
    }

    public static File getFile(File root, String path) {
        File f = new File(path);
        if (!f.isAbsolute()) {
            f = new File(root, path);
        }
        return f;
    }

    public static File getHome() {
        String home = System.getenv(ENV_HOME);
        if (MString.isEmpty((String)home)) {
            return new File(MSystem.getUserHome(), ENV_HOME_DEFAULT).getAbsoluteFile();
        }
        return new File(home);
    }

    public static File createTempFile(Conductor con, Class<?> owner, String suffix) throws IOException {
        File tmp = new File(ConUtil.getHome(), "tmp");
        if (tmp.exists() && tmp.isDirectory()) {
            File file = new File(tmp, owner.getSimpleName() + "-" + UUID.randomUUID() + "." + suffix);
            file.deleteOnExit();
            return file;
        }
        File file = File.createTempFile(owner.getSimpleName(), suffix);
        file.deleteOnExit();
        return file;
    }

    public static Object[] getMainPackageName() {
        return SCAN_PACKAGES;
    }
}

