/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.cherry.web.jetty;

import de.mhus.cherry.web.api.InternalCallContext;
import de.mhus.cherry.web.core.CherryApiImpl;
import de.mhus.lib.core.logging.MLogUtil;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"alias=/*"}, name="CherryServlet", servicefactory=true)
public class CherryServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        InternalCallContext call = null;
        CherryApiImpl.instance().beginRequest((Servlet)this, request, response);
        try {
            call = CherryApiImpl.instance().createCallContext((Servlet)this, request, response);
            if (call == null) {
                this.sendNotFoundError(response);
                return;
            }
            call.getVirtualHost().doRequest(call);
        }
        catch (Throwable t) {
            MLogUtil.log().w(new Object[]{t});
            this.sendInternalError(response, t);
        }
        finally {
            CherryApiImpl.instance().endRequest((Servlet)this, request, response);
        }
    }

    private void sendNotFoundError(HttpServletResponse response) {
        if (response.isCommitted()) {
            return;
        }
        try {
            response.sendError(404);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendInternalError(HttpServletResponse response, Throwable t) {
        if (response.isCommitted()) {
            return;
        }
        try {
            response.sendError(500, t.getMessage());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

