/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.cherry.web.core;

import de.mhus.cherry.web.api.CallContext;
import de.mhus.cherry.web.api.InternalCallContext;
import de.mhus.cherry.web.api.VirtualHost;
import de.mhus.cherry.web.api.WebSession;
import de.mhus.cherry.web.core.CherryApiImpl;
import de.mhus.cherry.web.core.HttpWrapperOutoutStream;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.logging.MLogUtil;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CherryCallContext
implements InternalCallContext {
    private HttpServletRequest httpRequest;
    private HttpServletResponse httpResponse;
    private String httpPath;
    private VirtualHost virtualHost;
    private Servlet httpServlet;
    private String sessionId;
    private String host;
    private OutputStream outputStream = null;
    private OutputStreamWriter writer;
    private String remoteIp;

    public CherryCallContext(Servlet servlet, HttpServletRequest req, HttpServletResponse res, VirtualHost vHost) {
        this.httpRequest = req;
        if (req == null) {
            return;
        }
        this.httpPath = req.getPathInfo();
        req.setAttribute("__cherry_call_context", (Object)this);
        this.sessionId = req.getSession().getId();
        this.host = req.getHeader("Host");
        this.httpResponse = res;
        this.outputStream = new HttpWrapperOutoutStream(res);
        this.httpServlet = servlet;
        this.virtualHost = vHost;
        this.remoteIp = req.getRemoteAddr();
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getHttpPath() {
        return this.httpPath;
    }

    public VirtualHost getVirtualHost() {
        return this.virtualHost;
    }

    public Servlet getHttpServlet() {
        return this.httpServlet;
    }

    public String getHttpMethod() {
        if (this.httpRequest.getParameter("_method") != null) {
            return this.httpRequest.getParameter("_method").toLowerCase();
        }
        return this.httpRequest.getMethod().toLowerCase();
    }

    public WebSession getSession() {
        return CherryApiImpl.instance().getCherrySession((CallContext)this, this.sessionId);
    }

    public boolean isSession() {
        return CherryApiImpl.instance().isCherrySession(this.sessionId);
    }

    public void setAttribute(String name, Object value) {
        this.httpRequest.setAttribute(name, value);
    }

    public Object getAttribute(String name) {
        return this.httpRequest.getAttribute(name);
    }

    public String toString() {
        return MSystem.toString((Object)this, (Object[])new Object[]{this.httpPath});
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getHttpHost() {
        return this.host;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        if (os != null) {
            this.outputStream = os;
        }
    }

    public synchronized Writer getWriter() {
        if (this.writer == null) {
            try {
                this.writer = new OutputStreamWriter(this.outputStream, this.virtualHost.getCharsetEncoding());
            }
            catch (UnsupportedEncodingException e) {
                MLogUtil.log().e(new Object[]{e});
                return null;
            }
        }
        return this.writer;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public void setRemoteIp(String remoteIp) {
        this.remoteIp = remoteIp;
    }
}

