/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.cherry.web.core;

import de.mhus.cherry.web.api.CallContext;
import de.mhus.cherry.web.api.CherryApi;
import de.mhus.cherry.web.api.InternalCallContext;
import de.mhus.cherry.web.api.TypeHeader;
import de.mhus.cherry.web.api.TypeHeaderDynamic;
import de.mhus.cherry.web.api.TypeHeaderFactory;
import de.mhus.cherry.web.api.TypeHeaderSimple;
import de.mhus.cherry.web.api.VirtualHost;
import de.mhus.cherry.web.api.WebSession;
import de.mhus.cherry.web.core.CherryCallContext;
import de.mhus.cherry.web.core.CherrySession;
import de.mhus.lib.core.M;
import de.mhus.lib.core.MFile;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.cfg.CfgInt;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.errors.MException;
import de.mhus.lib.servlet.security.SecurityApi;
import de.mhus.osgi.api.util.MServiceTracker;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class CherryApiImpl
extends MLog
implements CherryApi {
    public static final String SESSION_PARAMETER_SESSION = "__cherry_global_session";
    private static CfgInt CFG_MAX_VHOST_CACHE_SIZE = new CfgInt(CherryApi.class, "maxVHostCacheSize", 200);
    private static CherryApiImpl instance;
    private ThreadLocal<CallContext> calls = new ThreadLocal();
    private WeakHashMap<String, WebSession> globalSession = new WeakHashMap();
    private HashMap<String, VirtualHost> vHosts = new HashMap();
    private HashMap<String, VirtualHost> vHostsCache = new HashMap();
    private LinkedList<TypeHeaderFactory> typeHeaderFactories = new LinkedList();
    MServiceTracker<VirtualHost> vHostTracker;

    public CherryApiImpl() {
        this.typeHeaderFactories.add((TypeHeaderFactory)new TypeHeaderDynamic.Factory());
        this.vHostTracker = new MServiceTracker<VirtualHost>(VirtualHost.class){

            protected void removeService(ServiceReference<VirtualHost> reference, VirtualHost service) {
                CherryApiImpl.this.removeVirtualHost(service);
                service.setBundle(null);
            }

            protected void addService(ServiceReference<VirtualHost> reference, VirtualHost service) {
                service.setBundle(reference.getBundle());
                CherryApiImpl.this.addVirtualHost(service);
            }
        };
    }

    public static CherryApiImpl instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addVirtualHost(VirtualHost service) {
        HashMap<String, VirtualHost> hashMap = this.vHosts;
        synchronized (hashMap) {
            this.vHostsCache.clear();
            try {
                service.start((CherryApi)this);
            }
            catch (Throwable t) {
                this.log().e(new Object[]{"Can't add virtual host", service.getName(), t});
                return;
            }
            Set aliases = service.getVirtualHostAliases();
            for (String alias : aliases) {
                this.log().i(new Object[]{"add virtual host", alias});
                VirtualHost old = this.vHosts.put(alias, service);
                if (old == null) continue;
                old.stop((CherryApi)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeVirtualHost(VirtualHost service) {
        HashMap<String, VirtualHost> hashMap = this.vHosts;
        synchronized (hashMap) {
            this.vHostsCache.clear();
            this.vHosts.entrySet().removeIf(e -> {
                if (service == e.getValue()) {
                    this.log().i(new Object[]{"remove virtual host", e.getKey()});
                    return true;
                }
                return false;
            });
            service.stop((CherryApi)this);
        }
    }

    @Activate
    public void doActivate(ComponentContext ctx) {
        this.log().i(new Object[]{"Start Cherry"});
        instance = this;
        this.vHostTracker.start(ctx);
    }

    @Deactivate
    public void doDeactivate(ComponentContext ctx) {
        this.log().i(new Object[]{"Stop Cherry"});
        this.vHostTracker.stop();
        instance = null;
    }

    public CallContext getCurrentCall() {
        return this.calls.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualHost findVirtualHost(String host) {
        HashMap<String, VirtualHost> hashMap = this.vHosts;
        synchronized (hashMap) {
            VirtualHost vHost = null;
            vHost = this.vHostsCache.get(host);
            if (vHost != null) {
                return vHost;
            }
            vHost = this.vHosts.get(host);
            if (vHost == null) {
                Object h = host;
                int p = ((String)h).indexOf(58);
                h = p > 0 ? ((String)h).substring(0, p) + ":*" : (String)h + ":*";
                vHost = this.vHosts.get(h);
            }
            if (vHost == null) {
                vHost = this.vHosts.get("*");
            }
            if (vHost != null && this.vHostsCache.size() < (Integer)CFG_MAX_VHOST_CACHE_SIZE.value()) {
                this.vHostsCache.put(host, vHost);
            }
            return vHost;
        }
    }

    public String getMimeType(String file) {
        String extension = MFile.getFileSuffix((String)file);
        return MFile.getMimeType((String)extension);
    }

    public boolean isCherrySession(String sessionId) {
        WebSession ret = this.globalSession.get(sessionId);
        return ret != null;
    }

    public WebSession getCherrySession(CallContext context, String sessionId) {
        WebSession ret = this.globalSession.get(sessionId);
        if (ret == null) {
            if (context == null) {
                return null;
            }
            ret = new CherrySession(sessionId);
            this.globalSession.put(sessionId, ret);
            context.getHttpRequest().getSession().setAttribute(SESSION_PARAMETER_SESSION, this.globalSession);
        }
        return ret;
    }

    public void setCallContext(CherryCallContext callContext) {
        if (callContext != null) {
            this.calls.set((CallContext)callContext);
        } else {
            this.calls.remove();
        }
    }

    public InternalCallContext createCallContext(Servlet servlet, HttpServletRequest request, HttpServletResponse response) throws MException {
        String host;
        VirtualHost vHost;
        SecurityApi sec = (SecurityApi)M.l(SecurityApi.class);
        if (sec != null) {
            if (!sec.checkHttpRequest(request, response)) {
                return null;
            }
            if (response.isCommitted()) {
                return null;
            }
        }
        if ((vHost = this.findVirtualHost(host = request.getHeader("Host"))) == null) {
            return null;
        }
        CherryCallContext call = new CherryCallContext(servlet, request, response, vHost);
        return call;
    }

    public Map<String, VirtualHost> getVirtualHosts() {
        return Collections.unmodifiableMap(this.vHosts);
    }

    public void restart(VirtualHost host) {
        this.removeVirtualHost(host);
        this.addVirtualHost(host);
    }

    public void beginRequest(Servlet servlet, HttpServletRequest request, HttpServletResponse response) {
        String trace;
        if (request != null && (trace = request.getParameter("_trace")) != null) {
            request.setAttribute("_trace", (Object)"on");
            MLogUtil.setTrailConfig((String)"R", (String)trace);
        }
    }

    public void endRequest(Servlet servlet, HttpServletRequest request, HttpServletResponse response) {
        if (request.getAttribute("_trace") != null) {
            MLogUtil.releaseTrailConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeHeader createTypeHeader(IConfig header) throws MException {
        LinkedList<TypeHeaderFactory> linkedList = this.typeHeaderFactories;
        synchronized (linkedList) {
            for (TypeHeaderFactory factory : this.typeHeaderFactories) {
                TypeHeader obj = factory.create(header);
                if (obj == null) continue;
                return obj;
            }
        }
        String key = header.getString("key", null);
        if (key == null) {
            return null;
        }
        String value = header.getString("value", "");
        boolean add = header.getBoolean("add", false);
        return new TypeHeaderSimple(key, value, add);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=TypeHeaderFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeTypeHeaderFactory")
    public void addTypeHeaderFactory(TypeHeaderFactory factory) {
        LinkedList<TypeHeaderFactory> linkedList = this.typeHeaderFactories;
        synchronized (linkedList) {
            this.typeHeaderFactories.addFirst(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypeHeaderFactory(TypeHeaderFactory factory) {
        LinkedList<TypeHeaderFactory> linkedList = this.typeHeaderFactories;
        synchronized (linkedList) {
            this.typeHeaderFactories.remove(factory);
        }
    }

    public LinkedList<TypeHeaderFactory> getTypeHeaderFactories() {
        return this.typeHeaderFactories;
    }
}

