/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.cherry.web.core;

import de.mhus.cherry.web.api.CallContext;
import de.mhus.cherry.web.api.TypeHeaderFactory;
import de.mhus.cherry.web.api.VirtualHost;
import de.mhus.cherry.web.core.CherryApiImpl;
import de.mhus.cherry.web.core.CherryCallContext;
import de.mhus.cherry.web.core.CherryResponseWrapper;
import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.console.ConsoleTable;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.framework.Bundle;

@Command(scope="cherry", name="vhost", description="Virtual Host Management")
@Service
public class CmdVHost
implements Action {
    @Argument(index=0, name="cmd", required=true, description="Command: list, info, config, use, release, current, restart, headerfactories", multiValued=false)
    String cmd;
    @Argument(index=1, name="vhost", required=false, description="Virtual host name", multiValued=false)
    String host;
    @Argument(index=2, name="parameters", required=false, description="Parameters", multiValued=true)
    String[] parameters;

    public Object execute() throws Exception {
        VirtualHost vhost;
        if (this.cmd.equals("info")) {
            VirtualHost h = CherryApiImpl.instance().getVirtualHosts().get(this.host);
            if (h == null) {
                System.out.println("Virtual host not found");
                return null;
            }
            System.out.println("Name: " + h.getName());
            System.out.println("Bundle: " + h.getBundle());
            System.out.println("Charset: " + h.getCharsetEncoding());
            System.out.println("Class: " + h.getClass().getCanonicalName());
            System.out.println("Updated: " + h.getUpdated());
            IProperties p = h.getProperties();
            if (p != null) {
                for (Map.Entry entry : p.entrySet()) {
                    System.out.println("Property: " + (String)entry.getKey() + "=" + entry.getValue());
                }
            } else {
                System.out.println("No Properties");
            }
            System.out.println("Config:");
            System.out.println(h.getConfig().dump());
        } else if (this.cmd.equals("list")) {
            ConsoleTable out = new ConsoleTable();
            out.setHeaderValues(new String[]{"Alias", "Name", "Type", "Bundle", "Updated"});
            for (Map.Entry<String, VirtualHost> entry : CherryApiImpl.instance().getVirtualHosts().entrySet()) {
                VirtualHost vhost2 = entry.getValue();
                Bundle bundle = vhost2.getBundle();
                out.addRowValues(new Object[]{entry.getKey(), vhost2.getName(), vhost2.getClass().getName(), bundle.getSymbolicName() + "[" + bundle.getBundleId() + "]", vhost2.getUpdated()});
            }
            out.print(System.out);
            return null;
        }
        if (this.cmd.equals("release")) {
            CherryApiImpl.instance().setCallContext(null);
            this.printCurrentVHost();
            return null;
        }
        if (this.cmd.equals("current")) {
            this.printCurrentVHost();
            return null;
        }
        if (this.cmd.equals("headerfactories")) {
            for (TypeHeaderFactory factory : CherryApiImpl.instance().getTypeHeaderFactories()) {
                System.out.println("> " + factory.getClass().getCanonicalName() + ": " + factory);
            }
        }
        if ((vhost = CherryApiImpl.instance().findVirtualHost(this.host)) == null) {
            System.out.println("vHost not found: " + this.host);
            return null;
        }
        if (this.cmd.equals("use")) {
            CherryCallContext callContext = new CherryCallContext(null, null, new CherryResponseWrapper(null), vhost);
            CherryApiImpl.instance().setCallContext(callContext);
            this.printCurrentVHost();
        } else if (this.cmd.equals("restart")) {
            CherryApiImpl.instance().restart(vhost);
            System.out.println("OK");
        } else {
            System.out.println("Command not found");
        }
        return null;
    }

    private void printCurrentVHost() {
        CallContext currentCall = CherryApiImpl.instance().getCurrentCall();
        if (currentCall != null) {
            System.out.println(currentCall.getVirtualHost());
        } else {
            System.out.println("*undefined*");
        }
    }
}

