/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.cherry.web.api;

import de.mhus.cherry.web.api.TypeHeader;
import de.mhus.cherry.web.api.TypeHeaderFactory;
import de.mhus.lib.core.MPeriod;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.errors.MException;
import javax.servlet.http.HttpServletResponse;

public class TypeHeaderDynamic
implements TypeHeader {
    private String key;
    private Object value;
    private String definition;
    private long lastUpdate;
    private long timeout = 900000L;
    private boolean add;

    public TypeHeaderDynamic(String key, String value, boolean add) {
        this.key = key;
        this.definition = value;
        this.add = add;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String getDefinition() {
        return this.definition;
    }

    @Override
    public void appendTo(HttpServletResponse resp) {
        this.updateValue();
        if (this.value == null) {
            return;
        }
        if (this.value instanceof Long) {
            if (this.add) {
                resp.addDateHeader(this.key, ((Long)this.value).longValue());
            } else {
                resp.setDateHeader(this.key, ((Long)this.value).longValue());
            }
        } else if (this.value instanceof Integer) {
            if (this.add) {
                resp.addIntHeader(this.key, ((Integer)this.value).intValue());
            } else {
                resp.setIntHeader(this.key, ((Integer)this.value).intValue());
            }
        } else if (this.add) {
            resp.addHeader(this.key, this.value.toString());
        } else {
            resp.setHeader(this.key, this.value.toString());
        }
    }

    private void updateValue() {
        if (this.definition == null) {
            return;
        }
        if (!MPeriod.isTimeOut((long)this.lastUpdate, (long)this.timeout)) {
            return;
        }
        this.lastUpdate = System.currentTimeMillis();
        if (this.definition.equals("$now")) {
            this.value = System.currentTimeMillis();
        } else if (this.definition.startsWith("$in ")) {
            this.value = new MPeriod(this.definition.substring(4)).getAllMilliseconds() + System.currentTimeMillis();
        }
    }

    public String toString() {
        return this.key + "=" + this.value + "," + this.definition;
    }

    @Override
    public boolean addHeaderLine() {
        return this.add;
    }

    public static class Factory
    implements TypeHeaderFactory {
        @Override
        public TypeHeader create(IConfig header) throws MException {
            String key = header.getString("key", null);
            String value = header.getString("definition", null);
            boolean add = header.getBoolean("add", false);
            if (key == null || value == null) {
                return null;
            }
            return new TypeHeaderDynamic(key, value, add);
        }
    }
}

