/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.xml.external.stream.dtd.nonvalidating;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import jdk7u.jaxp.org.apache.xerces.external.util.SymbolTable;
import jdk7u.jaxp.org.apache.xerces.external.util.XMLSymbols;
import jdk7u.jaxp.org.apache.xerces.external.xni.Augmentations;
import jdk7u.jaxp.org.apache.xerces.external.xni.QName;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLLocator;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLResourceIdentifier;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLString;
import jdk7u.jaxp.org.apache.xerces.external.xni.XNIException;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLDTDContentModelSource;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLDTDSource;
import jdk7u.jaxp.xml.external.stream.dtd.nonvalidating.XMLAttributeDecl;
import jdk7u.jaxp.xml.external.stream.dtd.nonvalidating.XMLElementDecl;
import jdk7u.jaxp.xml.external.stream.dtd.nonvalidating.XMLNotationDecl;
import jdk7u.jaxp.xml.external.stream.dtd.nonvalidating.XMLSimpleType;

public class DTDGrammar {
    public static final int TOP_LEVEL_SCOPE = -1;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final short LIST_FLAG = 128;
    private static final short LIST_MASK = -129;
    private static final boolean DEBUG = false;
    protected XMLDTDSource fDTDSource = null;
    protected XMLDTDContentModelSource fDTDContentModelSource = null;
    protected int fCurrentElementIndex;
    protected int fCurrentAttributeIndex;
    protected boolean fReadingExternalDTD = false;
    private SymbolTable fSymbolTable;
    private ArrayList notationDecls = new ArrayList();
    private int fElementDeclCount = 0;
    private QName[][] fElementDeclName = new QName[4][];
    private short[][] fElementDeclType = new short[4][];
    private int[][] fElementDeclFirstAttributeDeclIndex = new int[4][];
    private int[][] fElementDeclLastAttributeDeclIndex = new int[4][];
    private int fAttributeDeclCount = 0;
    private QName[][] fAttributeDeclName = new QName[4][];
    private short[][] fAttributeDeclType = new short[4][];
    private String[][][] fAttributeDeclEnumeration = new String[4][][];
    private short[][] fAttributeDeclDefaultType = new short[4][];
    private String[][] fAttributeDeclDefaultValue = new String[4][];
    private String[][] fAttributeDeclNonNormalizedDefaultValue = new String[4][];
    private int[][] fAttributeDeclNextAttributeDeclIndex = new int[4][];
    private QNameHashtable fElementIndexMap = new QNameHashtable();
    private QName fQName = new QName();
    protected XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fElementDecl = new XMLElementDecl();
    private XMLSimpleType fSimpleType = new XMLSimpleType();
    Hashtable fElementDeclTab = new Hashtable();

    public DTDGrammar(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public int getAttributeDeclIndex(int elementDeclIndex, String attributeDeclName) {
        if (elementDeclIndex == -1) {
            return -1;
        }
        int attDefIndex = this.getFirstAttributeDeclIndex(elementDeclIndex);
        while (attDefIndex != -1) {
            this.getAttributeDecl(attDefIndex, this.fAttributeDecl);
            if (this.fAttributeDecl.name.rawname == attributeDeclName || attributeDeclName.equals(this.fAttributeDecl.name.rawname)) {
                return attDefIndex;
            }
            attDefIndex = this.getNextAttributeDeclIndex(attDefIndex);
        }
        return -1;
    }

    public void startDTD(XMLLocator locator, Augmentations augs) throws XNIException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void elementDecl(String name, String contentModel, Augmentations augs) throws XNIException {
        XMLElementDecl tmpElementDecl = (XMLElementDecl)this.fElementDeclTab.get(name);
        if (tmpElementDecl != null) {
            if (tmpElementDecl.type != -1) return;
            this.fCurrentElementIndex = this.getElementDeclIndex(name);
        } else {
            this.fCurrentElementIndex = this.createElementDecl();
        }
        XMLElementDecl elementDecl = new XMLElementDecl();
        QName elementName = new QName(null, name, name, null);
        elementDecl.name.setValues(elementName);
        elementDecl.scope = -1;
        if (contentModel.equals("EMPTY")) {
            elementDecl.type = 1;
        } else if (contentModel.equals("ANY")) {
            elementDecl.type = 0;
        } else if (contentModel.startsWith("(")) {
            elementDecl.type = contentModel.indexOf("#PCDATA") > 0 ? (short)2 : (short)3;
        }
        this.fElementDeclTab.put(name, elementDecl);
        this.fElementDecl = elementDecl;
        this.setElementDecl(this.fCurrentElementIndex, this.fElementDecl);
        int chunk = this.fCurrentElementIndex >> 8;
        this.ensureElementDeclCapacity(chunk);
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue, XMLString nonNormalizedDefaultValue, Augmentations augs) throws XNIException {
        if (type != XMLSymbols.fCDATASymbol && defaultValue != null) {
            this.normalizeDefaultAttrValue(defaultValue);
        }
        if (!this.fElementDeclTab.containsKey(elementName)) {
            this.fCurrentElementIndex = this.createElementDecl();
            XMLElementDecl elementDecl = new XMLElementDecl();
            elementDecl.name.setValues(null, elementName, elementName, null);
            elementDecl.scope = -1;
            this.fElementDeclTab.put(elementName, elementDecl);
            this.setElementDecl(this.fCurrentElementIndex, elementDecl);
        }
        int elementIndex = this.getElementDeclIndex(elementName);
        if (this.getAttributeDeclIndex(elementIndex, attributeName) != -1) {
            return;
        }
        this.fCurrentAttributeIndex = this.createAttributeDecl();
        this.fSimpleType.clear();
        if (defaultType != null) {
            if (defaultType.equals("#FIXED")) {
                this.fSimpleType.defaultType = 1;
            } else if (defaultType.equals("#IMPLIED")) {
                this.fSimpleType.defaultType = 0;
            } else if (defaultType.equals("#REQUIRED")) {
                this.fSimpleType.defaultType = (short)2;
            }
        }
        this.fSimpleType.defaultValue = defaultValue != null ? defaultValue.toString() : null;
        this.fSimpleType.nonNormalizedDefaultValue = nonNormalizedDefaultValue != null ? nonNormalizedDefaultValue.toString() : null;
        this.fSimpleType.enumeration = enumeration;
        if (type.equals("CDATA")) {
            this.fSimpleType.type = 0;
        } else if (type.equals("ID")) {
            this.fSimpleType.type = (short)3;
        } else if (type.startsWith("IDREF")) {
            this.fSimpleType.type = (short)4;
            if (type.indexOf("S") > 0) {
                this.fSimpleType.list = true;
            }
        } else if (type.equals("ENTITIES")) {
            this.fSimpleType.type = 1;
            this.fSimpleType.list = true;
        } else if (type.equals("ENTITY")) {
            this.fSimpleType.type = 1;
        } else if (type.equals("NMTOKENS")) {
            this.fSimpleType.type = (short)5;
            this.fSimpleType.list = true;
        } else if (type.equals("NMTOKEN")) {
            this.fSimpleType.type = (short)5;
        } else if (type.startsWith("NOTATION")) {
            this.fSimpleType.type = (short)6;
        } else if (type.startsWith("ENUMERATION")) {
            this.fSimpleType.type = (short)2;
        } else {
            System.err.println("!!! unknown attribute type " + type);
        }
        this.fQName.setValues(null, attributeName, attributeName, null);
        this.fAttributeDecl.setValues(this.fQName, this.fSimpleType, false);
        this.setAttributeDecl(elementIndex, this.fCurrentAttributeIndex, this.fAttributeDecl);
        int chunk = this.fCurrentAttributeIndex >> 8;
        this.ensureAttributeDeclCapacity(chunk);
    }

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public int getFirstElementDeclIndex() {
        return this.fElementDeclCount >= 0 ? 0 : -1;
    }

    public int getNextElementDeclIndex(int elementDeclIndex) {
        return elementDeclIndex < this.fElementDeclCount - 1 ? elementDeclIndex + 1 : -1;
    }

    public int getElementDeclIndex(String elementDeclName) {
        int mapping = this.fElementIndexMap.get(elementDeclName);
        return mapping;
    }

    public int getElementDeclIndex(QName elementDeclQName) {
        return this.getElementDeclIndex(elementDeclQName.rawname);
    }

    public short getContentSpecType(int elementIndex) {
        if (elementIndex < 0 || elementIndex >= this.fElementDeclCount) {
            return -1;
        }
        int chunk = elementIndex >> 8;
        int index = elementIndex & 0xFF;
        if (this.fElementDeclType[chunk][index] == -1) {
            return -1;
        }
        return (short)(this.fElementDeclType[chunk][index] & 0xFFFFFF7F);
    }

    public boolean getElementDecl(int elementDeclIndex, XMLElementDecl elementDecl) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return false;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        elementDecl.name.setValues(this.fElementDeclName[chunk][index]);
        if (this.fElementDeclType[chunk][index] == -1) {
            elementDecl.type = (short)-1;
            elementDecl.simpleType.list = false;
        } else {
            elementDecl.type = (short)(this.fElementDeclType[chunk][index] & 0xFFFFFF7F);
            elementDecl.simpleType.list = (this.fElementDeclType[chunk][index] & 0x80) != 0;
        }
        elementDecl.simpleType.defaultType = (short)-1;
        elementDecl.simpleType.defaultValue = null;
        return true;
    }

    public int getFirstAttributeDeclIndex(int elementDeclIndex) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclFirstAttributeDeclIndex[chunk][index];
    }

    public int getNextAttributeDeclIndex(int attributeDeclIndex) {
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        return this.fAttributeDeclNextAttributeDeclIndex[chunk][index];
    }

    public boolean getAttributeDecl(int attributeDeclIndex, XMLAttributeDecl attributeDecl) {
        boolean isList;
        short attributeType;
        if (attributeDeclIndex < 0 || attributeDeclIndex >= this.fAttributeDeclCount) {
            return false;
        }
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        attributeDecl.name.setValues(this.fAttributeDeclName[chunk][index]);
        if (this.fAttributeDeclType[chunk][index] == -1) {
            attributeType = -1;
            isList = false;
        } else {
            attributeType = (short)(this.fAttributeDeclType[chunk][index] & 0xFFFFFF7F);
            isList = (this.fAttributeDeclType[chunk][index] & 0x80) != 0;
        }
        attributeDecl.simpleType.setValues(attributeType, this.fAttributeDeclName[chunk][index].localpart, this.fAttributeDeclEnumeration[chunk][index], isList, this.fAttributeDeclDefaultType[chunk][index], this.fAttributeDeclDefaultValue[chunk][index], this.fAttributeDeclNonNormalizedDefaultValue[chunk][index]);
        return true;
    }

    public boolean isCDATAAttribute(QName elName, QName atName) {
        int elDeclIdx = this.getElementDeclIndex(elName);
        return !this.getAttributeDecl(elDeclIdx, this.fAttributeDecl) || this.fAttributeDecl.simpleType.type == 0;
    }

    public void printElements() {
        int elementDeclIndex = 0;
        XMLElementDecl elementDecl = new XMLElementDecl();
        while (this.getElementDecl(elementDeclIndex++, elementDecl)) {
            System.out.println("element decl: " + elementDecl.name + ", " + elementDecl.name.rawname);
        }
    }

    public void printAttributes(int elementDeclIndex) {
        int attributeDeclIndex = this.getFirstAttributeDeclIndex(elementDeclIndex);
        System.out.print(elementDeclIndex);
        System.out.print(" [");
        while (attributeDeclIndex != -1) {
            System.out.print(' ');
            System.out.print(attributeDeclIndex);
            this.printAttribute(attributeDeclIndex);
            if ((attributeDeclIndex = this.getNextAttributeDeclIndex(attributeDeclIndex)) == -1) continue;
            System.out.print(",");
        }
        System.out.println(" ]");
    }

    protected int createElementDecl() {
        int chunk = this.fElementDeclCount >> 8;
        int index = this.fElementDeclCount & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        this.fElementDeclName[chunk][index] = new QName();
        this.fElementDeclType[chunk][index] = -1;
        this.fElementDeclFirstAttributeDeclIndex[chunk][index] = -1;
        this.fElementDeclLastAttributeDeclIndex[chunk][index] = -1;
        return this.fElementDeclCount++;
    }

    protected void setElementDecl(int elementDeclIndex, XMLElementDecl elementDecl) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        int scope = elementDecl.scope;
        this.fElementDeclName[chunk][index].setValues(elementDecl.name);
        this.fElementDeclType[chunk][index] = elementDecl.type;
        if (elementDecl.simpleType.list) {
            short[] sArray = this.fElementDeclType[chunk];
            int n = index;
            sArray[n] = (short)(sArray[n] | 0x80);
        }
        this.fElementIndexMap.put(elementDecl.name.rawname, elementDeclIndex);
    }

    protected void setFirstAttributeDeclIndex(int elementDeclIndex, int newFirstAttrIndex) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.fElementDeclFirstAttributeDeclIndex[chunk][index] = newFirstAttrIndex;
    }

    protected int createAttributeDecl() {
        int chunk = this.fAttributeDeclCount >> 8;
        int index = this.fAttributeDeclCount & 0xFF;
        this.ensureAttributeDeclCapacity(chunk);
        this.fAttributeDeclName[chunk][index] = new QName();
        this.fAttributeDeclType[chunk][index] = -1;
        this.fAttributeDeclEnumeration[chunk][index] = null;
        this.fAttributeDeclDefaultType[chunk][index] = 0;
        this.fAttributeDeclDefaultValue[chunk][index] = null;
        this.fAttributeDeclNonNormalizedDefaultValue[chunk][index] = null;
        this.fAttributeDeclNextAttributeDeclIndex[chunk][index] = -1;
        return this.fAttributeDeclCount++;
    }

    protected void setAttributeDecl(int elementDeclIndex, int attributeDeclIndex, XMLAttributeDecl attributeDecl) {
        int attrChunk = attributeDeclIndex >> 8;
        int attrIndex = attributeDeclIndex & 0xFF;
        this.fAttributeDeclName[attrChunk][attrIndex].setValues(attributeDecl.name);
        this.fAttributeDeclType[attrChunk][attrIndex] = attributeDecl.simpleType.type;
        if (attributeDecl.simpleType.list) {
            short[] sArray = this.fAttributeDeclType[attrChunk];
            int n = attrIndex;
            sArray[n] = (short)(sArray[n] | 0x80);
        }
        this.fAttributeDeclEnumeration[attrChunk][attrIndex] = attributeDecl.simpleType.enumeration;
        this.fAttributeDeclDefaultType[attrChunk][attrIndex] = attributeDecl.simpleType.defaultType;
        this.fAttributeDeclDefaultValue[attrChunk][attrIndex] = attributeDecl.simpleType.defaultValue;
        this.fAttributeDeclNonNormalizedDefaultValue[attrChunk][attrIndex] = attributeDecl.simpleType.nonNormalizedDefaultValue;
        int elemChunk = elementDeclIndex >> 8;
        int elemIndex = elementDeclIndex & 0xFF;
        int index = this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex];
        while (index != -1 && index != attributeDeclIndex) {
            attrChunk = index >> 8;
            attrIndex = index & 0xFF;
            index = this.fAttributeDeclNextAttributeDeclIndex[attrChunk][attrIndex];
        }
        if (index == -1) {
            if (this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex] == -1) {
                this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex] = attributeDeclIndex;
            } else {
                index = this.fElementDeclLastAttributeDeclIndex[elemChunk][elemIndex];
                attrChunk = index >> 8;
                attrIndex = index & 0xFF;
                this.fAttributeDeclNextAttributeDeclIndex[attrChunk][attrIndex] = attributeDeclIndex;
            }
            this.fElementDeclLastAttributeDeclIndex[elemChunk][elemIndex] = attributeDeclIndex;
        }
    }

    public void notationDecl(String name, XMLResourceIdentifier identifier, Augmentations augs) throws XNIException {
        XMLNotationDecl notationDecl = new XMLNotationDecl();
        notationDecl.setValues(name, identifier.getPublicId(), identifier.getLiteralSystemId(), identifier.getBaseSystemId());
        this.notationDecls.add(notationDecl);
    }

    public List getNotationDecls() {
        return this.notationDecls;
    }

    private void printAttribute(int attributeDeclIndex) {
        XMLAttributeDecl attributeDecl = new XMLAttributeDecl();
        if (this.getAttributeDecl(attributeDeclIndex, attributeDecl)) {
            System.out.print(" { ");
            System.out.print(attributeDecl.name.localpart);
            System.out.print(" }");
        }
    }

    private void ensureElementDeclCapacity(int chunk) {
        if (chunk >= this.fElementDeclName.length) {
            this.fElementDeclName = DTDGrammar.resize(this.fElementDeclName, this.fElementDeclName.length * 2);
            this.fElementDeclType = DTDGrammar.resize(this.fElementDeclType, this.fElementDeclType.length * 2);
            this.fElementDeclFirstAttributeDeclIndex = DTDGrammar.resize(this.fElementDeclFirstAttributeDeclIndex, this.fElementDeclFirstAttributeDeclIndex.length * 2);
            this.fElementDeclLastAttributeDeclIndex = DTDGrammar.resize(this.fElementDeclLastAttributeDeclIndex, this.fElementDeclLastAttributeDeclIndex.length * 2);
        } else if (this.fElementDeclName[chunk] != null) {
            return;
        }
        this.fElementDeclName[chunk] = new QName[256];
        this.fElementDeclType[chunk] = new short[256];
        this.fElementDeclFirstAttributeDeclIndex[chunk] = new int[256];
        this.fElementDeclLastAttributeDeclIndex[chunk] = new int[256];
    }

    private void ensureAttributeDeclCapacity(int chunk) {
        if (chunk >= this.fAttributeDeclName.length) {
            this.fAttributeDeclName = DTDGrammar.resize(this.fAttributeDeclName, this.fAttributeDeclName.length * 2);
            this.fAttributeDeclType = DTDGrammar.resize(this.fAttributeDeclType, this.fAttributeDeclType.length * 2);
            this.fAttributeDeclEnumeration = DTDGrammar.resize(this.fAttributeDeclEnumeration, this.fAttributeDeclEnumeration.length * 2);
            this.fAttributeDeclDefaultType = DTDGrammar.resize(this.fAttributeDeclDefaultType, this.fAttributeDeclDefaultType.length * 2);
            this.fAttributeDeclDefaultValue = DTDGrammar.resize(this.fAttributeDeclDefaultValue, this.fAttributeDeclDefaultValue.length * 2);
            this.fAttributeDeclNonNormalizedDefaultValue = DTDGrammar.resize(this.fAttributeDeclNonNormalizedDefaultValue, this.fAttributeDeclNonNormalizedDefaultValue.length * 2);
            this.fAttributeDeclNextAttributeDeclIndex = DTDGrammar.resize(this.fAttributeDeclNextAttributeDeclIndex, this.fAttributeDeclNextAttributeDeclIndex.length * 2);
        } else if (this.fAttributeDeclName[chunk] != null) {
            return;
        }
        this.fAttributeDeclName[chunk] = new QName[256];
        this.fAttributeDeclType[chunk] = new short[256];
        this.fAttributeDeclEnumeration[chunk] = new String[256][];
        this.fAttributeDeclDefaultType[chunk] = new short[256];
        this.fAttributeDeclDefaultValue[chunk] = new String[256];
        this.fAttributeDeclNonNormalizedDefaultValue[chunk] = new String[256];
        this.fAttributeDeclNextAttributeDeclIndex[chunk] = new int[256];
    }

    private static short[][] resize(short[][] array, int newsize) {
        short[][] newarray = new short[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static int[][] resize(int[][] array, int newsize) {
        int[][] newarray = new int[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static QName[][] resize(QName[][] array, int newsize) {
        QName[][] newarray = new QName[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static String[][] resize(String[][] array, int newsize) {
        String[][] newarray = new String[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static String[][][] resize(String[][][] array, int newsize) {
        String[][][] newarray = new String[newsize][][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private boolean normalizeDefaultAttrValue(XMLString value) {
        int oldLength = value.length;
        boolean skipSpace = true;
        int current = value.offset;
        int end = value.offset + value.length;
        for (int i = value.offset; i < end; ++i) {
            if (value.ch[i] == ' ') {
                if (skipSpace) continue;
                value.ch[current++] = 32;
                skipSpace = true;
                continue;
            }
            if (current != i) {
                value.ch[current] = value.ch[i];
            }
            ++current;
            skipSpace = false;
        }
        if (current != end) {
            if (skipSpace) {
                --current;
            }
            value.length = current - value.offset;
            return true;
        }
        return false;
    }

    public void endDTD(Augmentations augs) throws XNIException {
    }

    protected static final class QNameHashtable {
        public static final boolean UNIQUE_STRINGS = true;
        private static final int INITIAL_BUCKET_SIZE = 4;
        private static final int HASHTABLE_SIZE = 101;
        private Object[][] fHashTable = new Object[101][];

        protected QNameHashtable() {
        }

        public void put(String key, int value) {
            int hash = (this.hash(key) + 2) % 101;
            Object[] bucket = this.fHashTable[hash];
            if (bucket == null) {
                bucket = new Object[9];
                bucket[0] = new int[]{1};
                bucket[1] = key;
                bucket[2] = new int[]{value};
                this.fHashTable[hash] = bucket;
            } else {
                int count = ((int[])bucket[0])[0];
                int offset = 1 + 2 * count;
                if (offset == bucket.length) {
                    int newSize = count + 4;
                    Object[] newBucket = new Object[1 + 2 * newSize];
                    System.arraycopy(bucket, 0, newBucket, 0, offset);
                    bucket = newBucket;
                    this.fHashTable[hash] = bucket;
                }
                boolean found = false;
                int j = 1;
                for (int i = 0; i < count; ++i) {
                    if ((String)bucket[j] == key) {
                        ((int[])bucket[j + 1])[0] = value;
                        found = true;
                        break;
                    }
                    j += 2;
                }
                if (!found) {
                    bucket[offset++] = key;
                    bucket[offset] = new int[]{value};
                    ((int[])bucket[0])[0] = ++count;
                }
            }
        }

        public int get(String key) {
            int hash = (this.hash(key) + 2) % 101;
            Object[] bucket = this.fHashTable[hash];
            if (bucket == null) {
                return -1;
            }
            int count = ((int[])bucket[0])[0];
            int j = 1;
            for (int i = 0; i < count; ++i) {
                if ((String)bucket[j] == key) {
                    return ((int[])bucket[j + 1])[0];
                }
                j += 2;
            }
            return -1;
        }

        protected int hash(String symbol) {
            if (symbol == null) {
                return 0;
            }
            int code = 0;
            int length = symbol.length();
            for (int i = 0; i < length; ++i) {
                code = code * 37 + symbol.charAt(i);
            }
            return code & 0x7FFFFFF;
        }
    }
}

