/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.xml.external.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stream.StreamResult;
import jdk7u.jaxp.org.apache.xerces.external.impl.PropertyManager;
import jdk7u.jaxp.xml.external.stream.writers.XMLDOMWriterImpl;
import jdk7u.jaxp.xml.external.stream.writers.XMLEventWriterImpl;
import jdk7u.jaxp.xml.external.stream.writers.XMLStreamWriterImpl;

public class XMLOutputFactoryImpl
extends XMLOutputFactory {
    private PropertyManager fPropertyManager = new PropertyManager(2);
    private XMLStreamWriterImpl fStreamWriter = null;
    boolean fReuseInstance = false;
    private static final boolean DEBUG = false;
    private boolean fPropertyChanged;

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLEventWriter(outputStream, null);
    }

    @Override
    public XMLEventWriter createXMLEventWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(outputStream, encoding));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Result result) throws XMLStreamException {
        if (result instanceof StAXResult && ((StAXResult)result).getXMLEventWriter() != null) {
            return ((StAXResult)result).getXMLEventWriter();
        }
        return new XMLEventWriterImpl(this.createXMLStreamWriter(result));
    }

    @Override
    public XMLEventWriter createXMLEventWriter(Writer writer) throws XMLStreamException {
        return new XMLEventWriterImpl(this.createXMLStreamWriter(writer));
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Result result) throws XMLStreamException {
        if (result instanceof StreamResult) {
            return this.createXMLStreamWriter((StreamResult)result, null);
        }
        if (result instanceof DOMResult) {
            return new XMLDOMWriterImpl((DOMResult)result);
        }
        if (result instanceof StAXResult) {
            if (((StAXResult)result).getXMLStreamWriter() != null) {
                return ((StAXResult)result).getXMLStreamWriter();
            }
            throw new UnsupportedOperationException("Result of type " + result + " is not supported");
        }
        if (result.getSystemId() != null) {
            return this.createXMLStreamWriter(new StreamResult(result.getSystemId()));
        }
        throw new UnsupportedOperationException("Result of type " + result + " is not supported. " + "Supported result types are: DOMResult, StAXResult and StreamResult.");
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(Writer writer) throws XMLStreamException {
        return this.createXMLStreamWriter(this.toStreamResult(null, writer, null), null);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream) throws XMLStreamException {
        return this.createXMLStreamWriter(outputStream, null);
    }

    @Override
    public XMLStreamWriter createXMLStreamWriter(OutputStream outputStream, String encoding) throws XMLStreamException {
        return this.createXMLStreamWriter(this.toStreamResult(outputStream, null, null), encoding);
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Property not supported");
        }
        if (this.fPropertyManager.containsProperty(name)) {
            return this.fPropertyManager.getProperty(name);
        }
        throw new IllegalArgumentException("Property not supported");
    }

    @Override
    public boolean isPropertySupported(String name) {
        if (name == null) {
            return false;
        }
        return this.fPropertyManager.containsProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (name == null || value == null || !this.fPropertyManager.containsProperty(name)) {
            throw new IllegalArgumentException("Property " + name + "is not supported");
        }
        if (name == "reuse-instance" || name.equals("reuse-instance")) {
            this.fReuseInstance = (Boolean)value;
            if (this.fReuseInstance) {
                throw new IllegalArgumentException("Property " + name + " is not supported: XMLStreamWriters are not Thread safe");
            }
        } else {
            this.fPropertyChanged = true;
        }
        this.fPropertyManager.setProperty(name, value);
    }

    StreamResult toStreamResult(OutputStream os, Writer writer, String systemId) {
        StreamResult sr = new StreamResult();
        sr.setOutputStream(os);
        sr.setWriter(writer);
        sr.setSystemId(systemId);
        return sr;
    }

    XMLStreamWriter createXMLStreamWriter(StreamResult sr, String encoding) throws XMLStreamException {
        try {
            if (this.fReuseInstance && this.fStreamWriter != null && this.fStreamWriter.canReuse() && !this.fPropertyChanged) {
                this.fStreamWriter.reset();
                this.fStreamWriter.setOutput(sr, encoding);
                return this.fStreamWriter;
            }
            this.fStreamWriter = new XMLStreamWriterImpl(sr, encoding, new PropertyManager(this.fPropertyManager));
            return this.fStreamWriter;
        }
        catch (IOException io) {
            throw new XMLStreamException(io);
        }
    }
}

