/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xpath.external.objects;

import javax.xml.transform.TransformerException;
import jdk7u.jaxp.org.apache.xml.external.dtm.DTM;
import jdk7u.jaxp.org.apache.xml.external.dtm.DTMIterator;
import jdk7u.jaxp.org.apache.xml.external.dtm.ref.DTMNodeIterator;
import jdk7u.jaxp.org.apache.xml.external.dtm.ref.DTMNodeList;
import jdk7u.jaxp.org.apache.xml.external.utils.FastStringBuffer;
import jdk7u.jaxp.org.apache.xml.external.utils.WrappedRuntimeException;
import jdk7u.jaxp.org.apache.xml.external.utils.XMLString;
import jdk7u.jaxp.org.apache.xpath.external.Expression;
import jdk7u.jaxp.org.apache.xpath.external.ExpressionNode;
import jdk7u.jaxp.org.apache.xpath.external.NodeSetDTM;
import jdk7u.jaxp.org.apache.xpath.external.XPathContext;
import jdk7u.jaxp.org.apache.xpath.external.axes.RTFIterator;
import jdk7u.jaxp.org.apache.xpath.external.objects.DTMXRTreeFrag;
import jdk7u.jaxp.org.apache.xpath.external.objects.XObject;
import jdk7u.jaxp.org.apache.xpath.external.objects.XString;
import org.w3c.dom.NodeList;

public class XRTreeFrag
extends XObject
implements Cloneable {
    static final long serialVersionUID = -3201553822254911567L;
    private DTMXRTreeFrag m_DTMXRTreeFrag;
    private int m_dtmRoot = -1;
    protected boolean m_allowRelease = false;
    private XMLString m_xmlStr = null;

    public XRTreeFrag(int root, XPathContext xctxt, ExpressionNode parent) {
        super(null);
        this.exprSetParent(parent);
        this.initDTM(root, xctxt);
    }

    public XRTreeFrag(int root, XPathContext xctxt) {
        super(null);
        this.initDTM(root, xctxt);
    }

    private final void initDTM(int root, XPathContext xctxt) {
        this.m_dtmRoot = root;
        DTM dtm = xctxt.getDTM(root);
        if (dtm != null) {
            this.m_DTMXRTreeFrag = xctxt.getDTMXRTreeFrag(xctxt.getDTMIdentity(dtm));
        }
    }

    @Override
    public Object object() {
        if (this.m_DTMXRTreeFrag.getXPathContext() != null) {
            return new DTMNodeIterator(new NodeSetDTM(this.m_dtmRoot, this.m_DTMXRTreeFrag.getXPathContext().getDTMManager()));
        }
        return super.object();
    }

    public XRTreeFrag(Expression expr) {
        super(expr);
    }

    @Override
    public void allowDetachToRelease(boolean allowRelease) {
        this.m_allowRelease = allowRelease;
    }

    @Override
    public void detach() {
        if (this.m_allowRelease) {
            this.m_DTMXRTreeFrag.destruct();
            this.setObject(null);
        }
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public String getTypeString() {
        return "#RTREEFRAG";
    }

    @Override
    public double num() throws TransformerException {
        XMLString s = this.xstr();
        return s.toDouble();
    }

    @Override
    public boolean bool() {
        return true;
    }

    @Override
    public XMLString xstr() {
        if (null == this.m_xmlStr) {
            this.m_xmlStr = this.m_DTMXRTreeFrag.getDTM().getStringValue(this.m_dtmRoot);
        }
        return this.m_xmlStr;
    }

    @Override
    public void appendToFsb(FastStringBuffer fsb) {
        XString xstring = (XString)this.xstr();
        xstring.appendToFsb(fsb);
    }

    @Override
    public String str() {
        String str = this.m_DTMXRTreeFrag.getDTM().getStringValue(this.m_dtmRoot).toString();
        return null == str ? "" : str;
    }

    @Override
    public int rtf() {
        return this.m_dtmRoot;
    }

    public DTMIterator asNodeIterator() {
        return new RTFIterator(this.m_dtmRoot, this.m_DTMXRTreeFrag.getXPathContext().getDTMManager());
    }

    public NodeList convertToNodeset() {
        if (this.m_obj instanceof NodeList) {
            return (NodeList)this.m_obj;
        }
        return new DTMNodeList(this.asNodeIterator());
    }

    @Override
    public boolean equals(XObject obj2) {
        try {
            if (4 == obj2.getType()) {
                return obj2.equals(this);
            }
            if (1 == obj2.getType()) {
                return this.bool() == obj2.bool();
            }
            if (2 == obj2.getType()) {
                return this.num() == obj2.num();
            }
            if (4 == obj2.getType()) {
                return this.xstr().equals(obj2.xstr());
            }
            if (3 == obj2.getType()) {
                return this.xstr().equals(obj2.xstr());
            }
            if (5 == obj2.getType()) {
                return this.xstr().equals(obj2.xstr());
            }
            return super.equals(obj2);
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
    }
}

