/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xpath.external.jaxp;

import java.io.IOException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import jdk7u.jaxp.org.apache.xalan.external.res.XSLMessages;
import jdk7u.jaxp.org.apache.xalan.external.utils.FactoryImpl;
import jdk7u.jaxp.org.apache.xalan.external.utils.FeatureManager;
import jdk7u.jaxp.org.apache.xml.external.utils.PrefixResolver;
import jdk7u.jaxp.org.apache.xpath.external.XPath;
import jdk7u.jaxp.org.apache.xpath.external.XPathContext;
import jdk7u.jaxp.org.apache.xpath.external.jaxp.JAXPExtensionsProvider;
import jdk7u.jaxp.org.apache.xpath.external.jaxp.JAXPPrefixResolver;
import jdk7u.jaxp.org.apache.xpath.external.jaxp.JAXPVariableStack;
import jdk7u.jaxp.org.apache.xpath.external.jaxp.XPathExpressionImpl;
import jdk7u.jaxp.org.apache.xpath.external.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XPathImpl
implements javax.xml.xpath.XPath {
    private XPathVariableResolver variableResolver;
    private XPathFunctionResolver functionResolver;
    private XPathVariableResolver origVariableResolver;
    private XPathFunctionResolver origFunctionResolver;
    private NamespaceContext namespaceContext = null;
    private JAXPPrefixResolver prefixResolver;
    private boolean featureSecureProcessing = false;
    private boolean useServiceMechanism = true;
    private final FeatureManager featureManager;
    private static Document d = null;

    XPathImpl(XPathVariableResolver vr, XPathFunctionResolver fr) {
        this(vr, fr, false, true, new FeatureManager());
    }

    XPathImpl(XPathVariableResolver vr, XPathFunctionResolver fr, boolean featureSecureProcessing, boolean useServiceMechanism, FeatureManager featureManager) {
        this.origVariableResolver = this.variableResolver = vr;
        this.origFunctionResolver = this.functionResolver = fr;
        this.featureSecureProcessing = featureSecureProcessing;
        this.useServiceMechanism = useServiceMechanism;
        this.featureManager = featureManager;
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver resolver) {
        if (resolver == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPathVariableResolver"});
            throw new NullPointerException(fmsg);
        }
        this.variableResolver = resolver;
    }

    @Override
    public XPathVariableResolver getXPathVariableResolver() {
        return this.variableResolver;
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        if (resolver == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPathFunctionResolver"});
            throw new NullPointerException(fmsg);
        }
        this.functionResolver = resolver;
    }

    @Override
    public XPathFunctionResolver getXPathFunctionResolver() {
        return this.functionResolver;
    }

    @Override
    public void setNamespaceContext(NamespaceContext nsContext) {
        if (nsContext == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"NamespaceContext"});
            throw new NullPointerException(fmsg);
        }
        this.namespaceContext = nsContext;
        this.prefixResolver = new JAXPPrefixResolver(nsContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    private DocumentBuilder getParser() {
        try {
            DocumentBuilderFactory dbf = FactoryImpl.getDOMFactory(this.useServiceMechanism);
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new Error(e);
        }
    }

    private XObject eval(String expression, Object contextItem) throws TransformerException {
        XPath xpath = new XPath(expression, null, this.prefixResolver, 0);
        XPathContext xpathSupport = null;
        if (this.functionResolver != null) {
            JAXPExtensionsProvider jep = new JAXPExtensionsProvider(this.functionResolver, this.featureSecureProcessing, this.featureManager);
            xpathSupport = new XPathContext(jep);
        } else {
            xpathSupport = new XPathContext();
        }
        XObject xobj = null;
        xpathSupport.setVarStack(new JAXPVariableStack(this.variableResolver));
        xobj = contextItem instanceof Node ? xpath.execute(xpathSupport, (Node)contextItem, (PrefixResolver)this.prefixResolver) : xpath.execute(xpathSupport, -1, (PrefixResolver)this.prefixResolver);
        return xobj;
    }

    @Override
    public Object evaluate(String expression, Object item, QName returnType) throws XPathExpressionException {
        if (expression == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(fmsg);
        }
        if (returnType == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"returnType"});
            throw new NullPointerException(fmsg);
        }
        if (!this.isSupported(returnType)) {
            String fmsg = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{returnType.toString()});
            throw new IllegalArgumentException(fmsg);
        }
        try {
            XObject resultObject = this.eval(expression, item);
            return this.getResultAsType(resultObject, returnType);
        }
        catch (NullPointerException npe) {
            throw new XPathExpressionException(npe);
        }
        catch (TransformerException te) {
            Throwable nestedException = te.getException();
            if (nestedException instanceof XPathFunctionException) {
                throw (XPathFunctionException)nestedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    private boolean isSupported(QName returnType) {
        return returnType.equals(XPathConstants.STRING) || returnType.equals(XPathConstants.NUMBER) || returnType.equals(XPathConstants.BOOLEAN) || returnType.equals(XPathConstants.NODE) || returnType.equals(XPathConstants.NODESET);
    }

    private Object getResultAsType(XObject resultObject, QName returnType) throws TransformerException {
        if (returnType.equals(XPathConstants.STRING)) {
            return resultObject.str();
        }
        if (returnType.equals(XPathConstants.NUMBER)) {
            return new Double(resultObject.num());
        }
        if (returnType.equals(XPathConstants.BOOLEAN)) {
            return new Boolean(resultObject.bool());
        }
        if (returnType.equals(XPathConstants.NODESET)) {
            return resultObject.nodelist();
        }
        if (returnType.equals(XPathConstants.NODE)) {
            NodeIterator ni = resultObject.nodeset();
            return ni.nextNode();
        }
        String fmsg = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{returnType.toString()});
        throw new IllegalArgumentException(fmsg);
    }

    @Override
    public String evaluate(String expression, Object item) throws XPathExpressionException {
        return (String)this.evaluate(expression, item, XPathConstants.STRING);
    }

    @Override
    public XPathExpression compile(String expression) throws XPathExpressionException {
        if (expression == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(fmsg);
        }
        try {
            XPath xpath = new XPath(expression, null, this.prefixResolver, 0);
            XPathExpressionImpl ximpl = new XPathExpressionImpl(xpath, this.prefixResolver, this.functionResolver, this.variableResolver, this.featureSecureProcessing, this.useServiceMechanism, this.featureManager);
            return ximpl;
        }
        catch (TransformerException te) {
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public Object evaluate(String expression, InputSource source, QName returnType) throws XPathExpressionException {
        if (source == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"source"});
            throw new NullPointerException(fmsg);
        }
        if (expression == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"XPath expression"});
            throw new NullPointerException(fmsg);
        }
        if (returnType == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"returnType"});
            throw new NullPointerException(fmsg);
        }
        if (!this.isSupported(returnType)) {
            String fmsg = XSLMessages.createXPATHMessage("ER_UNSUPPORTED_RETURN_TYPE", new Object[]{returnType.toString()});
            throw new IllegalArgumentException(fmsg);
        }
        try {
            Document document = this.getParser().parse(source);
            XObject resultObject = this.eval(expression, document);
            return this.getResultAsType(resultObject, returnType);
        }
        catch (SAXException e) {
            throw new XPathExpressionException(e);
        }
        catch (IOException e) {
            throw new XPathExpressionException(e);
        }
        catch (TransformerException te) {
            Throwable nestedException = te.getException();
            if (nestedException instanceof XPathFunctionException) {
                throw (XPathFunctionException)nestedException;
            }
            throw new XPathExpressionException(te);
        }
    }

    @Override
    public String evaluate(String expression, InputSource source) throws XPathExpressionException {
        return (String)this.evaluate(expression, source, XPathConstants.STRING);
    }

    @Override
    public void reset() {
        this.variableResolver = this.origVariableResolver;
        this.functionResolver = this.origFunctionResolver;
        this.namespaceContext = null;
    }
}

