/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xpath.external.jaxp;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunctionResolver;
import javax.xml.xpath.XPathVariableResolver;
import jdk7u.jaxp.org.apache.xalan.external.res.XSLMessages;
import jdk7u.jaxp.org.apache.xalan.external.utils.FeatureManager;
import jdk7u.jaxp.org.apache.xalan.external.utils.FeaturePropertyBase;
import jdk7u.jaxp.org.apache.xpath.external.jaxp.XPathImpl;

public class XPathFactoryImpl
extends XPathFactory {
    private static final String CLASS_NAME = "XPathFactoryImpl";
    private XPathFunctionResolver xPathFunctionResolver = null;
    private XPathVariableResolver xPathVariableResolver = null;
    private boolean _isNotSecureProcessing = true;
    private boolean _isSecureMode = false;
    private boolean _useServicesMechanism = true;
    private final FeatureManager _featureManager = new FeatureManager();

    public XPathFactoryImpl() {
        this(true);
    }

    public static XPathFactory newXPathFactoryNoServiceLoader() {
        return new XPathFactoryImpl(false);
    }

    public XPathFactoryImpl(boolean useServicesMechanism) {
        if (System.getSecurityManager() != null) {
            this._isSecureMode = true;
            this._isNotSecureProcessing = false;
            this._featureManager.setValue(FeatureManager.Feature.ORACLE_ENABLE_EXTENSION_FUNCTION, FeaturePropertyBase.State.FSP, "false");
        }
        this._useServicesMechanism = useServicesMechanism;
    }

    @Override
    public boolean isObjectModelSupported(String objectModel) {
        if (objectModel == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_OBJECT_MODEL_NULL", new Object[]{this.getClass().getName()});
            throw new NullPointerException(fmsg);
        }
        if (objectModel.length() == 0) {
            String fmsg = XSLMessages.createXPATHMessage("ER_OBJECT_MODEL_EMPTY", new Object[]{this.getClass().getName()});
            throw new IllegalArgumentException(fmsg);
        }
        return objectModel.equals("http://java.sun.com/jaxp/xpath/dom");
    }

    @Override
    public XPath newXPath() {
        return new XPathImpl(this.xPathVariableResolver, this.xPathFunctionResolver, !this._isNotSecureProcessing, this._useServicesMechanism, this._featureManager);
    }

    @Override
    public void setFeature(String name, boolean value) throws XPathFactoryConfigurationException {
        if (name == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_FEATURE_NAME_NULL", new Object[]{CLASS_NAME, new Boolean(value)});
            throw new NullPointerException(fmsg);
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            if (this._isSecureMode && !value) {
                String fmsg = XSLMessages.createXPATHMessage("ER_SECUREPROCESSING_FEATURE", new Object[]{name, CLASS_NAME, new Boolean(value)});
                throw new XPathFactoryConfigurationException(fmsg);
            }
            boolean bl = this._isNotSecureProcessing = !value;
            if (value && this._featureManager != null) {
                this._featureManager.setValue(FeatureManager.Feature.ORACLE_ENABLE_EXTENSION_FUNCTION, FeaturePropertyBase.State.FSP, "false");
            }
            return;
        }
        if (name.equals("http://www.oracle.com/feature/use-service-mechanism")) {
            if (!this._isSecureMode) {
                this._useServicesMechanism = value;
            }
            return;
        }
        if (this._featureManager != null && this._featureManager.setValue(name, FeaturePropertyBase.State.APIPROPERTY, value)) {
            return;
        }
        String fmsg = XSLMessages.createXPATHMessage("ER_FEATURE_UNKNOWN", new Object[]{name, CLASS_NAME, new Boolean(value)});
        throw new XPathFactoryConfigurationException(fmsg);
    }

    @Override
    public boolean getFeature(String name) throws XPathFactoryConfigurationException {
        String propertyValue;
        if (name == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_GETTING_NULL_FEATURE", new Object[]{CLASS_NAME});
            throw new NullPointerException(fmsg);
        }
        if (name.equals("http://javax.xml.XMLConstants/feature/secure-processing")) {
            return !this._isNotSecureProcessing;
        }
        if (name.equals("http://www.oracle.com/feature/use-service-mechanism")) {
            return this._useServicesMechanism;
        }
        String string = propertyValue = this._featureManager != null ? this._featureManager.getValueAsString(name) : null;
        if (propertyValue != null) {
            return this._featureManager.isFeatureEnabled(name);
        }
        String fmsg = XSLMessages.createXPATHMessage("ER_GETTING_UNKNOWN_FEATURE", new Object[]{name, CLASS_NAME});
        throw new XPathFactoryConfigurationException(fmsg);
    }

    @Override
    public void setXPathFunctionResolver(XPathFunctionResolver resolver) {
        if (resolver == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_NULL_XPATH_FUNCTION_RESOLVER", new Object[]{CLASS_NAME});
            throw new NullPointerException(fmsg);
        }
        this.xPathFunctionResolver = resolver;
    }

    @Override
    public void setXPathVariableResolver(XPathVariableResolver resolver) {
        if (resolver == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_NULL_XPATH_VARIABLE_RESOLVER", new Object[]{CLASS_NAME});
            throw new NullPointerException(fmsg);
        }
        this.xPathVariableResolver = resolver;
    }
}

