/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xpath.external.jaxp;

import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathVariableResolver;
import jdk7u.jaxp.org.apache.xalan.external.res.XSLMessages;
import jdk7u.jaxp.org.apache.xml.external.utils.QName;
import jdk7u.jaxp.org.apache.xpath.external.VariableStack;
import jdk7u.jaxp.org.apache.xpath.external.XPathContext;
import jdk7u.jaxp.org.apache.xpath.external.objects.XObject;

public class JAXPVariableStack
extends VariableStack {
    private final XPathVariableResolver resolver;

    public JAXPVariableStack(XPathVariableResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public XObject getVariableOrParam(XPathContext xctxt, QName qname) throws TransformerException, IllegalArgumentException {
        if (qname == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_ARG_CANNOT_BE_NULL", new Object[]{"Variable qname"});
            throw new IllegalArgumentException(fmsg);
        }
        javax.xml.namespace.QName name = new javax.xml.namespace.QName(qname.getNamespace(), qname.getLocalPart());
        Object varValue = this.resolver.resolveVariable(name);
        if (varValue == null) {
            String fmsg = XSLMessages.createXPATHMessage("ER_RESOLVE_VARIABLE_RETURNS_NULL", new Object[]{name.toString()});
            throw new TransformerException(fmsg);
        }
        return XObject.create(varValue, xctxt);
    }
}

