/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xpath.external.functions;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import jdk7u.jaxp.org.apache.xml.external.dtm.DTMIterator;
import jdk7u.jaxp.org.apache.xml.external.utils.WrappedRuntimeException;
import jdk7u.jaxp.org.apache.xpath.external.XPathContext;
import jdk7u.jaxp.org.apache.xpath.external.axes.SubContextList;
import jdk7u.jaxp.org.apache.xpath.external.compiler.Compiler;
import jdk7u.jaxp.org.apache.xpath.external.functions.Function;
import jdk7u.jaxp.org.apache.xpath.external.objects.XNumber;
import jdk7u.jaxp.org.apache.xpath.external.objects.XObject;

public class FuncPosition
extends Function {
    static final long serialVersionUID = -9092846348197271582L;
    private boolean m_isTopLevel;

    @Override
    public void postCompileStep(Compiler compiler) {
        this.m_isTopLevel = compiler.getLocationPathDepth() == -1;
    }

    public int getPositionInContextNodeList(XPathContext xctxt) {
        SubContextList iter;
        SubContextList subContextList = iter = this.m_isTopLevel ? null : xctxt.getSubContextList();
        if (null != iter) {
            int prox = iter.getProximityPosition(xctxt);
            return prox;
        }
        DTMIterator cnl = xctxt.getContextNodeList();
        if (null != cnl) {
            int n = cnl.getCurrentNode();
            if (n == -1) {
                if (cnl.getCurrentPos() == 0) {
                    return 0;
                }
                try {
                    cnl = cnl.cloneWithReset();
                }
                catch (CloneNotSupportedException cnse) {
                    throw new WrappedRuntimeException(cnse);
                }
                int currentNode = xctxt.getContextNode();
                while (-1 != (n = cnl.nextNode()) && n != currentNode) {
                }
            }
            return cnl.getCurrentPos();
        }
        return -1;
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        double pos = this.getPositionInContextNodeList(xctxt);
        return new XNumber(pos);
    }

    @Override
    public void fixupVariables(Vector vars, int globalsSize) {
    }
}

