/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xml.external.utils;

public class ThreadControllerWrapper {
    private static ThreadController m_tpool = new ThreadController();

    public static Thread runThread(Runnable runnable, int priority) {
        return m_tpool.run(runnable, priority);
    }

    public static void waitThread(Thread worker, Runnable task) throws InterruptedException {
        m_tpool.waitThread(worker, task);
    }

    public static class ThreadController {
        public Thread run(Runnable task, int priority) {
            SafeThread t = new SafeThread(task);
            t.start();
            return t;
        }

        public void waitThread(Thread worker, Runnable task) throws InterruptedException {
            worker.join();
        }

        final class SafeThread
        extends Thread {
            private volatile boolean ran;

            public SafeThread(Runnable target) {
                super(target);
                this.ran = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                if (Thread.currentThread() != this) {
                    throw new IllegalStateException("The run() method in a SafeThread cannot be called from another thread.");
                }
                SafeThread safeThread = this;
                synchronized (safeThread) {
                    if (this.ran) {
                        throw new IllegalStateException("The run() method in a SafeThread cannot be called more than once.");
                    }
                    this.ran = true;
                }
                super.run();
            }
        }
    }
}

