/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xml.external.utils;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import jdk7u.jaxp.org.apache.xml.external.res.XMLMessages;
import jdk7u.jaxp.org.apache.xml.external.utils.SAXSourceLocator;
import jdk7u.jaxp.org.apache.xml.external.utils.WrappedRuntimeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DefaultErrorHandler
implements ErrorHandler,
ErrorListener {
    PrintWriter m_pw;
    boolean m_throwExceptionOnError = true;

    public DefaultErrorHandler(PrintWriter pw) {
        this.m_pw = pw;
    }

    public DefaultErrorHandler(PrintStream pw) {
        this.m_pw = new PrintWriter(pw, true);
    }

    public DefaultErrorHandler() {
        this(true);
    }

    public DefaultErrorHandler(boolean throwExceptionOnError) {
        this.m_pw = new PrintWriter(System.err, true);
        this.m_throwExceptionOnError = throwExceptionOnError;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        DefaultErrorHandler.printLocation(this.m_pw, (Throwable)exception);
        this.m_pw.println("Parser warning: " + exception.getMessage());
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        DefaultErrorHandler.printLocation(this.m_pw, (Throwable)exception);
        this.m_pw.println(exception.getMessage());
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        if (this.m_throwExceptionOnError) {
            throw exception;
        }
        DefaultErrorHandler.printLocation(this.m_pw, (Throwable)exception);
        this.m_pw.println(exception.getMessage());
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        if (this.m_throwExceptionOnError) {
            throw exception;
        }
        DefaultErrorHandler.printLocation(this.m_pw, (Throwable)exception);
        this.m_pw.println(exception.getMessage());
    }

    public static void ensureLocationSet(TransformerException exception) {
        SourceLocator locator = null;
        Throwable cause = exception;
        do {
            SourceLocator causeLocator;
            if (cause instanceof SAXParseException) {
                locator = new SAXSourceLocator((SAXParseException)cause);
                continue;
            }
            if (!(cause instanceof TransformerException) || null == (causeLocator = cause.getLocator())) continue;
            locator = causeLocator;
        } while (null != (cause = cause instanceof TransformerException ? cause.getCause() : (cause instanceof SAXException ? ((SAXException)cause).getException() : null)));
        exception.setLocator(locator);
    }

    public static void printLocation(PrintStream pw, TransformerException exception) {
        DefaultErrorHandler.printLocation(new PrintWriter(pw), (Throwable)exception);
    }

    public static void printLocation(PrintStream pw, SAXParseException exception) {
        DefaultErrorHandler.printLocation(new PrintWriter(pw), (Throwable)exception);
    }

    public static void printLocation(PrintWriter pw, Throwable exception) {
        SourceLocator locator = null;
        Throwable cause = exception;
        do {
            SourceLocator causeLocator;
            if (cause instanceof SAXParseException) {
                locator = new SAXSourceLocator((SAXParseException)cause);
                continue;
            }
            if (!(cause instanceof TransformerException) || null == (causeLocator = ((TransformerException)cause).getLocator())) continue;
            locator = causeLocator;
        } while (null != (cause = cause instanceof TransformerException ? ((TransformerException)cause).getCause() : (cause instanceof WrappedRuntimeException ? ((WrappedRuntimeException)cause).getException() : (cause instanceof SAXException ? ((SAXException)cause).getException() : null))));
        if (null != locator) {
            String id = null != locator.getPublicId() ? locator.getPublicId() : (null != locator.getSystemId() ? locator.getSystemId() : XMLMessages.createXMLMessage("ER_SYSTEMID_UNKNOWN", null));
            pw.print(id + "; " + XMLMessages.createXMLMessage("line", null) + locator.getLineNumber() + "; " + XMLMessages.createXMLMessage("column", null) + locator.getColumnNumber() + "; ");
        } else {
            pw.print("(" + XMLMessages.createXMLMessage("ER_LOCATION_UNKNOWN", null) + ")");
        }
    }
}

