/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xml.external.serialize;

import java.io.IOException;
import jdk7u.jaxp.org.apache.xml.external.serialize.BaseMarkupSerializer;
import jdk7u.jaxp.org.apache.xml.external.serialize.ElementState;
import jdk7u.jaxp.org.apache.xml.external.serialize.OutputFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TextSerializer
extends BaseMarkupSerializer {
    public TextSerializer() {
        super(new OutputFormat("text", null, false));
    }

    @Override
    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("text", null, false));
    }

    @Override
    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        this.startElement(rawName == null ? localName : rawName, null);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        this.endElement(rawName == null ? localName : rawName);
    }

    @Override
    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        try {
            ElementState state = this.getElementState();
            if (this.isDocumentState() && !this._started) {
                this.startDocument(tagName);
            }
            boolean preserveSpace = state.preserveSpace;
            state = this.enterElementState(null, null, tagName, preserveSpace);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    @Override
    public void endElement(String tagName) throws SAXException {
        try {
            this.endElementIO(tagName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String tagName) throws IOException {
        ElementState state = this.getElementState();
        state = this.leaveElementState();
        state.afterElement = true;
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    @Override
    public void processingInstructionIO(String target, String code) throws IOException {
    }

    @Override
    public void comment(String text) {
    }

    @Override
    public void comment(char[] chars, int start, int length) {
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        try {
            ElementState state = this.content();
            state.inCData = false;
            state.doCData = false;
            this.printText(chars, start, length, true, true);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    protected void characters(String text, boolean unescaped) throws IOException {
        ElementState state = this.content();
        state.inCData = false;
        state.doCData = false;
        this.printText(text, true, true);
    }

    protected void startDocument(String rootTagName) throws IOException {
        this._printer.leaveDTD();
        this._started = true;
        this.serializePreRoot();
    }

    @Override
    protected void serializeElement(Element elem) throws IOException {
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState() && !this._started) {
            this.startDocument(tagName);
        }
        boolean preserveSpace = state.preserveSpace;
        if (elem.hasChildNodes()) {
            state = this.enterElementState(null, null, tagName, preserveSpace);
            for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.serializeNode(child);
            }
            this.endElementIO(tagName);
        } else if (!this.isDocumentState()) {
            state.afterElement = true;
            state.empty = false;
        }
    }

    @Override
    protected void serializeNode(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 3: {
                String text = node.getNodeValue();
                if (text == null) break;
                this.characters(node.getNodeValue(), true);
                break;
            }
            case 4: {
                String text = node.getNodeValue();
                if (text == null) break;
                this.characters(node.getNodeValue(), true);
                break;
            }
            case 8: {
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                this.serializeElement((Element)node);
                break;
            }
            case 9: 
            case 11: {
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.serializeNode(child);
                }
                break;
            }
        }
    }

    @Override
    protected ElementState content() {
        ElementState state = this.getElementState();
        if (!this.isDocumentState()) {
            if (state.empty) {
                state.empty = false;
            }
            state.afterElement = false;
        }
        return state;
    }

    @Override
    protected String getEntityRef(int ch) {
        return null;
    }
}

