/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xml.external.serialize;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import jdk7u.jaxp.org.apache.xerces.external.dom.DOMMessageFormatter;
import jdk7u.jaxp.org.apache.xml.external.serialize.HTMLSerializer;
import jdk7u.jaxp.org.apache.xml.external.serialize.OutputFormat;
import jdk7u.jaxp.org.apache.xml.external.serialize.Serializer;
import jdk7u.jaxp.org.apache.xml.external.serialize.SerializerFactory;
import jdk7u.jaxp.org.apache.xml.external.serialize.TextSerializer;
import jdk7u.jaxp.org.apache.xml.external.serialize.XHTMLSerializer;
import jdk7u.jaxp.org.apache.xml.external.serialize.XMLSerializer;

final class SerializerFactoryImpl
extends SerializerFactory {
    private String _method;

    SerializerFactoryImpl(String method) {
        this._method = method;
        if (!(this._method.equals("xml") || this._method.equals("html") || this._method.equals("xhtml") || this._method.equals("text"))) {
            String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{method});
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public Serializer makeSerializer(OutputFormat format) {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputFormat(format);
        return serializer;
    }

    @Override
    public Serializer makeSerializer(Writer writer, OutputFormat format) {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputCharStream(writer);
        return serializer;
    }

    @Override
    public Serializer makeSerializer(OutputStream output, OutputFormat format) throws UnsupportedEncodingException {
        Serializer serializer = this.getSerializer(format);
        serializer.setOutputByteStream(output);
        return serializer;
    }

    private Serializer getSerializer(OutputFormat format) {
        if (this._method.equals("xml")) {
            return new XMLSerializer(format);
        }
        if (this._method.equals("html")) {
            return new HTMLSerializer(format);
        }
        if (this._method.equals("xhtml")) {
            return new XHTMLSerializer(format);
        }
        if (this._method.equals("text")) {
            return new TextSerializer();
        }
        String msg = DOMMessageFormatter.formatMessage("http://apache.org/xml/serializer", "MethodNotSupported", new Object[]{this._method});
        throw new IllegalStateException(msg);
    }

    @Override
    protected String getSupportedMethod() {
        return this._method;
    }
}

