/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import jdk7u.jaxp.org.apache.xerces.external.utils.ObjectFactory;

public final class SecuritySupport {
    private static final SecuritySupport securitySupport = new SecuritySupport();
    static final Properties cacheProps = new Properties();
    static volatile boolean firstTime = true;

    public static SecuritySupport getInstance() {
        return securitySupport;
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    static ClassLoader getSystemClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = null;
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl;
            }
        });
    }

    static ClassLoader getParentClassLoader(final ClassLoader cl) {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader parent = null;
                try {
                    parent = cl.getParent();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return parent == cl ? null : parent;
            }
        });
    }

    public static String getSystemProperty(final String propName) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(propName);
            }
        });
    }

    static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    public static InputStream getResourceAsStream(String name) {
        if (System.getSecurityManager() != null) {
            return SecuritySupport.getResourceAsStream(null, name);
        }
        return SecuritySupport.getResourceAsStream(ObjectFactory.findClassLoader(), name);
    }

    public static InputStream getResourceAsStream(final ClassLoader cl, final String name) {
        return (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InputStream ris = cl == null ? Object.class.getResourceAsStream("/" + name) : cl.getResourceAsStream(name);
                return ris;
            }
        });
    }

    public static ResourceBundle getResourceBundle(String bundle) {
        return SecuritySupport.getResourceBundle(bundle, Locale.getDefault());
    }

    public static ResourceBundle getResourceBundle(final String bundle, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                try {
                    return PropertyResourceBundle.getBundle(bundle, locale);
                }
                catch (MissingResourceException e) {
                    try {
                        return PropertyResourceBundle.getBundle(bundle, new Locale("en", "US"));
                    }
                    catch (MissingResourceException e2) {
                        throw new MissingResourceException("Could not load any resource bundle by " + bundle, bundle, "");
                    }
                }
            }
        });
    }

    static boolean getFileExists(final File f) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return f.exists() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    static long getLastModified(final File f) {
        return (Long)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Long(f.lastModified());
            }
        });
    }

    public static String sanitizePath(String uri) {
        if (uri == null) {
            return "";
        }
        int i = uri.lastIndexOf("/");
        if (i > 0) {
            return uri.substring(i + 1, uri.length());
        }
        return uri;
    }

    public static String checkAccess(String systemId, String allowedProtocols, String accessAny) throws IOException {
        String protocol;
        if (systemId == null || allowedProtocols != null && allowedProtocols.equalsIgnoreCase(accessAny)) {
            return null;
        }
        if (systemId.indexOf(":") == -1) {
            protocol = "file";
        } else {
            URL url = new URL(systemId);
            protocol = url.getProtocol();
            if (protocol.equalsIgnoreCase("jar")) {
                String path = url.getPath();
                protocol = path.substring(0, path.indexOf(":"));
            }
        }
        if (SecuritySupport.isProtocolAllowed(protocol, allowedProtocols)) {
            return null;
        }
        return protocol;
    }

    private static boolean isProtocolAllowed(String protocol, String allowedProtocols) {
        String[] temp;
        if (allowedProtocols == null) {
            return false;
        }
        for (String t : temp = allowedProtocols.split(",")) {
            if (!(t = t.trim()).equalsIgnoreCase(protocol)) continue;
            return true;
        }
        return false;
    }

    public static String getJAXPSystemProperty(String sysPropertyId) {
        String accessExternal = SecuritySupport.getSystemProperty(sysPropertyId);
        if (accessExternal == null) {
            accessExternal = SecuritySupport.readJAXPProperty(sysPropertyId);
        }
        return accessExternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readJAXPProperty(String propertyId) {
        String value = null;
        InputStream is = null;
        try {
            if (firstTime) {
                Properties properties = cacheProps;
                synchronized (properties) {
                    if (firstTime) {
                        String configFile = SecuritySupport.getSystemProperty("java.home") + File.separator + "lib" + File.separator + "jaxp.properties";
                        File f = new File(configFile);
                        if (SecuritySupport.getFileExists(f)) {
                            is = SecuritySupport.getFileInputStream(f);
                            cacheProps.load(is);
                        }
                        firstTime = false;
                    }
                }
            }
            value = cacheProps.getProperty(propertyId);
        }
        catch (Exception ex) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return value;
    }

    private SecuritySupport() {
    }
}

