/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.util;

import jdk7u.jaxp.org.apache.xerces.external.xni.XMLString;

public class XMLStringBuffer
extends XMLString {
    public static final int DEFAULT_SIZE = 32;

    public XMLStringBuffer() {
        this(32);
    }

    public XMLStringBuffer(int size) {
        this.ch = new char[size];
    }

    public XMLStringBuffer(char c) {
        this(1);
        this.append(c);
    }

    public XMLStringBuffer(String s) {
        this(s.length());
        this.append(s);
    }

    public XMLStringBuffer(char[] ch, int offset, int length) {
        this(length);
        this.append(ch, offset, length);
    }

    public XMLStringBuffer(XMLString s) {
        this(s.length);
        this.append(s);
    }

    @Override
    public void clear() {
        this.offset = 0;
        this.length = 0;
    }

    public void append(char c) {
        if (this.length + 1 > this.ch.length) {
            int newLength = this.ch.length * 2;
            if (newLength < this.ch.length + 32) {
                newLength = this.ch.length + 32;
            }
            char[] tmp = new char[newLength];
            System.arraycopy(this.ch, 0, tmp, 0, this.length);
            this.ch = tmp;
        }
        this.ch[this.length] = c;
        ++this.length;
    }

    public void append(String s) {
        int length = s.length();
        if (this.length + length > this.ch.length) {
            int newLength = this.ch.length * 2;
            if (newLength < this.ch.length + length + 32) {
                newLength = this.ch.length + length + 32;
            }
            char[] newch = new char[newLength];
            System.arraycopy(this.ch, 0, newch, 0, this.length);
            this.ch = newch;
        }
        s.getChars(0, length, this.ch, this.length);
        this.length += length;
    }

    public void append(char[] ch, int offset, int length) {
        if (this.length + length > this.ch.length) {
            int newLength = this.ch.length * 2;
            if (newLength < this.ch.length + length + 32) {
                newLength = this.ch.length + length + 32;
            }
            char[] newch = new char[newLength];
            System.arraycopy(this.ch, 0, newch, 0, this.length);
            this.ch = newch;
        }
        if (ch != null && length > 0) {
            System.arraycopy(ch, offset, this.ch, this.length, length);
            this.length += length;
        }
    }

    public void append(XMLString s) {
        this.append(s.ch, s.offset, s.length);
    }
}

