/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.util;

import java.util.Hashtable;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSTypeDefinition;
import org.w3c.dom.TypeInfo;

public class TypeInfoImpl
implements TypeInfo {
    private final String typeNamespace;
    private final String typeName;
    private static final String dtdNamespaceURI = "http://www.w3.org/TR/REC-xml";
    private static final Hashtable dtdCache = new Hashtable();

    public TypeInfoImpl() {
        this.typeNamespace = null;
        this.typeName = null;
    }

    public TypeInfoImpl(String typeNamespace, String typeName) {
        this.typeNamespace = typeNamespace;
        this.typeName = typeName;
    }

    public TypeInfoImpl(XSTypeDefinition t) {
        this(t.getNamespace(), t.getName());
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getTypeNamespace() {
        return this.typeNamespace;
    }

    @Override
    public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) {
        return false;
    }

    public static TypeInfo getDTDTypeInfo(String name) {
        TypeInfo t = (TypeInfo)dtdCache.get(name);
        if (t == null) {
            throw new IllegalArgumentException("Unknown DTD datatype " + name);
        }
        return t;
    }

    static {
        String[] typeNames = new String[]{"CDATA", "ID", "IDREF", "IDREFS", "NMTOKEN", "NMTOKENS", "ENTITY", "ENTITIES", "NOTATION"};
        for (int i = 0; i < typeNames.length; ++i) {
            dtdCache.put(typeNames[i], new TypeInfoImpl(dtdNamespaceURI, typeNames[i]));
        }
    }
}

