/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLResourceIdentifier;
import jdk7u.jaxp.org.apache.xerces.external.xni.XNIException;
import jdk7u.jaxp.org.apache.xerces.external.xni.grammars.XMLGrammarDescription;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLEntityResolver;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLInputSource;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class DOMEntityResolverWrapper
implements XMLEntityResolver {
    private static final String XML_TYPE = "http://www.w3.org/TR/REC-xml";
    private static final String XSD_TYPE = "http://www.w3.org/2001/XMLSchema";
    protected LSResourceResolver fEntityResolver;

    public DOMEntityResolverWrapper() {
    }

    public DOMEntityResolverWrapper(LSResourceResolver entityResolver) {
        this.setEntityResolver(entityResolver);
    }

    public void setEntityResolver(LSResourceResolver entityResolver) {
        this.fEntityResolver = entityResolver;
    }

    public LSResourceResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        if (this.fEntityResolver != null) {
            LSInput inputSource;
            LSInput lSInput = inputSource = resourceIdentifier == null ? this.fEntityResolver.resolveResource(null, null, null, null, null) : this.fEntityResolver.resolveResource(this.getType(resourceIdentifier), resourceIdentifier.getNamespace(), resourceIdentifier.getPublicId(), resourceIdentifier.getLiteralSystemId(), resourceIdentifier.getBaseSystemId());
            if (inputSource != null) {
                String publicId = inputSource.getPublicId();
                String systemId = inputSource.getSystemId();
                String baseSystemId = inputSource.getBaseURI();
                InputStream byteStream = inputSource.getByteStream();
                Reader charStream = inputSource.getCharacterStream();
                String encoding = inputSource.getEncoding();
                String data = inputSource.getStringData();
                XMLInputSource xmlInputSource = new XMLInputSource(publicId, systemId, baseSystemId);
                if (charStream != null) {
                    xmlInputSource.setCharacterStream(charStream);
                } else if (byteStream != null) {
                    xmlInputSource.setByteStream(byteStream);
                } else if (data != null && data.length() != 0) {
                    xmlInputSource.setCharacterStream(new StringReader(data));
                }
                xmlInputSource.setEncoding(encoding);
                return xmlInputSource;
            }
        }
        return null;
    }

    private String getType(XMLResourceIdentifier resourceIdentifier) {
        XMLGrammarDescription desc;
        if (resourceIdentifier instanceof XMLGrammarDescription && XSD_TYPE.equals((desc = (XMLGrammarDescription)resourceIdentifier).getGrammarType())) {
            return XSD_TYPE;
        }
        return XML_TYPE;
    }
}

