/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.parsers;

import java.io.IOException;
import jdk7u.jaxp.org.apache.xerces.external.utils.XMLSecurityManager;
import jdk7u.jaxp.org.apache.xerces.external.utils.XMLSecurityPropertyManager;
import jdk7u.jaxp.org.apache.xerces.external.xni.XNIException;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLInputSource;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLParserConfiguration;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class XMLParser {
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/error-handler"};
    protected XMLParserConfiguration fConfiguration;
    XMLSecurityManager securityManager;
    XMLSecurityPropertyManager securityPropertyManager;

    public boolean getFeature(String featureId) throws SAXNotSupportedException, SAXNotRecognizedException {
        return this.fConfiguration.getFeature(featureId);
    }

    protected XMLParser(XMLParserConfiguration config) {
        this.fConfiguration = config;
        this.fConfiguration.addRecognizedProperties(RECOGNIZED_PROPERTIES);
    }

    public void parse(XMLInputSource inputSource) throws XNIException, IOException {
        if (this.securityManager == null) {
            this.securityManager = new XMLSecurityManager(true);
            this.fConfiguration.setProperty("http://apache.org/xml/properties/security-manager", this.securityManager);
        }
        if (this.securityPropertyManager == null) {
            this.securityPropertyManager = new XMLSecurityPropertyManager();
            this.fConfiguration.setProperty("http://www.oracle.com/xml/jaxp/properties/xmlSecurityPropertyManager", this.securityPropertyManager);
        }
        this.reset();
        this.fConfiguration.parse(inputSource);
    }

    protected void reset() throws XNIException {
    }
}

