/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.jaxp.validation;

import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stax.StAXResult;
import jdk7u.jaxp.org.apache.xerces.external.jaxp.validation.JAXPValidationMessageFormatter;
import jdk7u.jaxp.org.apache.xerces.external.jaxp.validation.ValidatorHandlerImpl;
import jdk7u.jaxp.org.apache.xerces.external.jaxp.validation.ValidatorHelper;
import jdk7u.jaxp.org.apache.xerces.external.jaxp.validation.XMLSchemaValidatorComponentManager;
import jdk7u.jaxp.org.apache.xerces.external.utils.XMLSecurityManager;
import org.xml.sax.SAXException;

public final class StAXValidatorHelper
implements ValidatorHelper {
    private static final String DEFAULT_TRANSFORMER_IMPL = "jdk7u.jaxp.org.apache.xalan.external.xsltc.trax.TransformerFactoryImpl";
    private XMLSchemaValidatorComponentManager fComponentManager;
    private Transformer identityTransformer1 = null;
    private TransformerHandler identityTransformer2 = null;
    private ValidatorHandlerImpl handler = null;

    public StAXValidatorHelper(XMLSchemaValidatorComponentManager componentManager) {
        this.fComponentManager = componentManager;
    }

    @Override
    public void validate(Source source, Result result) throws SAXException, IOException {
        if (result == null || result instanceof StAXResult) {
            if (this.identityTransformer1 == null) {
                try {
                    SAXTransformerFactory tf = this.fComponentManager.getFeature("http://www.oracle.com/feature/use-service-mechanism") ? (SAXTransformerFactory)SAXTransformerFactory.newInstance() : (SAXTransformerFactory)TransformerFactory.newInstance(DEFAULT_TRANSFORMER_IMPL, StAXValidatorHelper.class.getClassLoader());
                    XMLSecurityManager securityManager = (XMLSecurityManager)this.fComponentManager.getProperty("http://apache.org/xml/properties/security-manager");
                    if (securityManager != null) {
                        for (XMLSecurityManager.Limit limit : XMLSecurityManager.Limit.values()) {
                            if (!securityManager.isSet(limit.ordinal())) continue;
                            tf.setAttribute(limit.apiProperty(), securityManager.getLimitValueAsString(limit));
                        }
                        if (securityManager.printEntityCountInfo()) {
                            tf.setAttribute("http://www.oracle.com/xml/jaxp/properties/getEntityCountInfo", "yes");
                        }
                    }
                    this.identityTransformer1 = tf.newTransformer();
                    this.identityTransformer2 = tf.newTransformerHandler();
                }
                catch (TransformerConfigurationException e) {
                    throw new TransformerFactoryConfigurationError(e);
                }
            }
            this.handler = new ValidatorHandlerImpl(this.fComponentManager);
            if (result != null) {
                this.handler.setContentHandler(this.identityTransformer2);
                this.identityTransformer2.setResult(result);
            }
            try {
                this.identityTransformer1.transform(source, new SAXResult(this.handler));
            }
            catch (TransformerException e) {
                if (e.getException() instanceof SAXException) {
                    throw (SAXException)e.getException();
                }
                throw new SAXException(e);
            }
            finally {
                this.handler.setContentHandler(null);
            }
            return;
        }
        throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fComponentManager.getLocale(), "SourceResultMismatch", new Object[]{source.getClass().getName(), result.getClass().getName()}));
    }
}

