/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.jaxp.validation;

import jdk7u.jaxp.org.apache.xerces.external.jaxp.validation.Util;
import jdk7u.jaxp.org.apache.xerces.external.jaxp.validation.WrappedSAXException;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLErrorHandler;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLParseException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class ErrorHandlerAdaptor
implements XMLErrorHandler {
    private boolean hadError = false;

    public boolean hadError() {
        return this.hadError;
    }

    public void reset() {
        this.hadError = false;
    }

    protected abstract ErrorHandler getErrorHandler();

    @Override
    public void fatalError(String domain, String key, XMLParseException e) {
        try {
            this.hadError = true;
            this.getErrorHandler().fatalError(Util.toSAXParseException(e));
        }
        catch (SAXException se) {
            throw new WrappedSAXException(se);
        }
    }

    @Override
    public void error(String domain, String key, XMLParseException e) {
        try {
            this.hadError = true;
            this.getErrorHandler().error(Util.toSAXParseException(e));
        }
        catch (SAXException se) {
            throw new WrappedSAXException(se);
        }
    }

    @Override
    public void warning(String domain, String key, XMLParseException e) {
        try {
            this.getErrorHandler().warning(Util.toSAXParseException(e));
        }
        catch (SAXException se) {
            throw new WrappedSAXException(se);
        }
    }
}

