/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.jaxp.validation;

import java.util.ArrayList;
import javax.xml.transform.dom.DOMResult;
import jdk7u.jaxp.org.apache.xerces.external.dom.AttrImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.CoreDocumentImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.DOMMessageFormatter;
import jdk7u.jaxp.org.apache.xerces.external.dom.DocumentTypeImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.ElementImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.ElementNSImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.EntityImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.NotationImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.PSVIAttrNSImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.PSVIDocumentImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.PSVIElementNSImpl;
import jdk7u.jaxp.org.apache.xerces.external.impl.dv.XSSimpleType;
import jdk7u.jaxp.org.apache.xerces.external.jaxp.validation.DOMDocumentHandler;
import jdk7u.jaxp.org.apache.xerces.external.xni.Augmentations;
import jdk7u.jaxp.org.apache.xerces.external.xni.NamespaceContext;
import jdk7u.jaxp.org.apache.xerces.external.xni.QName;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLAttributes;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLLocator;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLResourceIdentifier;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLString;
import jdk7u.jaxp.org.apache.xerces.external.xni.XNIException;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLDocumentSource;
import jdk7u.jaxp.org.apache.xerces.external.xs.AttributePSVI;
import jdk7u.jaxp.org.apache.xerces.external.xs.ElementPSVI;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSTypeDefinition;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

final class DOMResultBuilder
implements DOMDocumentHandler {
    private static final int[] kidOK = new int[13];
    private Document fDocument;
    private CoreDocumentImpl fDocumentImpl;
    private boolean fStorePSVI;
    private Node fTarget;
    private Node fNextSibling;
    private Node fCurrentNode;
    private Node fFragmentRoot;
    private final ArrayList fTargetChildren = new ArrayList();
    private boolean fIgnoreChars;
    private final QName fAttributeQName = new QName();

    @Override
    public void setDOMResult(DOMResult result) {
        this.fCurrentNode = null;
        this.fFragmentRoot = null;
        this.fIgnoreChars = false;
        this.fTargetChildren.clear();
        if (result != null) {
            this.fTarget = result.getNode();
            this.fNextSibling = result.getNextSibling();
            this.fDocument = this.fTarget.getNodeType() == 9 ? (Document)this.fTarget : this.fTarget.getOwnerDocument();
            this.fDocumentImpl = this.fDocument instanceof CoreDocumentImpl ? (CoreDocumentImpl)this.fDocument : null;
            this.fStorePSVI = this.fDocument instanceof PSVIDocumentImpl;
            return;
        }
        this.fTarget = null;
        this.fNextSibling = null;
        this.fDocument = null;
        this.fDocumentImpl = null;
        this.fStorePSVI = false;
    }

    @Override
    public void doctypeDecl(DocumentType node) throws XNIException {
        if (this.fDocumentImpl != null) {
            int i;
            DocumentType docType = this.fDocumentImpl.createDocumentType(node.getName(), node.getPublicId(), node.getSystemId());
            String internalSubset = node.getInternalSubset();
            if (internalSubset != null) {
                ((DocumentTypeImpl)docType).setInternalSubset(internalSubset);
            }
            NamedNodeMap oldMap = node.getEntities();
            NamedNodeMap newMap = docType.getEntities();
            int length = oldMap.getLength();
            for (i = 0; i < length; ++i) {
                Entity oldEntity = (Entity)oldMap.item(i);
                EntityImpl newEntity = (EntityImpl)this.fDocumentImpl.createEntity(oldEntity.getNodeName());
                newEntity.setPublicId(oldEntity.getPublicId());
                newEntity.setSystemId(oldEntity.getSystemId());
                newEntity.setNotationName(oldEntity.getNotationName());
                newMap.setNamedItem(newEntity);
            }
            oldMap = node.getNotations();
            newMap = docType.getNotations();
            length = oldMap.getLength();
            for (i = 0; i < length; ++i) {
                Notation oldNotation = (Notation)oldMap.item(i);
                NotationImpl newNotation = (NotationImpl)this.fDocumentImpl.createNotation(oldNotation.getNodeName());
                newNotation.setPublicId(oldNotation.getPublicId());
                newNotation.setSystemId(oldNotation.getSystemId());
                newMap.setNamedItem(newNotation);
            }
            this.append(docType);
        }
    }

    @Override
    public void characters(Text node) throws XNIException {
        this.append(this.fDocument.createTextNode(node.getNodeValue()));
    }

    @Override
    public void cdata(CDATASection node) throws XNIException {
        this.append(this.fDocument.createCDATASection(node.getNodeValue()));
    }

    @Override
    public void comment(Comment node) throws XNIException {
        this.append(this.fDocument.createComment(node.getNodeValue()));
    }

    @Override
    public void processingInstruction(ProcessingInstruction node) throws XNIException {
        this.append(this.fDocument.createProcessingInstruction(node.getTarget(), node.getData()));
    }

    @Override
    public void setIgnoringCharacters(boolean ignore) {
        this.fIgnoreChars = ignore;
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
    }

    @Override
    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
    }

    @Override
    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
    }

    @Override
    public void comment(XMLString text, Augmentations augs) throws XNIException {
    }

    @Override
    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Element elem;
        int attrCount = attributes.getLength();
        if (this.fDocumentImpl == null) {
            elem = this.fDocument.createElementNS(element.uri, element.rawname);
            for (int i = 0; i < attrCount; ++i) {
                attributes.getName(i, this.fAttributeQName);
                elem.setAttributeNS(this.fAttributeQName.uri, this.fAttributeQName.rawname, attributes.getValue(i));
            }
        } else {
            elem = this.fDocumentImpl.createElementNS(element.uri, element.rawname, element.localpart);
            for (int i = 0; i < attrCount; ++i) {
                attributes.getName(i, this.fAttributeQName);
                AttrImpl attr = (AttrImpl)this.fDocumentImpl.createAttributeNS(this.fAttributeQName.uri, this.fAttributeQName.rawname, this.fAttributeQName.localpart);
                attr.setValue(attributes.getValue(i));
                AttributePSVI attrPSVI = (AttributePSVI)attributes.getAugmentations(i).getItem("ATTRIBUTE_PSVI");
                if (attrPSVI != null) {
                    XSTypeDefinition type;
                    if (this.fStorePSVI) {
                        ((PSVIAttrNSImpl)attr).setPSVI(attrPSVI);
                    }
                    if ((type = attrPSVI.getMemberTypeDefinition()) == null) {
                        type = attrPSVI.getTypeDefinition();
                        if (type != null) {
                            attr.setType(type);
                            if (((XSSimpleType)type).isIDType()) {
                                ((ElementImpl)elem).setIdAttributeNode(attr, true);
                            }
                        }
                    } else {
                        attr.setType(type);
                        if (((XSSimpleType)type).isIDType()) {
                            ((ElementImpl)elem).setIdAttributeNode(attr, true);
                        }
                    }
                }
                attr.setSpecified(attributes.isSpecified(i));
                elem.setAttributeNode(attr);
            }
        }
        this.append(elem);
        this.fCurrentNode = elem;
        if (this.fFragmentRoot == null) {
            this.fFragmentRoot = elem;
        }
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    @Override
    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
    }

    @Override
    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
    }

    @Override
    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
    }

    @Override
    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (!this.fIgnoreChars) {
            this.append(this.fDocument.createTextNode(text.toString()));
        }
    }

    @Override
    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.characters(text, augs);
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        ElementPSVI elementPSVI;
        if (augs != null && this.fDocumentImpl != null && (elementPSVI = (ElementPSVI)augs.getItem("ELEMENT_PSVI")) != null) {
            XSTypeDefinition type;
            if (this.fStorePSVI) {
                ((PSVIElementNSImpl)this.fCurrentNode).setPSVI(elementPSVI);
            }
            if ((type = elementPSVI.getMemberTypeDefinition()) == null) {
                type = elementPSVI.getTypeDefinition();
            }
            ((ElementNSImpl)this.fCurrentNode).setType(type);
        }
        if (this.fCurrentNode == this.fFragmentRoot) {
            this.fCurrentNode = null;
            this.fFragmentRoot = null;
            return;
        }
        this.fCurrentNode = this.fCurrentNode.getParentNode();
    }

    @Override
    public void startCDATA(Augmentations augs) throws XNIException {
    }

    @Override
    public void endCDATA(Augmentations augs) throws XNIException {
    }

    @Override
    public void endDocument(Augmentations augs) throws XNIException {
        int length = this.fTargetChildren.size();
        if (this.fNextSibling == null) {
            for (int i = 0; i < length; ++i) {
                this.fTarget.appendChild((Node)this.fTargetChildren.get(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.fTarget.insertBefore((Node)this.fTargetChildren.get(i), this.fNextSibling);
            }
        }
    }

    @Override
    public void setDocumentSource(XMLDocumentSource source) {
    }

    @Override
    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    private void append(Node node) throws XNIException {
        if (this.fCurrentNode != null) {
            this.fCurrentNode.appendChild(node);
        } else {
            if ((kidOK[this.fTarget.getNodeType()] & 1 << node.getNodeType()) == 0) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                throw new XNIException(msg);
            }
            this.fTargetChildren.add(node);
        }
    }

    static {
        DOMResultBuilder.kidOK[9] = 1410;
        DOMResultBuilder.kidOK[1] = 442;
        DOMResultBuilder.kidOK[5] = 442;
        DOMResultBuilder.kidOK[6] = 442;
        DOMResultBuilder.kidOK[11] = 442;
        DOMResultBuilder.kidOK[2] = 40;
        DOMResultBuilder.kidOK[10] = 0;
        DOMResultBuilder.kidOK[7] = 0;
        DOMResultBuilder.kidOK[8] = 0;
        DOMResultBuilder.kidOK[3] = 0;
        DOMResultBuilder.kidOK[4] = 0;
        DOMResultBuilder.kidOK[12] = 0;
    }
}

