/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.jaxp.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import jdk7u.jaxp.org.apache.xerces.external.jaxp.datatype.DurationImpl;

class DurationDayTimeImpl
extends DurationImpl {
    public DurationDayTimeImpl(boolean isPositive, BigInteger days, BigInteger hours, BigInteger minutes, BigDecimal seconds) {
        super(isPositive, null, null, days, hours, minutes, seconds);
        this.convertToCanonicalDayTime();
    }

    public DurationDayTimeImpl(boolean isPositive, int days, int hours, int minutes, int seconds) {
        this(isPositive, DurationDayTimeImpl.wrap(days), DurationDayTimeImpl.wrap(hours), DurationDayTimeImpl.wrap(minutes), seconds != Integer.MIN_VALUE ? new BigDecimal(String.valueOf(seconds)) : null);
    }

    protected DurationDayTimeImpl(String lexicalRepresentation) {
        super(lexicalRepresentation);
        if (this.getYears() > 0 || this.getMonths() > 0) {
            throw new IllegalArgumentException("Trying to create an xdt:dayTimeDuration with an invalid lexical representation of \"" + lexicalRepresentation + "\", data model requires a format PnDTnHnMnS.");
        }
        this.convertToCanonicalDayTime();
    }

    protected DurationDayTimeImpl(long durationInMilliseconds) {
        super(durationInMilliseconds);
        this.convertToCanonicalDayTime();
        this.years = null;
        this.months = null;
    }

    public float getValue() {
        float sec = this.seconds == null ? 0.0f : this.seconds.floatValue();
        return (float)(((this.getDays() * 24 + this.getHours()) * 60 + this.getMinutes()) * 60) + sec;
    }

    private void convertToCanonicalDayTime() {
        while (this.getSeconds() >= 60) {
            this.seconds = this.seconds.subtract(BigDecimal.valueOf(60L));
            this.minutes = BigInteger.valueOf(this.getMinutes()).add(BigInteger.ONE);
        }
        while (this.getMinutes() >= 60) {
            this.minutes = this.minutes.subtract(BigInteger.valueOf(60L));
            this.hours = BigInteger.valueOf(this.getHours()).add(BigInteger.ONE);
        }
        while (this.getHours() >= 24) {
            this.hours = this.hours.subtract(BigInteger.valueOf(24L));
            this.days = BigInteger.valueOf(this.getDays()).add(BigInteger.ONE);
        }
    }
}

