/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.jaxp;

import java.util.Locale;
import jdk7u.jaxp.org.apache.xerces.external.util.SAXMessageFormatter;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class DefaultValidationErrorHandler
extends DefaultHandler {
    private static int ERROR_COUNT_LIMIT = 10;
    private int errorCount = 0;
    private Locale locale = Locale.getDefault();

    public DefaultValidationErrorHandler(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        String systemId;
        if (this.errorCount >= ERROR_COUNT_LIMIT) {
            return;
        }
        if (this.errorCount == 0) {
            System.err.println(SAXMessageFormatter.formatMessage(this.locale, "errorHandlerNotSet", new Object[]{this.errorCount}));
        }
        if ((systemId = e.getSystemId()) == null) {
            systemId = "null";
        }
        String message = "Error: URI=" + systemId + " Line=" + e.getLineNumber() + ": " + e.getMessage();
        System.err.println(message);
        ++this.errorCount;
    }
}

