/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.impl.xs.traversers;

import jdk7u.jaxp.org.apache.xerces.external.impl.xs.SchemaGrammar;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.SchemaSymbols;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.XSElementDecl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.identity.IdentityConstraint;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.identity.KeyRef;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.identity.UniqueOrKey;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.traversers.XSAttributeChecker;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.traversers.XSDAbstractIDConstraintTraverser;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.traversers.XSDHandler;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.traversers.XSDocumentInfo;
import jdk7u.jaxp.org.apache.xerces.external.xni.QName;
import org.w3c.dom.Element;

class XSDKeyrefTraverser
extends XSDAbstractIDConstraintTraverser {
    public XSDKeyrefTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    void traverse(Element krElem, XSElementDecl element, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(krElem, false, schemaDoc);
        String krName = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        if (krName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_KEYREF, SchemaSymbols.ATT_NAME}, krElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        QName kName = (QName)attrValues[XSAttributeChecker.ATTIDX_REFER];
        if (kName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_KEYREF, SchemaSymbols.ATT_REFER}, krElem);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        UniqueOrKey key = null;
        IdentityConstraint ret = (IdentityConstraint)this.fSchemaHandler.getGlobalDecl(schemaDoc, 5, kName, krElem);
        if (ret != null) {
            if (ret.getCategory() == 1 || ret.getCategory() == 3) {
                key = (UniqueOrKey)ret;
            } else {
                this.reportSchemaError("src-resolve", new Object[]{kName.rawname, "identity constraint key/unique"}, krElem);
            }
        }
        if (key == null) {
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return;
        }
        KeyRef keyRef = new KeyRef(schemaDoc.fTargetNamespace, krName, element.fName, key);
        if (this.traverseIdentityConstraint(keyRef, krElem, schemaDoc, attrValues)) {
            if (key.getFieldCount() != keyRef.getFieldCount()) {
                this.reportSchemaError("c-props-correct.2", new Object[]{krName, key.getIdentityConstraintName()}, krElem);
            } else {
                if (grammar.getIDConstraintDecl(keyRef.getIdentityConstraintName()) == null) {
                    grammar.addIDConstraintDecl(element, keyRef);
                }
                String loc = this.fSchemaHandler.schemaDocument2SystemId(schemaDoc);
                IdentityConstraint idc = grammar.getIDConstraintDecl(keyRef.getIdentityConstraintName(), loc);
                if (idc == null) {
                    grammar.addIDConstraintDecl(element, keyRef, loc);
                }
                if (this.fSchemaHandler.fTolerateDuplicates) {
                    if (idc != null && idc instanceof KeyRef) {
                        keyRef = (KeyRef)idc;
                    }
                    this.fSchemaHandler.addIDConstraintDecl(keyRef);
                }
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
    }
}

