/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.impl.xs.models;

import jdk7u.jaxp.org.apache.xerces.external.impl.dtd.models.CMNode;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.XSComplexTypeDecl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.XSDeclarationPool;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.XSElementDecl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.XSModelGroupImpl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.XSParticleDecl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.models.CMNodeFactory;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.models.XSAllCM;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.models.XSCMBinOp;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.models.XSCMLeaf;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.models.XSCMUniOp;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.models.XSCMValidator;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.models.XSDFACM;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.models.XSEmptyCM;

public class CMBuilder {
    private XSDeclarationPool fDeclPool = null;
    private static XSEmptyCM fEmptyCM = new XSEmptyCM();
    private int fLeafCount;
    private int fParticleCount;
    private CMNodeFactory fNodeFactory;

    public CMBuilder(CMNodeFactory nodeFactory) {
        this.fNodeFactory = nodeFactory;
    }

    public void setDeclPool(XSDeclarationPool declPool) {
        this.fDeclPool = declPool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl typeDecl) {
        short contentType = typeDecl.getContentType();
        if (contentType == 1 || contentType == 0) {
            return null;
        }
        XSParticleDecl particle = (XSParticleDecl)typeDecl.getParticle();
        if (particle == null) {
            return fEmptyCM;
        }
        XSCMValidator cmValidator = null;
        cmValidator = particle.fType == 3 && ((XSModelGroupImpl)particle.fValue).fCompositor == 103 ? this.createAllCM(particle) : this.createDFACM(particle);
        this.fNodeFactory.resetNodeCount();
        if (cmValidator == null) {
            cmValidator = fEmptyCM;
        }
        return cmValidator;
    }

    XSCMValidator createAllCM(XSParticleDecl particle) {
        if (particle.fMaxOccurs == 0) {
            return null;
        }
        XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
        XSAllCM allContent = new XSAllCM(particle.fMinOccurs == 0, group.fParticleCount);
        for (int i = 0; i < group.fParticleCount; ++i) {
            allContent.addElement((XSElementDecl)group.fParticles[i].fValue, group.fParticles[i].fMinOccurs == 0);
        }
        return allContent;
    }

    XSCMValidator createDFACM(XSParticleDecl particle) {
        CMNode node;
        this.fLeafCount = 0;
        this.fParticleCount = 0;
        CMNode cMNode = node = this.useRepeatingLeafNodes(particle) ? this.buildCompactSyntaxTree(particle) : this.buildSyntaxTree(particle, true);
        if (node == null) {
            return null;
        }
        return new XSDFACM(node, this.fLeafCount);
    }

    private CMNode buildSyntaxTree(XSParticleDecl particle, boolean optimize) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        short type = particle.fType;
        CMNode nodeRet = null;
        if (type == 2 || type == 1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.expandContentModel(nodeRet, minOccurs, maxOccurs, optimize);
        } else if (type == 3) {
            XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
            CMNode temp = null;
            boolean twoChildren = false;
            for (int i = 0; i < group.fParticleCount; ++i) {
                temp = this.buildSyntaxTree(group.fParticles[i], optimize && minOccurs == 1 && maxOccurs == 1 && (group.fCompositor == 102 || group.fParticleCount == 1));
                if (temp == null) continue;
                if (nodeRet == null) {
                    nodeRet = temp;
                    continue;
                }
                nodeRet = this.fNodeFactory.getCMBinOpNode(group.fCompositor, nodeRet, temp);
                twoChildren = true;
            }
            if (nodeRet != null) {
                if (group.fCompositor == 101 && !twoChildren && group.fParticleCount > 1) {
                    nodeRet = this.fNodeFactory.getCMUniOpNode(5, nodeRet);
                }
                nodeRet = this.expandContentModel(nodeRet, minOccurs, maxOccurs, false);
            }
        }
        return nodeRet;
    }

    private CMNode expandContentModel(CMNode node, int minOccurs, int maxOccurs, boolean optimize) {
        CMNode nodeRet = null;
        if (minOccurs == 1 && maxOccurs == 1) {
            nodeRet = node;
        } else if (minOccurs == 0 && maxOccurs == 1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(5, node);
        } else if (minOccurs == 0 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(4, node);
        } else if (minOccurs == 1 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(6, node);
        } else if (optimize && node.type() == 1 || node.type() == 2) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(minOccurs == 0 ? 4 : 6, node);
            nodeRet.setUserData(new int[]{minOccurs, maxOccurs});
        } else if (maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMUniOpNode(6, node);
            nodeRet = this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(node, minOccurs - 1, true), nodeRet);
        } else {
            if (minOccurs > 0) {
                nodeRet = this.multiNodes(node, minOccurs, false);
            }
            if (maxOccurs > minOccurs) {
                node = this.fNodeFactory.getCMUniOpNode(5, node);
                nodeRet = nodeRet == null ? this.multiNodes(node, maxOccurs - minOccurs, false) : this.fNodeFactory.getCMBinOpNode(102, nodeRet, this.multiNodes(node, maxOccurs - minOccurs, true));
            }
        }
        return nodeRet;
    }

    private CMNode multiNodes(CMNode node, int num, boolean copyFirst) {
        if (num == 0) {
            return null;
        }
        if (num == 1) {
            return copyFirst ? this.copyNode(node) : node;
        }
        int num1 = num / 2;
        return this.fNodeFactory.getCMBinOpNode(102, this.multiNodes(node, num1, copyFirst), this.multiNodes(node, num - num1, true));
    }

    private CMNode copyNode(CMNode node) {
        int type = node.type();
        if (type == 101 || type == 102) {
            XSCMBinOp bin = (XSCMBinOp)node;
            node = this.fNodeFactory.getCMBinOpNode(type, this.copyNode(bin.getLeft()), this.copyNode(bin.getRight()));
        } else if (type == 4 || type == 6 || type == 5) {
            XSCMUniOp uni = (XSCMUniOp)node;
            node = this.fNodeFactory.getCMUniOpNode(type, this.copyNode(uni.getChild()));
        } else if (type == 1 || type == 2) {
            XSCMLeaf leaf = (XSCMLeaf)node;
            node = this.fNodeFactory.getCMLeafNode(leaf.type(), leaf.getLeaf(), leaf.getParticleId(), this.fLeafCount++);
        }
        return node;
    }

    private CMNode buildCompactSyntaxTree(XSParticleDecl particle) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        short type = particle.fType;
        CMNode nodeRet = null;
        if (type == 2 || type == 1) {
            return this.buildCompactSyntaxTree2(particle, minOccurs, maxOccurs);
        }
        if (type == 3) {
            XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
            if (group.fParticleCount == 1 && (minOccurs != 1 || maxOccurs != 1)) {
                return this.buildCompactSyntaxTree2(group.fParticles[0], minOccurs, maxOccurs);
            }
            CMNode temp = null;
            int count = 0;
            for (int i = 0; i < group.fParticleCount; ++i) {
                temp = this.buildCompactSyntaxTree(group.fParticles[i]);
                if (temp == null) continue;
                ++count;
                nodeRet = nodeRet == null ? temp : this.fNodeFactory.getCMBinOpNode(group.fCompositor, nodeRet, temp);
            }
            if (nodeRet != null && group.fCompositor == 101 && count < group.fParticleCount) {
                nodeRet = this.fNodeFactory.getCMUniOpNode(5, nodeRet);
            }
        }
        return nodeRet;
    }

    private CMNode buildCompactSyntaxTree2(XSParticleDecl particle, int minOccurs, int maxOccurs) {
        CMNode nodeRet = null;
        if (minOccurs == 1 && maxOccurs == 1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
        } else if (minOccurs == 0 && maxOccurs == 1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.fNodeFactory.getCMUniOpNode(5, nodeRet);
        } else if (minOccurs == 0 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.fNodeFactory.getCMUniOpNode(4, nodeRet);
        } else if (minOccurs == 1 && maxOccurs == -1) {
            nodeRet = this.fNodeFactory.getCMLeafNode(particle.fType, particle.fValue, this.fParticleCount++, this.fLeafCount++);
            nodeRet = this.fNodeFactory.getCMUniOpNode(6, nodeRet);
        } else {
            nodeRet = this.fNodeFactory.getCMRepeatingLeafNode(particle.fType, particle.fValue, minOccurs, maxOccurs, this.fParticleCount++, this.fLeafCount++);
            nodeRet = minOccurs == 0 ? this.fNodeFactory.getCMUniOpNode(4, nodeRet) : this.fNodeFactory.getCMUniOpNode(6, nodeRet);
        }
        return nodeRet;
    }

    private boolean useRepeatingLeafNodes(XSParticleDecl particle) {
        int maxOccurs = particle.fMaxOccurs;
        int minOccurs = particle.fMinOccurs;
        short type = particle.fType;
        if (type == 3) {
            XSModelGroupImpl group = (XSModelGroupImpl)particle.fValue;
            if (minOccurs != 1 || maxOccurs != 1) {
                if (group.fParticleCount == 1) {
                    XSParticleDecl particle2 = group.fParticles[0];
                    short type2 = particle2.fType;
                    return (type2 == 1 || type2 == 2) && particle2.fMinOccurs == 1 && particle2.fMaxOccurs == 1;
                }
                return group.fParticleCount == 0;
            }
            for (int i = 0; i < group.fParticleCount; ++i) {
                if (this.useRepeatingLeafNodes(group.fParticles[i])) continue;
                return false;
            }
        }
        return true;
    }
}

