/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.impl.xs;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.SchemaGrammar;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.SchemaSymbols;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.SubstitutionGroupHandler;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.XSAnnotationImpl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.XSElementDecl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.util.StringListImpl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.util.XSNamedMap4Types;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.util.XSNamedMapImpl;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.util.XSObjectListImpl;
import jdk7u.jaxp.org.apache.xerces.external.util.SymbolHash;
import jdk7u.jaxp.org.apache.xerces.external.util.XMLSymbols;
import jdk7u.jaxp.org.apache.xerces.external.xs.StringList;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSAttributeDeclaration;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSAttributeGroupDefinition;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSElementDeclaration;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSModel;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSModelGroupDefinition;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSNamedMap;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSNamespaceItem;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSNamespaceItemList;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSNotationDeclaration;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSObject;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSObjectList;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSTypeDefinition;

public final class XSModelImpl
extends AbstractList
implements XSModel,
XSNamespaceItemList {
    private static final short MAX_COMP_IDX = 16;
    private static final boolean[] GLOBAL_COMP = new boolean[]{false, true, true, true, false, true, true, false, false, false, false, true, false, false, false, true, true};
    private final int fGrammarCount;
    private final String[] fNamespaces;
    private final SchemaGrammar[] fGrammarList;
    private final SymbolHash fGrammarMap;
    private final SymbolHash fSubGroupMap;
    private final XSNamedMap[] fGlobalComponents;
    private final XSNamedMap[][] fNSComponents;
    private final StringList fNamespacesList;
    private XSObjectList fAnnotations = null;
    private final boolean fHasIDC;

    public XSModelImpl(SchemaGrammar[] grammars) {
        this(grammars, 1);
    }

    public XSModelImpl(SchemaGrammar[] grammars, short s4sVersion) {
        int i;
        int len = grammars.length;
        int initialSize = Math.max(len + 1, 5);
        String[] namespaces = new String[initialSize];
        SchemaGrammar[] grammarList = new SchemaGrammar[initialSize];
        boolean hasS4S = false;
        for (int i2 = 0; i2 < len; ++i2) {
            String tns;
            SchemaGrammar sg = grammars[i2];
            namespaces[i2] = tns = sg.getTargetNamespace();
            grammarList[i2] = sg;
            if (tns != SchemaSymbols.URI_SCHEMAFORSCHEMA) continue;
            hasS4S = true;
        }
        if (!hasS4S) {
            namespaces[len] = SchemaSymbols.URI_SCHEMAFORSCHEMA;
            grammarList[len++] = SchemaGrammar.getS4SGrammar(s4sVersion);
        }
        for (i = 0; i < len; ++i) {
            int j;
            SchemaGrammar sg1 = grammarList[i];
            Vector gs = sg1.getImportedGrammars();
            int n = j = gs == null ? -1 : gs.size() - 1;
            while (j >= 0) {
                int k;
                SchemaGrammar sg2 = (SchemaGrammar)gs.elementAt(j);
                for (k = 0; k < len && sg2 != grammarList[k]; ++k) {
                }
                if (k == len) {
                    if (len == grammarList.length) {
                        String[] newSA = new String[len * 2];
                        System.arraycopy(namespaces, 0, newSA, 0, len);
                        namespaces = newSA;
                        SchemaGrammar[] newGA = new SchemaGrammar[len * 2];
                        System.arraycopy(grammarList, 0, newGA, 0, len);
                        grammarList = newGA;
                    }
                    namespaces[len] = sg2.getTargetNamespace();
                    grammarList[len] = sg2;
                    ++len;
                }
                --j;
            }
        }
        this.fNamespaces = namespaces;
        this.fGrammarList = grammarList;
        boolean hasIDC = false;
        this.fGrammarMap = new SymbolHash(len * 2);
        for (i = 0; i < len; ++i) {
            this.fGrammarMap.put(XSModelImpl.null2EmptyString(this.fNamespaces[i]), this.fGrammarList[i]);
            if (!this.fGrammarList[i].hasIDConstraints()) continue;
            hasIDC = true;
        }
        this.fHasIDC = hasIDC;
        this.fGrammarCount = len;
        this.fGlobalComponents = new XSNamedMap[17];
        this.fNSComponents = new XSNamedMap[len][17];
        this.fNamespacesList = new StringListImpl(this.fNamespaces, this.fGrammarCount);
        this.fSubGroupMap = this.buildSubGroups();
    }

    private SymbolHash buildSubGroups_Org() {
        SubstitutionGroupHandler sgHandler = new SubstitutionGroupHandler(null);
        for (int i = 0; i < this.fGrammarCount; ++i) {
            sgHandler.addSubstitutionGroup(this.fGrammarList[i].getSubstitutionGroups());
        }
        XSNamedMap elements = this.getComponents((short)2);
        int len = elements.getLength();
        SymbolHash subGroupMap = new SymbolHash(len * 2);
        for (int i = 0; i < len; ++i) {
            XSElementDecl head;
            XSObject[] subGroup = sgHandler.getSubstitutionGroup(head = (XSElementDecl)elements.item(i));
            subGroupMap.put(head, subGroup.length > 0 ? new XSObjectListImpl(subGroup, subGroup.length) : XSObjectListImpl.EMPTY_LIST);
        }
        return subGroupMap;
    }

    private SymbolHash buildSubGroups() {
        SubstitutionGroupHandler sgHandler = new SubstitutionGroupHandler(null);
        for (int i = 0; i < this.fGrammarCount; ++i) {
            sgHandler.addSubstitutionGroup(this.fGrammarList[i].getSubstitutionGroups());
        }
        XSObjectListImpl elements = this.getGlobalElements();
        int len = elements.getLength();
        SymbolHash subGroupMap = new SymbolHash(len * 2);
        for (int i = 0; i < len; ++i) {
            XSElementDecl head;
            XSObject[] subGroup = sgHandler.getSubstitutionGroup(head = (XSElementDecl)elements.item(i));
            subGroupMap.put(head, subGroup.length > 0 ? new XSObjectListImpl(subGroup, subGroup.length) : XSObjectListImpl.EMPTY_LIST);
        }
        return subGroupMap;
    }

    private XSObjectListImpl getGlobalElements() {
        SymbolHash[] tables = new SymbolHash[this.fGrammarCount];
        int length = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            tables[i] = this.fGrammarList[i].fAllGlobalElemDecls;
            length += tables[i].getLength();
        }
        if (length == 0) {
            return XSObjectListImpl.EMPTY_LIST;
        }
        Object[] components = new XSObject[length];
        int start = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            tables[i].getValues(components, start);
            start += tables[i].getLength();
        }
        return new XSObjectListImpl((XSObject[])components, length);
    }

    @Override
    public StringList getNamespaces() {
        return this.fNamespacesList;
    }

    @Override
    public XSNamespaceItemList getNamespaceItems() {
        return this;
    }

    @Override
    public synchronized XSNamedMap getComponents(short objectType) {
        if (objectType <= 0 || objectType > 16 || !GLOBAL_COMP[objectType]) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        SymbolHash[] tables = new SymbolHash[this.fGrammarCount];
        if (this.fGlobalComponents[objectType] == null) {
            block8: for (int i = 0; i < this.fGrammarCount; ++i) {
                switch (objectType) {
                    case 3: 
                    case 15: 
                    case 16: {
                        tables[i] = this.fGrammarList[i].fGlobalTypeDecls;
                        continue block8;
                    }
                    case 1: {
                        tables[i] = this.fGrammarList[i].fGlobalAttrDecls;
                        continue block8;
                    }
                    case 2: {
                        tables[i] = this.fGrammarList[i].fGlobalElemDecls;
                        continue block8;
                    }
                    case 5: {
                        tables[i] = this.fGrammarList[i].fGlobalAttrGrpDecls;
                        continue block8;
                    }
                    case 6: {
                        tables[i] = this.fGrammarList[i].fGlobalGroupDecls;
                        continue block8;
                    }
                    case 11: {
                        tables[i] = this.fGrammarList[i].fGlobalNotationDecls;
                    }
                }
            }
            this.fGlobalComponents[objectType] = objectType == 15 || objectType == 16 ? new XSNamedMap4Types(this.fNamespaces, tables, this.fGrammarCount, objectType) : new XSNamedMapImpl(this.fNamespaces, tables, this.fGrammarCount);
        }
        return this.fGlobalComponents[objectType];
    }

    @Override
    public synchronized XSNamedMap getComponentsByNamespace(short objectType, String namespace) {
        int i;
        if (objectType <= 0 || objectType > 16 || !GLOBAL_COMP[objectType]) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        if (namespace != null) {
            for (i = 0; i < this.fGrammarCount && !namespace.equals(this.fNamespaces[i]); ++i) {
            }
        } else {
            while (i < this.fGrammarCount && this.fNamespaces[i] != null) {
                ++i;
            }
        }
        if (i == this.fGrammarCount) {
            return XSNamedMapImpl.EMPTY_MAP;
        }
        if (this.fNSComponents[i][objectType] == null) {
            SymbolHash table = null;
            switch (objectType) {
                case 3: 
                case 15: 
                case 16: {
                    table = this.fGrammarList[i].fGlobalTypeDecls;
                    break;
                }
                case 1: {
                    table = this.fGrammarList[i].fGlobalAttrDecls;
                    break;
                }
                case 2: {
                    table = this.fGrammarList[i].fGlobalElemDecls;
                    break;
                }
                case 5: {
                    table = this.fGrammarList[i].fGlobalAttrGrpDecls;
                    break;
                }
                case 6: {
                    table = this.fGrammarList[i].fGlobalGroupDecls;
                    break;
                }
                case 11: {
                    table = this.fGrammarList[i].fGlobalNotationDecls;
                }
            }
            this.fNSComponents[i][objectType] = objectType == 15 || objectType == 16 ? new XSNamedMap4Types(namespace, table, objectType) : new XSNamedMapImpl(namespace, table);
        }
        return this.fNSComponents[i][objectType];
    }

    @Override
    public XSTypeDefinition getTypeDefinition(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSTypeDefinition)sg.fGlobalTypeDecls.get(name);
    }

    public XSTypeDefinition getTypeDefinition(String name, String namespace, String loc) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return sg.getGlobalTypeDecl(name, loc);
    }

    @Override
    public XSAttributeDeclaration getAttributeDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSAttributeDeclaration)sg.fGlobalAttrDecls.get(name);
    }

    public XSAttributeDeclaration getAttributeDeclaration(String name, String namespace, String loc) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return sg.getGlobalAttributeDecl(name, loc);
    }

    @Override
    public XSElementDeclaration getElementDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSElementDeclaration)sg.fGlobalElemDecls.get(name);
    }

    public XSElementDeclaration getElementDeclaration(String name, String namespace, String loc) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return sg.getGlobalElementDecl(name, loc);
    }

    @Override
    public XSAttributeGroupDefinition getAttributeGroup(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSAttributeGroupDefinition)sg.fGlobalAttrGrpDecls.get(name);
    }

    public XSAttributeGroupDefinition getAttributeGroup(String name, String namespace, String loc) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return sg.getGlobalAttributeGroupDecl(name, loc);
    }

    @Override
    public XSModelGroupDefinition getModelGroupDefinition(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSModelGroupDefinition)sg.fGlobalGroupDecls.get(name);
    }

    public XSModelGroupDefinition getModelGroupDefinition(String name, String namespace, String loc) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return sg.getGlobalGroupDecl(name, loc);
    }

    @Override
    public XSNotationDeclaration getNotationDeclaration(String name, String namespace) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return (XSNotationDeclaration)sg.fGlobalNotationDecls.get(name);
    }

    public XSNotationDeclaration getNotationDeclaration(String name, String namespace, String loc) {
        SchemaGrammar sg = (SchemaGrammar)this.fGrammarMap.get(XSModelImpl.null2EmptyString(namespace));
        if (sg == null) {
            return null;
        }
        return sg.getGlobalNotationDecl(name, loc);
    }

    @Override
    public synchronized XSObjectList getAnnotations() {
        if (this.fAnnotations != null) {
            return this.fAnnotations;
        }
        int totalAnnotations = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            totalAnnotations += this.fGrammarList[i].fNumAnnotations;
        }
        if (totalAnnotations == 0) {
            this.fAnnotations = XSObjectListImpl.EMPTY_LIST;
            return this.fAnnotations;
        }
        XSObject[] annotations = new XSAnnotationImpl[totalAnnotations];
        int currPos = 0;
        for (int i = 0; i < this.fGrammarCount; ++i) {
            SchemaGrammar currGrammar = this.fGrammarList[i];
            if (currGrammar.fNumAnnotations <= 0) continue;
            System.arraycopy(currGrammar.fAnnotations, 0, annotations, currPos, currGrammar.fNumAnnotations);
            currPos += currGrammar.fNumAnnotations;
        }
        this.fAnnotations = new XSObjectListImpl(annotations, annotations.length);
        return this.fAnnotations;
    }

    private static final String null2EmptyString(String str) {
        return str == null ? XMLSymbols.EMPTY_STRING : str;
    }

    public boolean hasIDConstraints() {
        return this.fHasIDC;
    }

    @Override
    public XSObjectList getSubstitutionGroup(XSElementDeclaration head) {
        return (XSObjectList)this.fSubGroupMap.get(head);
    }

    @Override
    public int getLength() {
        return this.fGrammarCount;
    }

    @Override
    public XSNamespaceItem item(int index) {
        if (index < 0 || index >= this.fGrammarCount) {
            return null;
        }
        return this.fGrammarList[index];
    }

    public Object get(int index) {
        if (index >= 0 && index < this.fGrammarCount) {
            return this.fGrammarList[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    @Override
    public int size() {
        return this.getLength();
    }

    @Override
    public Iterator iterator() {
        return this.listIterator0(0);
    }

    public ListIterator listIterator() {
        return this.listIterator0(0);
    }

    public ListIterator listIterator(int index) {
        if (index >= 0 && index < this.fGrammarCount) {
            return this.listIterator0(index);
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    private ListIterator listIterator0(int index) {
        return new XSNamespaceItemListIterator(index);
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.fGrammarCount];
        this.toArray0(a);
        return a;
    }

    @Override
    public Object[] toArray(Object[] a) {
        if (a.length < this.fGrammarCount) {
            Class<?> arrayClass = a.getClass();
            Class<?> componentType = arrayClass.getComponentType();
            a = (Object[])Array.newInstance(componentType, this.fGrammarCount);
        }
        this.toArray0(a);
        if (a.length > this.fGrammarCount) {
            a[this.fGrammarCount] = null;
        }
        return a;
    }

    private void toArray0(Object[] a) {
        if (this.fGrammarCount > 0) {
            System.arraycopy(this.fGrammarList, 0, a, 0, this.fGrammarCount);
        }
    }

    private final class XSNamespaceItemListIterator
    implements ListIterator {
        private int index;

        public XSNamespaceItemListIterator(int index) {
            this.index = index;
        }

        @Override
        public boolean hasNext() {
            return this.index < XSModelImpl.this.fGrammarCount;
        }

        @Override
        public Object next() {
            if (this.index < XSModelImpl.this.fGrammarCount) {
                return XSModelImpl.this.fGrammarList[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        public Object previous() {
            if (this.index > 0) {
                return XSModelImpl.this.fGrammarList[--this.index];
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

