/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.impl.xs;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.SchemaGrammar;

public class XSGrammarBucket {
    Map<String, SchemaGrammar> fGrammarRegistry = new HashMap<String, SchemaGrammar>();
    SchemaGrammar fNoNSGrammar = null;

    public SchemaGrammar getGrammar(String namespace) {
        if (namespace == null) {
            return this.fNoNSGrammar;
        }
        return this.fGrammarRegistry.get(namespace);
    }

    public void putGrammar(SchemaGrammar grammar) {
        if (grammar.getTargetNamespace() == null) {
            this.fNoNSGrammar = grammar;
        } else {
            this.fGrammarRegistry.put(grammar.getTargetNamespace(), grammar);
        }
    }

    public boolean putGrammar(SchemaGrammar grammar, boolean deep) {
        int i;
        SchemaGrammar sg = this.getGrammar(grammar.fTargetNamespace);
        if (sg != null) {
            return sg == grammar;
        }
        if (!deep) {
            this.putGrammar(grammar);
            return true;
        }
        Vector currGrammars = grammar.getImportedGrammars();
        if (currGrammars == null) {
            this.putGrammar(grammar);
            return true;
        }
        Vector grammars = (Vector)currGrammars.clone();
        for (i = 0; i < grammars.size(); ++i) {
            SchemaGrammar sg1 = (SchemaGrammar)grammars.elementAt(i);
            SchemaGrammar sg2 = this.getGrammar(sg1.fTargetNamespace);
            if (sg2 == null) {
                Vector gs = sg1.getImportedGrammars();
                if (gs == null) continue;
                for (int j = gs.size() - 1; j >= 0; --j) {
                    sg2 = (SchemaGrammar)gs.elementAt(j);
                    if (grammars.contains(sg2)) continue;
                    grammars.addElement(sg2);
                }
                continue;
            }
            if (sg2 == sg1) continue;
            return false;
        }
        this.putGrammar(grammar);
        for (i = grammars.size() - 1; i >= 0; --i) {
            this.putGrammar((SchemaGrammar)grammars.elementAt(i));
        }
        return true;
    }

    public boolean putGrammar(SchemaGrammar grammar, boolean deep, boolean ignoreConflict) {
        int i;
        if (!ignoreConflict) {
            return this.putGrammar(grammar, deep);
        }
        SchemaGrammar sg = this.getGrammar(grammar.fTargetNamespace);
        if (sg == null) {
            this.putGrammar(grammar);
        }
        if (!deep) {
            return true;
        }
        Vector currGrammars = grammar.getImportedGrammars();
        if (currGrammars == null) {
            return true;
        }
        Vector grammars = (Vector)currGrammars.clone();
        for (i = 0; i < grammars.size(); ++i) {
            SchemaGrammar sg1 = (SchemaGrammar)grammars.elementAt(i);
            SchemaGrammar sg2 = this.getGrammar(sg1.fTargetNamespace);
            if (sg2 == null) {
                Vector gs = sg1.getImportedGrammars();
                if (gs == null) continue;
                for (int j = gs.size() - 1; j >= 0; --j) {
                    sg2 = (SchemaGrammar)gs.elementAt(j);
                    if (grammars.contains(sg2)) continue;
                    grammars.addElement(sg2);
                }
                continue;
            }
            grammars.remove(sg1);
        }
        for (i = grammars.size() - 1; i >= 0; --i) {
            this.putGrammar((SchemaGrammar)grammars.elementAt(i));
        }
        return true;
    }

    public SchemaGrammar[] getGrammars() {
        int count = this.fGrammarRegistry.size() + (this.fNoNSGrammar == null ? 0 : 1);
        SchemaGrammar[] grammars = new SchemaGrammar[count];
        int i = 0;
        for (Map.Entry<String, SchemaGrammar> entry : this.fGrammarRegistry.entrySet()) {
            grammars[i++] = entry.getValue();
        }
        if (this.fNoNSGrammar != null) {
            grammars[count - 1] = this.fNoNSGrammar;
        }
        return grammars;
    }

    public void reset() {
        this.fNoNSGrammar = null;
        this.fGrammarRegistry.clear();
    }
}

