/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.impl.dv.xs;

import javax.xml.namespace.QName;
import jdk7u.jaxp.org.apache.xerces.external.impl.dv.InvalidDatatypeValueException;
import jdk7u.jaxp.org.apache.xerces.external.impl.dv.ValidationContext;
import jdk7u.jaxp.org.apache.xerces.external.impl.dv.xs.TypeValidator;
import jdk7u.jaxp.org.apache.xerces.external.util.XMLChar;
import jdk7u.jaxp.org.apache.xerces.external.xs.datatypes.XSQName;

public class QNameDV
extends TypeValidator {
    private static final String EMPTY_STRING = "".intern();

    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        String localpart;
        String prefix;
        int colonptr = content.indexOf(":");
        if (colonptr > 0) {
            prefix = context.getSymbol(content.substring(0, colonptr));
            localpart = content.substring(colonptr + 1);
        } else {
            prefix = EMPTY_STRING;
            localpart = content;
        }
        if (prefix.length() > 0 && !XMLChar.isValidNCName(prefix)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "QName"});
        }
        if (!XMLChar.isValidNCName(localpart)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "QName"});
        }
        String uri = context.getURI(prefix);
        if (prefix.length() > 0 && uri == null) {
            throw new InvalidDatatypeValueException("UndeclaredPrefix", new Object[]{content, prefix});
        }
        return new XQName(prefix, context.getSymbol(localpart), context.getSymbol(content), uri);
    }

    @Override
    public int getDataLength(Object value) {
        return ((XQName)value).rawname.length();
    }

    private static final class XQName
    extends jdk7u.jaxp.org.apache.xerces.external.xni.QName
    implements XSQName {
        public XQName(String prefix, String localpart, String rawname, String uri) {
            this.setValues(prefix, localpart, rawname, uri);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof jdk7u.jaxp.org.apache.xerces.external.xni.QName) {
                jdk7u.jaxp.org.apache.xerces.external.xni.QName qname = (jdk7u.jaxp.org.apache.xerces.external.xni.QName)object;
                return this.uri == qname.uri && this.localpart == qname.localpart;
            }
            return false;
        }

        @Override
        public synchronized String toString() {
            return this.rawname;
        }

        @Override
        public QName getJAXPQName() {
            return new QName(this.uri, this.localpart, this.prefix);
        }

        @Override
        public jdk7u.jaxp.org.apache.xerces.external.xni.QName getXNIQName() {
            return this;
        }
    }
}

