/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.impl;

import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLStreamFilterImpl
implements XMLStreamReader {
    private StreamFilter fStreamFilter = null;
    private XMLStreamReader fStreamReader = null;
    private int fCurrentEvent;
    private boolean fEventAccepted = false;
    private boolean fStreamAdvancedByHasNext = false;

    public XMLStreamFilterImpl(XMLStreamReader reader, StreamFilter filter) {
        this.fStreamReader = reader;
        this.fStreamFilter = filter;
        try {
            if (this.fStreamFilter.accept(this.fStreamReader)) {
                this.fEventAccepted = true;
            } else {
                this.findNextEvent();
            }
        }
        catch (XMLStreamException xs) {
            System.err.println("Error while creating a stream Filter" + xs);
        }
    }

    protected void setStreamFilter(StreamFilter sf) {
        this.fStreamFilter = sf;
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.fStreamAdvancedByHasNext && this.fEventAccepted) {
            this.fStreamAdvancedByHasNext = false;
            return this.fCurrentEvent;
        }
        int event = this.findNextEvent();
        if (event != -1) {
            return event;
        }
        throw new IllegalStateException("The stream reader has reached the end of the document, or there are no more  items to return");
    }

    @Override
    public int nextTag() throws XMLStreamException {
        if (this.fStreamAdvancedByHasNext && this.fEventAccepted && (this.fCurrentEvent == 1 || this.fCurrentEvent == 1)) {
            this.fStreamAdvancedByHasNext = false;
            return this.fCurrentEvent;
        }
        int event = this.findNextTag();
        if (event != -1) {
            return event;
        }
        throw new IllegalStateException("The stream reader has reached the end of the document, or there are no more  items to return");
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        if (this.fStreamReader.hasNext()) {
            if (!this.fEventAccepted) {
                this.fCurrentEvent = this.findNextEvent();
                if (this.fCurrentEvent == -1) {
                    return false;
                }
                this.fStreamAdvancedByHasNext = true;
            }
            return true;
        }
        return false;
    }

    private int findNextEvent() throws XMLStreamException {
        this.fStreamAdvancedByHasNext = false;
        while (this.fStreamReader.hasNext()) {
            this.fCurrentEvent = this.fStreamReader.next();
            if (!this.fStreamFilter.accept(this.fStreamReader)) continue;
            this.fEventAccepted = true;
            return this.fCurrentEvent;
        }
        if (this.fCurrentEvent == 8) {
            return this.fCurrentEvent;
        }
        return -1;
    }

    private int findNextTag() throws XMLStreamException {
        this.fStreamAdvancedByHasNext = false;
        while (this.fStreamReader.hasNext()) {
            this.fCurrentEvent = this.fStreamReader.nextTag();
            if (!this.fStreamFilter.accept(this.fStreamReader)) continue;
            this.fEventAccepted = true;
            return this.fCurrentEvent;
        }
        if (this.fCurrentEvent == 8) {
            return this.fCurrentEvent;
        }
        return -1;
    }

    @Override
    public void close() throws XMLStreamException {
        this.fStreamReader.close();
    }

    @Override
    public int getAttributeCount() {
        return this.fStreamReader.getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.fStreamReader.getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.fStreamReader.getAttributeNamespace(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.fStreamReader.getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.fStreamReader.getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.fStreamReader.getAttributeValue(index);
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.fStreamReader.getAttributeValue(namespaceURI, localName);
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this.fStreamReader.getCharacterEncodingScheme();
    }

    @Override
    public String getElementText() throws XMLStreamException {
        return this.fStreamReader.getElementText();
    }

    @Override
    public String getEncoding() {
        return this.fStreamReader.getEncoding();
    }

    @Override
    public int getEventType() {
        return this.fStreamReader.getEventType();
    }

    @Override
    public String getLocalName() {
        return this.fStreamReader.getLocalName();
    }

    @Override
    public Location getLocation() {
        return this.fStreamReader.getLocation();
    }

    @Override
    public QName getName() {
        return this.fStreamReader.getName();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.fStreamReader.getNamespaceContext();
    }

    @Override
    public int getNamespaceCount() {
        return this.fStreamReader.getNamespaceCount();
    }

    @Override
    public String getNamespacePrefix(int index) {
        return this.fStreamReader.getNamespacePrefix(index);
    }

    @Override
    public String getNamespaceURI() {
        return this.fStreamReader.getNamespaceURI();
    }

    @Override
    public String getNamespaceURI(int index) {
        return this.fStreamReader.getNamespaceURI(index);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.fStreamReader.getNamespaceURI(prefix);
    }

    @Override
    public String getPIData() {
        return this.fStreamReader.getPIData();
    }

    @Override
    public String getPITarget() {
        return this.fStreamReader.getPITarget();
    }

    @Override
    public String getPrefix() {
        return this.fStreamReader.getPrefix();
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return this.fStreamReader.getProperty(name);
    }

    @Override
    public String getText() {
        return this.fStreamReader.getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.fStreamReader.getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.fStreamReader.getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextLength() {
        return this.fStreamReader.getTextLength();
    }

    @Override
    public int getTextStart() {
        return this.fStreamReader.getTextStart();
    }

    @Override
    public String getVersion() {
        return this.fStreamReader.getVersion();
    }

    @Override
    public boolean hasName() {
        return this.fStreamReader.hasName();
    }

    @Override
    public boolean hasText() {
        return this.fStreamReader.hasText();
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.fStreamReader.isAttributeSpecified(index);
    }

    @Override
    public boolean isCharacters() {
        return this.fStreamReader.isCharacters();
    }

    @Override
    public boolean isEndElement() {
        return this.fStreamReader.isEndElement();
    }

    @Override
    public boolean isStandalone() {
        return this.fStreamReader.isStandalone();
    }

    @Override
    public boolean isStartElement() {
        return this.fStreamReader.isStartElement();
    }

    @Override
    public boolean isWhiteSpace() {
        return this.fStreamReader.isWhiteSpace();
    }

    @Override
    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        this.fStreamReader.require(type, namespaceURI, localName);
    }

    @Override
    public boolean standaloneSet() {
        return this.fStreamReader.standaloneSet();
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.fStreamReader.getAttributeLocalName(index);
    }
}

