/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.impl;

import java.util.HashMap;
import javax.xml.stream.XMLResolver;
import jdk7u.jaxp.org.apache.xerces.external.utils.XMLSecurityManager;
import jdk7u.jaxp.org.apache.xerces.external.utils.XMLSecurityPropertyManager;
import jdk7u.jaxp.xml.external.stream.StaxEntityResolverWrapper;

public class PropertyManager {
    public static final String STAX_NOTATIONS = "javax.xml.stream.notations";
    public static final String STAX_ENTITIES = "javax.xml.stream.entities";
    private static final String STRING_INTERNING = "http://xml.org/sax/features/string-interning";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String XML_SECURITY_PROPERTY_MANAGER = "http://www.oracle.com/xml/jaxp/properties/xmlSecurityPropertyManager";
    HashMap supportedProps = new HashMap();
    private XMLSecurityManager fSecurityManager;
    private XMLSecurityPropertyManager fSecurityPropertyMgr;
    public static final int CONTEXT_READER = 1;
    public static final int CONTEXT_WRITER = 2;

    public PropertyManager(int context) {
        switch (context) {
            case 1: {
                this.initConfigurableReaderProperties();
                break;
            }
            case 2: {
                this.initWriterProps();
            }
        }
    }

    public PropertyManager(PropertyManager propertyManager) {
        HashMap properties = propertyManager.getProperties();
        this.supportedProps.putAll(properties);
        this.fSecurityManager = (XMLSecurityManager)this.getProperty(SECURITY_MANAGER);
        this.fSecurityPropertyMgr = (XMLSecurityPropertyManager)this.getProperty(XML_SECURITY_PROPERTY_MANAGER);
    }

    private HashMap getProperties() {
        return this.supportedProps;
    }

    private void initConfigurableReaderProperties() {
        this.supportedProps.put("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isValidating", Boolean.FALSE);
        this.supportedProps.put("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.isCoalescing", Boolean.FALSE);
        this.supportedProps.put("javax.xml.stream.supportDTD", Boolean.TRUE);
        this.supportedProps.put("javax.xml.stream.reporter", null);
        this.supportedProps.put("javax.xml.stream.resolver", null);
        this.supportedProps.put("javax.xml.stream.allocator", null);
        this.supportedProps.put(STAX_NOTATIONS, null);
        this.supportedProps.put(STRING_INTERNING, new Boolean(true));
        this.supportedProps.put("http://apache.org/xml/features/allow-java-encodings", new Boolean(true));
        this.supportedProps.put("add-namespacedecl-as-attrbiute", Boolean.FALSE);
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/reader-in-defined-state", new Boolean(true));
        this.supportedProps.put("reuse-instance", new Boolean(true));
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/report-cdata-event", new Boolean(false));
        this.supportedProps.put("http://java.sun.com/xml/stream/properties/ignore-external-dtd", Boolean.FALSE);
        this.supportedProps.put("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", new Boolean(false));
        this.supportedProps.put("http://apache.org/xml/features/warn-on-duplicate-entitydef", new Boolean(false));
        this.supportedProps.put("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", new Boolean(false));
        this.fSecurityManager = new XMLSecurityManager(true);
        this.supportedProps.put(SECURITY_MANAGER, this.fSecurityManager);
        this.fSecurityPropertyMgr = new XMLSecurityPropertyManager();
        this.supportedProps.put(XML_SECURITY_PROPERTY_MANAGER, this.fSecurityPropertyMgr);
    }

    private void initWriterProps() {
        this.supportedProps.put("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
        this.supportedProps.put("escapeCharacters", Boolean.TRUE);
        this.supportedProps.put("reuse-instance", new Boolean(true));
    }

    public boolean containsProperty(String property) {
        return this.supportedProps.containsKey(property) || this.fSecurityManager != null && this.fSecurityManager.getIndex(property) > -1 || this.fSecurityPropertyMgr != null && this.fSecurityPropertyMgr.getIndex(property) > -1;
    }

    public Object getProperty(String property) {
        return this.supportedProps.get(property);
    }

    public void setProperty(String property, Object value) {
        String equivalentProperty = null;
        if (property == "javax.xml.stream.isNamespaceAware" || property.equals("javax.xml.stream.isNamespaceAware")) {
            equivalentProperty = "http://apache.org/xml/features/namespaces";
        } else if (property == "javax.xml.stream.isValidating" || property.equals("javax.xml.stream.isValidating")) {
            if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                throw new IllegalArgumentException("true value of isValidating not supported");
            }
        } else if (property == STRING_INTERNING || property.equals(STRING_INTERNING)) {
            if (value instanceof Boolean && !((Boolean)value).booleanValue()) {
                throw new IllegalArgumentException("false value of http://xml.org/sax/features/string-interningfeature is not supported");
            }
        } else if (property == "javax.xml.stream.resolver" || property.equals("javax.xml.stream.resolver")) {
            this.supportedProps.put("http://apache.org/xml/properties/internal/stax-entity-resolver", new StaxEntityResolverWrapper((XMLResolver)value));
        }
        if (property.equals(SECURITY_MANAGER)) {
            this.fSecurityManager = XMLSecurityManager.convert(value, this.fSecurityManager);
            this.supportedProps.put(SECURITY_MANAGER, this.fSecurityManager);
            return;
        }
        if (property.equals(XML_SECURITY_PROPERTY_MANAGER)) {
            this.fSecurityPropertyMgr = value == null ? new XMLSecurityPropertyManager() : (XMLSecurityPropertyManager)value;
            this.supportedProps.put(XML_SECURITY_PROPERTY_MANAGER, this.fSecurityPropertyMgr);
            return;
        }
        if (!(this.fSecurityManager != null && this.fSecurityManager.setLimit(property, XMLSecurityManager.State.APIPROPERTY, value) || this.fSecurityPropertyMgr != null && this.fSecurityPropertyMgr.setValue(property, XMLSecurityPropertyManager.State.APIPROPERTY, value))) {
            this.supportedProps.put(property, value);
        }
        if (equivalentProperty != null) {
            this.supportedProps.put(equivalentProperty, value);
        }
    }

    public String toString() {
        return this.supportedProps.toString();
    }
}

