/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.dom;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;
import jdk7u.jaxp.org.apache.xerces.external.dom.AttrImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.AttributeMap;
import jdk7u.jaxp.org.apache.xerces.external.dom.CoreDOMImplementationImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.CoreDocumentImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.DOMConfigurationImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.DOMErrorImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.DOMLocatorImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.DOMMessageFormatter;
import jdk7u.jaxp.org.apache.xerces.external.dom.DocumentTypeImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.ElementImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.EntityReferenceImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.PSVIAttrNSImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.PSVIElementNSImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.TextImpl;
import jdk7u.jaxp.org.apache.xerces.external.impl.Constants;
import jdk7u.jaxp.org.apache.xerces.external.impl.RevalidationHandler;
import jdk7u.jaxp.org.apache.xerces.external.impl.dtd.DTDGrammar;
import jdk7u.jaxp.org.apache.xerces.external.impl.dtd.XMLDTDDescription;
import jdk7u.jaxp.org.apache.xerces.external.impl.dtd.XMLDTDValidator;
import jdk7u.jaxp.org.apache.xerces.external.impl.dv.XSSimpleType;
import jdk7u.jaxp.org.apache.xerces.external.impl.xs.util.SimpleLocator;
import jdk7u.jaxp.org.apache.xerces.external.parsers.XMLGrammarPreparser;
import jdk7u.jaxp.org.apache.xerces.external.util.AugmentationsImpl;
import jdk7u.jaxp.org.apache.xerces.external.util.NamespaceSupport;
import jdk7u.jaxp.org.apache.xerces.external.util.SymbolTable;
import jdk7u.jaxp.org.apache.xerces.external.util.XML11Char;
import jdk7u.jaxp.org.apache.xerces.external.util.XMLChar;
import jdk7u.jaxp.org.apache.xerces.external.util.XMLGrammarPoolImpl;
import jdk7u.jaxp.org.apache.xerces.external.util.XMLSymbols;
import jdk7u.jaxp.org.apache.xerces.external.xni.Augmentations;
import jdk7u.jaxp.org.apache.xerces.external.xni.NamespaceContext;
import jdk7u.jaxp.org.apache.xerces.external.xni.QName;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLAttributes;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLDocumentHandler;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLLocator;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLResourceIdentifier;
import jdk7u.jaxp.org.apache.xerces.external.xni.XMLString;
import jdk7u.jaxp.org.apache.xerces.external.xni.XNIException;
import jdk7u.jaxp.org.apache.xerces.external.xni.grammars.XMLGrammarPool;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLComponent;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLDocumentSource;
import jdk7u.jaxp.org.apache.xerces.external.xni.parser.XMLInputSource;
import jdk7u.jaxp.org.apache.xerces.external.xs.AttributePSVI;
import jdk7u.jaxp.org.apache.xerces.external.xs.ElementPSVI;
import jdk7u.jaxp.org.apache.xerces.external.xs.XSTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMNormalizer
implements XMLDocumentHandler {
    protected static final boolean DEBUG_ND = false;
    protected static final boolean DEBUG = false;
    protected static final boolean DEBUG_EVENTS = false;
    protected static final String PREFIX = "NS";
    protected DOMConfigurationImpl fConfiguration = null;
    protected CoreDocumentImpl fDocument = null;
    protected final XMLAttributesProxy fAttrProxy = new XMLAttributesProxy();
    protected final QName fQName = new QName();
    protected RevalidationHandler fValidationHandler;
    protected SymbolTable fSymbolTable;
    protected DOMErrorHandler fErrorHandler;
    private final DOMErrorImpl fError = new DOMErrorImpl();
    protected boolean fNamespaceValidation = false;
    protected boolean fPSVI = false;
    protected final NamespaceContext fNamespaceContext = new NamespaceSupport();
    protected final NamespaceContext fLocalNSBinder = new NamespaceSupport();
    protected final ArrayList fAttributeList = new ArrayList(5);
    protected final DOMLocatorImpl fLocator = new DOMLocatorImpl();
    protected Node fCurrentNode = null;
    private QName fAttrQName = new QName();
    final XMLString fNormalizedValue = new XMLString(new char[16], 0, 0);
    public static final RuntimeException abort = new RuntimeException();
    private XMLDTDValidator fDTDValidator;
    private boolean allWhitespace = false;

    protected void normalizeDocument(CoreDocumentImpl document, DOMConfigurationImpl config) {
        this.fDocument = document;
        this.fConfiguration = config;
        this.fSymbolTable = (SymbolTable)this.fConfiguration.getProperty("http://apache.org/xml/properties/internal/symbol-table");
        this.fNamespaceContext.reset();
        this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
        if ((this.fConfiguration.features & 0x40) != 0) {
            String schemaLang = (String)this.fConfiguration.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            if (schemaLang != null && schemaLang.equals(Constants.NS_XMLSCHEMA)) {
                this.fValidationHandler = CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/2001/XMLSchema");
                this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.fConfiguration.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                this.fNamespaceValidation = true;
                this.fPSVI = (this.fConfiguration.features & 0x80) != 0;
            }
            this.fConfiguration.setFeature("http://xml.org/sax/features/validation", true);
            this.fDocument.clearIdentifiers();
            if (this.fValidationHandler != null) {
                ((XMLComponent)((Object)this.fValidationHandler)).reset(this.fConfiguration);
            }
        }
        this.fErrorHandler = (DOMErrorHandler)this.fConfiguration.getParameter("error-handler");
        if (this.fValidationHandler != null) {
            this.fValidationHandler.setDocumentHandler(this);
            this.fValidationHandler.startDocument(new SimpleLocator(this.fDocument.fDocumentURI, this.fDocument.fDocumentURI, -1, -1), this.fDocument.encoding, this.fNamespaceContext, null);
        }
        try {
            Node kid = this.fDocument.getFirstChild();
            while (kid != null) {
                Node next = kid.getNextSibling();
                if ((kid = this.normalizeNode(kid)) != null) {
                    next = kid;
                }
                kid = next;
            }
            if (this.fValidationHandler != null) {
                this.fValidationHandler.endDocument(null);
                CoreDOMImplementationImpl.singleton.releaseValidator("http://www.w3.org/2001/XMLSchema", this.fValidationHandler);
                this.fValidationHandler = null;
            }
        }
        catch (RuntimeException e) {
            if (e == abort) {
                return;
            }
            throw e;
        }
    }

    protected Node normalizeNode(Node node) {
        short type = node.getNodeType();
        this.fLocator.fRelatedNode = node;
        switch (type) {
            case 10: {
                DocumentTypeImpl docType = (DocumentTypeImpl)node;
                this.fDTDValidator = (XMLDTDValidator)CoreDOMImplementationImpl.singleton.getValidator("http://www.w3.org/TR/REC-xml");
                this.fDTDValidator.setDocumentHandler(this);
                this.fConfiguration.setProperty("http://apache.org/xml/properties/internal/grammar-pool", this.createGrammarPool(docType));
                this.fDTDValidator.reset(this.fConfiguration);
                this.fDTDValidator.startDocument(new SimpleLocator(this.fDocument.fDocumentURI, this.fDocument.fDocumentURI, -1, -1), this.fDocument.encoding, this.fNamespaceContext, null);
                this.fDTDValidator.doctypeDecl(docType.getName(), docType.getPublicId(), docType.getSystemId(), null);
                break;
            }
            case 1: {
                int i;
                AttributeMap attributes;
                boolean wellformed;
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0 && this.fDocument.isXMLVersionChanged() && !(wellformed = this.fNamespaceValidation ? CoreDocumentImpl.isValidQName(node.getPrefix(), node.getLocalName(), this.fDocument.isXML11Version()) : CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version()))) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "wf-invalid-character-in-node-name");
                }
                this.fNamespaceContext.pushContext();
                this.fLocalNSBinder.reset();
                ElementImpl elem = (ElementImpl)node;
                if (elem.needsSyncChildren()) {
                    elem.synchronizeChildren();
                }
                AttributeMap attributeMap = attributes = elem.hasAttributes() ? (AttributeMap)elem.getAttributes() : null;
                if ((this.fConfiguration.features & 1) != 0) {
                    this.namespaceFixUp(elem, attributes);
                    if ((this.fConfiguration.features & 0x200) == 0 && attributes != null) {
                        for (i = 0; i < attributes.getLength(); ++i) {
                            Attr att = (Attr)attributes.getItem(i);
                            if (!XMLSymbols.PREFIX_XMLNS.equals(att.getPrefix()) && !XMLSymbols.PREFIX_XMLNS.equals(att.getName())) continue;
                            elem.removeAttributeNode(att);
                            --i;
                        }
                    }
                } else if (attributes != null) {
                    for (i = 0; i < attributes.getLength(); ++i) {
                        Attr attr = (Attr)attributes.item(i);
                        attr.normalize();
                        if (!this.fDocument.errorChecking || (this.fConfiguration.features & 0x100) == 0) continue;
                        DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributes, (AttrImpl)attr, attr.getValue(), this.fDocument.isXML11Version());
                        if (!this.fDocument.isXMLVersionChanged() || (wellformed = CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version()))) continue;
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attr", node.getNodeName()});
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "wf-invalid-character-in-node-name");
                    }
                }
                if (this.fValidationHandler != null) {
                    this.fAttrProxy.setAttributes(attributes, this.fDocument, elem);
                    this.updateQName(elem, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startElement(this.fQName, this.fAttrProxy, null);
                }
                if (this.fDTDValidator != null) {
                    this.fAttrProxy.setAttributes(attributes, this.fDocument, elem);
                    this.updateQName(elem, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fDTDValidator.startElement(this.fQName, this.fAttrProxy, null);
                }
                Node kid = elem.getFirstChild();
                while (kid != null) {
                    Node next = kid.getNextSibling();
                    if ((kid = this.normalizeNode(kid)) != null) {
                        next = kid;
                    }
                    kid = next;
                }
                if (this.fValidationHandler != null) {
                    this.updateQName(elem, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.endElement(this.fQName, null);
                }
                if (this.fDTDValidator != null) {
                    this.updateQName(elem, this.fQName);
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fDTDValidator.endElement(this.fQName, null);
                }
                this.fNamespaceContext.popContext();
                break;
            }
            case 8: {
                if ((this.fConfiguration.features & 0x20) == 0) {
                    Node nextSibling;
                    Node prevSibling = node.getPreviousSibling();
                    Node parent = node.getParentNode();
                    parent.removeChild(node);
                    if (prevSibling == null || prevSibling.getNodeType() != 3 || (nextSibling = prevSibling.getNextSibling()) == null || nextSibling.getNodeType() != 3) break;
                    ((TextImpl)nextSibling).insertData(0, prevSibling.getNodeValue());
                    parent.removeChild(prevSibling);
                    return nextSibling;
                }
                if (!this.fDocument.errorChecking || (this.fConfiguration.features & 0x100) == 0) break;
                String commentdata = ((Comment)node).getData();
                DOMNormalizer.isCommentWF(this.fErrorHandler, this.fError, this.fLocator, commentdata, this.fDocument.isXML11Version());
                break;
            }
            case 5: {
                if ((this.fConfiguration.features & 4) == 0) {
                    Node next;
                    Node prevSibling = node.getPreviousSibling();
                    Node parent = node.getParentNode();
                    ((EntityReferenceImpl)node).setReadOnly(false, true);
                    this.expandEntityRef(parent, node);
                    parent.removeChild(node);
                    Node node2 = next = prevSibling != null ? prevSibling.getNextSibling() : parent.getFirstChild();
                    if (prevSibling != null && next != null && prevSibling.getNodeType() == 3 && next.getNodeType() == 3) {
                        return prevSibling;
                    }
                    return next;
                }
                if (!this.fDocument.errorChecking || (this.fConfiguration.features & 0x100) == 0 || !this.fDocument.isXMLVersionChanged()) break;
                CoreDocumentImpl.isXMLName(node.getNodeName(), this.fDocument.isXML11Version());
                break;
            }
            case 4: {
                if ((this.fConfiguration.features & 8) == 0) {
                    Node prevSibling = node.getPreviousSibling();
                    if (prevSibling != null && prevSibling.getNodeType() == 3) {
                        ((Text)prevSibling).appendData(node.getNodeValue());
                        node.getParentNode().removeChild(node);
                        return prevSibling;
                    }
                    Text text = this.fDocument.createTextNode(node.getNodeValue());
                    Node parent = node.getParentNode();
                    node = parent.replaceChild(text, node);
                    return text;
                }
                if (this.fValidationHandler != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.startCDATA(null);
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                    this.fValidationHandler.endCDATA(null);
                }
                if (this.fDTDValidator != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fDTDValidator.startCDATA(null);
                    this.fDTDValidator.characterData(node.getNodeValue(), null);
                    this.fDTDValidator.endCDATA(null);
                }
                String value = node.getNodeValue();
                if ((this.fConfiguration.features & 0x10) != 0) {
                    int index;
                    Node parent = node.getParentNode();
                    if (this.fDocument.errorChecking) {
                        DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), this.fDocument.isXML11Version());
                    }
                    while ((index = value.indexOf("]]>")) >= 0) {
                        node.setNodeValue(value.substring(0, index + 2));
                        value = value.substring(index + 2);
                        Node firstSplitNode = node;
                        CDATASection newChild = this.fDocument.createCDATASection(value);
                        parent.insertBefore(newChild, node.getNextSibling());
                        node = newChild;
                        this.fLocator.fRelatedNode = firstSplitNode;
                        String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "cdata-sections-splitted", null);
                        DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)1, "cdata-sections-splitted");
                    }
                    break;
                }
                if (!this.fDocument.errorChecking) break;
                DOMNormalizer.isCDataWF(this.fErrorHandler, this.fError, this.fLocator, value, this.fDocument.isXML11Version());
                break;
            }
            case 3: {
                int nextType;
                Node next = node.getNextSibling();
                if (next != null && next.getNodeType() == 3) {
                    ((Text)node).appendData(next.getNodeValue());
                    node.getParentNode().removeChild(next);
                    return node;
                }
                if (node.getNodeValue().length() == 0) {
                    node.getParentNode().removeChild(node);
                    break;
                }
                int n = nextType = next != null ? (int)next.getNodeType() : -1;
                if (nextType != -1 && ((this.fConfiguration.features & 4) == 0 && nextType == 6 || (this.fConfiguration.features & 0x20) == 0 && nextType == 8 || (this.fConfiguration.features & 8) == 0 && nextType == 4)) break;
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                    DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, node.getNodeValue(), this.fDocument.isXML11Version());
                }
                if (this.fValidationHandler != null) {
                    this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                    this.fCurrentNode = node;
                    this.fValidationHandler.characterData(node.getNodeValue(), null);
                }
                if (this.fDTDValidator == null) break;
                this.fConfiguration.fErrorHandlerWrapper.fCurrentNode = node;
                this.fCurrentNode = node;
                this.fDTDValidator.characterData(node.getNodeValue(), null);
                if (!this.allWhitespace) break;
                this.allWhitespace = false;
                ((TextImpl)node).setIgnorableWhitespace(true);
                break;
            }
            case 7: {
                if (!this.fDocument.errorChecking || (this.fConfiguration.features & 0x100) == 0) break;
                ProcessingInstruction pinode = (ProcessingInstruction)node;
                String target = pinode.getTarget();
                boolean wellformed = this.fDocument.isXML11Version() ? XML11Char.isXML11ValidName(target) : XMLChar.isValidName(target);
                if (!wellformed) {
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Element", node.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "wf-invalid-character-in-node-name");
                }
                DOMNormalizer.isXMLCharWF(this.fErrorHandler, this.fError, this.fLocator, pinode.getData(), this.fDocument.isXML11Version());
            }
        }
        return null;
    }

    private XMLGrammarPool createGrammarPool(DocumentTypeImpl docType) {
        XMLGrammarPoolImpl pool = new XMLGrammarPoolImpl();
        XMLGrammarPreparser preParser = new XMLGrammarPreparser(this.fSymbolTable);
        preParser.registerPreparser("http://www.w3.org/TR/REC-xml", null);
        preParser.setFeature("http://apache.org/xml/features/namespaces", true);
        preParser.setFeature("http://apache.org/xml/features/validation", true);
        preParser.setProperty("http://apache.org/xml/properties/internal/grammar-pool", pool);
        String internalSubset = docType.getInternalSubset();
        XMLInputSource is = new XMLInputSource(docType.getPublicId(), docType.getSystemId(), null);
        if (internalSubset != null) {
            is.setCharacterStream(new StringReader(internalSubset));
        }
        try {
            DTDGrammar g = (DTDGrammar)preParser.preparseGrammar("http://www.w3.org/TR/REC-xml", is);
            ((XMLDTDDescription)g.getGrammarDescription()).setRootName(docType.getName());
            is.setCharacterStream(null);
            g = (DTDGrammar)preParser.preparseGrammar("http://www.w3.org/TR/REC-xml", is);
            ((XMLDTDDescription)g.getGrammarDescription()).setRootName(docType.getName());
        }
        catch (XNIException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return pool;
    }

    protected final void expandEntityRef(Node parent, Node reference) {
        Node kid = reference.getFirstChild();
        while (kid != null) {
            Node next = kid.getNextSibling();
            parent.insertBefore(kid, reference);
            kid = next;
        }
    }

    protected final void namespaceFixUp(ElementImpl element, AttributeMap attributes) {
        String prefix;
        String msg;
        String value;
        String uri;
        Attr attr;
        if (attributes != null) {
            for (int k = 0; k < attributes.getLength(); ++k) {
                attr = (Attr)attributes.getItem(k);
                if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0 && this.fDocument.isXMLVersionChanged()) {
                    this.fDocument.checkQName(attr.getPrefix(), attr.getLocalName());
                }
                if ((uri = attr.getNamespaceURI()) == null || !uri.equals(NamespaceContext.XMLNS_URI) || (this.fConfiguration.features & 0x200) == 0) continue;
                value = attr.getNodeValue();
                if (value == null) {
                    value = XMLSymbols.EMPTY_STRING;
                }
                if (this.fDocument.errorChecking && value.equals(NamespaceContext.XMLNS_URI)) {
                    this.fLocator.fRelatedNode = attr;
                    msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CantBindXMLNS", null);
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "CantBindXMLNS");
                    continue;
                }
                prefix = attr.getPrefix();
                prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                String localpart = this.fSymbolTable.addSymbol(attr.getLocalName());
                if (prefix == XMLSymbols.PREFIX_XMLNS) {
                    if ((value = this.fSymbolTable.addSymbol(value)).length() == 0) continue;
                    this.fNamespaceContext.declarePrefix(localpart, value);
                    continue;
                }
                value = this.fSymbolTable.addSymbol(value);
                this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, value);
            }
        }
        uri = element.getNamespaceURI();
        prefix = element.getPrefix();
        if ((this.fConfiguration.features & 0x200) == 0) {
            uri = null;
        } else if (uri != null) {
            uri = this.fSymbolTable.addSymbol(uri);
            String string = prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
            if (this.fNamespaceContext.getURI(prefix) != uri) {
                this.addNamespaceDecl(prefix, uri, element);
                this.fLocalNSBinder.declarePrefix(prefix, uri);
                this.fNamespaceContext.declarePrefix(prefix, uri);
            }
        } else if (element.getLocalName() == null) {
            if (this.fNamespaceValidation) {
                String msg2 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{element.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg2, (short)3, "NullLocalElementName");
            } else {
                String msg3 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalElementName", new Object[]{element.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg3, (short)2, "NullLocalElementName");
            }
        } else {
            uri = this.fNamespaceContext.getURI(XMLSymbols.EMPTY_STRING);
            if (uri != null && uri.length() > 0) {
                this.addNamespaceDecl(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING, element);
                this.fLocalNSBinder.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
                this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, XMLSymbols.EMPTY_STRING);
            }
        }
        if (attributes != null) {
            attributes.cloneMap(this.fAttributeList);
            for (int i = 0; i < this.fAttributeList.size(); ++i) {
                attr = (Attr)this.fAttributeList.get(i);
                this.fLocator.fRelatedNode = attr;
                attr.normalize();
                value = attr.getValue();
                String name = attr.getNodeName();
                uri = attr.getNamespaceURI();
                if (value == null) {
                    value = XMLSymbols.EMPTY_STRING;
                }
                if (uri != null) {
                    prefix = attr.getPrefix();
                    prefix = prefix == null || prefix.length() == 0 ? XMLSymbols.EMPTY_STRING : this.fSymbolTable.addSymbol(prefix);
                    this.fSymbolTable.addSymbol(attr.getLocalName());
                    if (uri != null && uri.equals(NamespaceContext.XMLNS_URI)) continue;
                    if (this.fDocument.errorChecking && (this.fConfiguration.features & 0x100) != 0) {
                        boolean wellformed;
                        DOMNormalizer.isAttrValueWF(this.fErrorHandler, this.fError, this.fLocator, attributes, (AttrImpl)attr, attr.getValue(), this.fDocument.isXML11Version());
                        if (this.fDocument.isXMLVersionChanged() && !(wellformed = CoreDocumentImpl.isXMLName(attr.getNodeName(), this.fDocument.isXML11Version()))) {
                            String msg4 = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "wf-invalid-character-in-node-name", new Object[]{"Attribute", attr.getNodeName()});
                            DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg4, (short)2, "wf-invalid-character-in-node-name");
                        }
                    }
                    ((AttrImpl)attr).setIdAttribute(false);
                    uri = this.fSymbolTable.addSymbol(uri);
                    String declaredURI = this.fNamespaceContext.getURI(prefix);
                    if (prefix != XMLSymbols.EMPTY_STRING && declaredURI == uri) continue;
                    name = attr.getNodeName();
                    String declaredPrefix = this.fNamespaceContext.getPrefix(uri);
                    if (declaredPrefix != null && declaredPrefix != XMLSymbols.EMPTY_STRING) {
                        prefix = declaredPrefix;
                    } else {
                        if (prefix == XMLSymbols.EMPTY_STRING || this.fLocalNSBinder.getURI(prefix) != null) {
                            int counter = 1;
                            prefix = this.fSymbolTable.addSymbol(PREFIX + counter++);
                            while (this.fLocalNSBinder.getURI(prefix) != null) {
                                prefix = this.fSymbolTable.addSymbol(PREFIX + counter++);
                            }
                        }
                        this.addNamespaceDecl(prefix, uri, element);
                        value = this.fSymbolTable.addSymbol(value);
                        this.fLocalNSBinder.declarePrefix(prefix, value);
                        this.fNamespaceContext.declarePrefix(prefix, uri);
                    }
                    attr.setPrefix(prefix);
                    continue;
                }
                ((AttrImpl)attr).setIdAttribute(false);
                if (attr.getLocalName() != null) continue;
                if (this.fNamespaceValidation) {
                    msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr.getNodeName()});
                    DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)3, "NullLocalAttrName");
                    continue;
                }
                msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NullLocalAttrName", new Object[]{attr.getNodeName()});
                DOMNormalizer.reportDOMError(this.fErrorHandler, this.fError, this.fLocator, msg, (short)2, "NullLocalAttrName");
            }
        }
    }

    protected final void addNamespaceDecl(String prefix, String uri, ElementImpl element) {
        if (prefix == XMLSymbols.EMPTY_STRING) {
            element.setAttributeNS(NamespaceContext.XMLNS_URI, XMLSymbols.PREFIX_XMLNS, uri);
        } else {
            element.setAttributeNS(NamespaceContext.XMLNS_URI, "xmlns:" + prefix, uri);
        }
    }

    public static final void isCDataWF(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, String datavalue, boolean isXML11Version) {
        if (datavalue == null || datavalue.length() == 0) {
            return;
        }
        char[] dataarray = datavalue.toCharArray();
        int datalength = dataarray.length;
        if (isXML11Version) {
            int i = 0;
            while (i < datalength) {
                int count;
                char c;
                if (XML11Char.isXML11Invalid(c = dataarray[i++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && i < datalength && XMLChar.isLowSurrogate(c2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInCDSect", new Object[]{Integer.toString(c, 16)});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != ']' || (count = i) >= datalength || dataarray[count] != ']') continue;
                while (++count < datalength && dataarray[count] == ']') {
                }
                if (count >= datalength || dataarray[count] != '>') continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CDEndInContent", null);
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        } else {
            int i = 0;
            while (i < datalength) {
                int count;
                char c;
                if (XMLChar.isInvalid(c = dataarray[i++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && i < datalength && XMLChar.isLowSurrogate(c2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInCDSect", new Object[]{Integer.toString(c, 16)});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != ']' || (count = i) >= datalength || dataarray[count] != ']') continue;
                while (++count < datalength && dataarray[count] == ']') {
                }
                if (count >= datalength || dataarray[count] != '>') continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "CDEndInContent", null);
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isXMLCharWF(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, String datavalue, boolean isXML11Version) {
        if (datavalue == null || datavalue.length() == 0) {
            return;
        }
        char[] dataarray = datavalue.toCharArray();
        int datalength = dataarray.length;
        if (isXML11Version) {
            int i = 0;
            while (i < datalength) {
                char ch2;
                char ch;
                if (!XML11Char.isXML11Invalid(dataarray[i++]) || XMLChar.isHighSurrogate(ch = dataarray[i - 1]) && i < datalength && XMLChar.isLowSurrogate(ch2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(ch, ch2))) continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "InvalidXMLCharInDOM", new Object[]{Integer.toString(dataarray[i - 1], 16)});
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        } else {
            int i = 0;
            while (i < datalength) {
                char ch2;
                char ch;
                if (!XMLChar.isInvalid(dataarray[i++]) || XMLChar.isHighSurrogate(ch = dataarray[i - 1]) && i < datalength && XMLChar.isLowSurrogate(ch2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(ch, ch2))) continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "InvalidXMLCharInDOM", new Object[]{Integer.toString(dataarray[i - 1], 16)});
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isCommentWF(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, String datavalue, boolean isXML11Version) {
        if (datavalue == null || datavalue.length() == 0) {
            return;
        }
        char[] dataarray = datavalue.toCharArray();
        int datalength = dataarray.length;
        if (isXML11Version) {
            int i = 0;
            while (i < datalength) {
                char c;
                if (XML11Char.isXML11Invalid(c = dataarray[i++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && i < datalength && XMLChar.isLowSurrogate(c2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInComment", new Object[]{Integer.toString(dataarray[i - 1], 16)});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != '-' || i >= datalength || dataarray[i] != '-') continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "DashDashInComment", null);
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        } else {
            int i = 0;
            while (i < datalength) {
                char c;
                if (XMLChar.isInvalid(c = dataarray[i++])) {
                    char c2;
                    if (XMLChar.isHighSurrogate(c) && i < datalength && XMLChar.isLowSurrogate(c2 = dataarray[i++]) && XMLChar.isSupplemental(XMLChar.supplemental(c, c2))) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "InvalidCharInComment", new Object[]{Integer.toString(dataarray[i - 1], 16)});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
                    continue;
                }
                if (c != '-' || i >= datalength || dataarray[i] != '-') continue;
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/TR/1998/REC-xml-19980210", "DashDashInComment", null);
                DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "wf-invalid-character");
            }
        }
    }

    public static final void isAttrValueWF(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, NamedNodeMap attributes, Attr a, String value, boolean xml11Version) {
        if (a instanceof AttrImpl && ((AttrImpl)a).hasStringValue()) {
            DOMNormalizer.isXMLCharWF(errorHandler, error, locator, value, xml11Version);
        } else {
            NodeList children = a.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() == 5) {
                    DocumentType docType;
                    Document owner = a.getOwnerDocument();
                    Entity ent = null;
                    if (owner != null && (docType = owner.getDoctype()) != null) {
                        NamedNodeMap entities = docType.getEntities();
                        ent = (Entity)entities.getNamedItemNS("*", child.getNodeName());
                    }
                    if (ent != null) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "UndeclaredEntRefInAttrValue", new Object[]{a.getNodeName()});
                    DOMNormalizer.reportDOMError(errorHandler, error, locator, msg, (short)2, "UndeclaredEntRefInAttrValue");
                    continue;
                }
                DOMNormalizer.isXMLCharWF(errorHandler, error, locator, child.getNodeValue(), xml11Version);
            }
        }
    }

    public static final void reportDOMError(DOMErrorHandler errorHandler, DOMErrorImpl error, DOMLocatorImpl locator, String message, short severity, String type) {
        if (errorHandler != null) {
            error.reset();
            error.fMessage = message;
            error.fSeverity = severity;
            error.fLocator = locator;
            error.fType = type;
            error.fRelatedData = locator.fRelatedNode;
            if (!errorHandler.handleError(error)) {
                throw abort;
            }
        }
        if (severity == 3) {
            throw abort;
        }
    }

    protected final void updateQName(Node node, QName qname) {
        String prefix = node.getPrefix();
        String namespace = node.getNamespaceURI();
        String localName = node.getLocalName();
        qname.prefix = prefix != null && prefix.length() != 0 ? this.fSymbolTable.addSymbol(prefix) : null;
        qname.localpart = localName != null ? this.fSymbolTable.addSymbol(localName) : null;
        qname.rawname = this.fSymbolTable.addSymbol(node.getNodeName());
        qname.uri = namespace != null ? this.fSymbolTable.addSymbol(namespace) : null;
    }

    final String normalizeAttributeValue(String value, Attr attr) {
        if (!attr.getSpecified()) {
            return value;
        }
        int end = value.length();
        if (this.fNormalizedValue.ch.length < end) {
            this.fNormalizedValue.ch = new char[end];
        }
        this.fNormalizedValue.length = 0;
        boolean normalized = false;
        for (int i = 0; i < end; ++i) {
            char c = value.charAt(i);
            if (c == '\t' || c == '\n') {
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                normalized = true;
                continue;
            }
            if (c == '\r') {
                normalized = true;
                this.fNormalizedValue.ch[this.fNormalizedValue.length++] = 32;
                int next = i + 1;
                if (next >= end || value.charAt(next) != '\n') continue;
                i = next;
                continue;
            }
            this.fNormalizedValue.ch[this.fNormalizedValue.length++] = c;
        }
        if (normalized) {
            value = this.fNormalizedValue.toString();
            attr.setValue(value);
        }
        return value;
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
    }

    @Override
    public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
    }

    @Override
    public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
    }

    @Override
    public void comment(XMLString text, Augmentations augs) throws XNIException {
    }

    @Override
    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        Element currentElement = (Element)this.fCurrentNode;
        int attrCount = attributes.getLength();
        for (int i = 0; i < attrCount; ++i) {
            attributes.getName(i, this.fAttrQName);
            Attr attr = null;
            attr = currentElement.getAttributeNodeNS(this.fAttrQName.uri, this.fAttrQName.localpart);
            AttributePSVI attrPSVI = (AttributePSVI)attributes.getAugmentations(i).getItem("ATTRIBUTE_PSVI");
            if (attrPSVI == null) continue;
            XSTypeDefinition decl = attrPSVI.getMemberTypeDefinition();
            boolean id = false;
            if (decl != null) {
                id = ((XSSimpleType)decl).isIDType();
            } else {
                decl = attrPSVI.getTypeDefinition();
                if (decl != null) {
                    id = ((XSSimpleType)decl).isIDType();
                }
            }
            if (id) {
                ((ElementImpl)currentElement).setIdAttributeNode(attr, true);
            }
            if (this.fPSVI) {
                ((PSVIAttrNSImpl)attr).setPSVI(attrPSVI);
            }
            if ((this.fConfiguration.features & 2) == 0) continue;
            boolean specified = attr.getSpecified();
            attr.setValue(attrPSVI.getSchemaNormalizedValue());
            if (specified) continue;
            ((AttrImpl)attr).setSpecified(specified);
        }
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        this.startElement(element, attributes, augs);
        this.endElement(element, augs);
    }

    @Override
    public void startGeneralEntity(String name, XMLResourceIdentifier identifier, String encoding, Augmentations augs) throws XNIException {
    }

    @Override
    public void textDecl(String version, String encoding, Augmentations augs) throws XNIException {
    }

    @Override
    public void endGeneralEntity(String name, Augmentations augs) throws XNIException {
    }

    @Override
    public void characters(XMLString text, Augmentations augs) throws XNIException {
    }

    @Override
    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        this.allWhitespace = true;
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        ElementPSVI elementPSVI;
        if (augs != null && (elementPSVI = (ElementPSVI)augs.getItem("ELEMENT_PSVI")) != null) {
            ElementImpl elementNode = (ElementImpl)this.fCurrentNode;
            if (this.fPSVI) {
                ((PSVIElementNSImpl)this.fCurrentNode).setPSVI(elementPSVI);
            }
            String normalizedValue = elementPSVI.getSchemaNormalizedValue();
            if ((this.fConfiguration.features & 2) != 0) {
                if (normalizedValue != null) {
                    elementNode.setTextContent(normalizedValue);
                }
            } else {
                String text = elementNode.getTextContent();
                if (text.length() == 0 && normalizedValue != null) {
                    elementNode.setTextContent(normalizedValue);
                }
            }
        }
    }

    @Override
    public void startCDATA(Augmentations augs) throws XNIException {
    }

    @Override
    public void endCDATA(Augmentations augs) throws XNIException {
    }

    @Override
    public void endDocument(Augmentations augs) throws XNIException {
    }

    @Override
    public void setDocumentSource(XMLDocumentSource source) {
    }

    @Override
    public XMLDocumentSource getDocumentSource() {
        return null;
    }

    protected final class XMLAttributesProxy
    implements XMLAttributes {
        protected AttributeMap fAttributes;
        protected CoreDocumentImpl fDocument;
        protected ElementImpl fElement;
        protected final Vector fAugmentations = new Vector(5);

        protected XMLAttributesProxy() {
        }

        public void setAttributes(AttributeMap attributes, CoreDocumentImpl doc, ElementImpl elem) {
            this.fDocument = doc;
            this.fAttributes = attributes;
            this.fElement = elem;
            if (attributes != null) {
                int length = attributes.getLength();
                this.fAugmentations.setSize(length);
                for (int i = 0; i < length; ++i) {
                    this.fAugmentations.setElementAt(new AugmentationsImpl(), i);
                }
            } else {
                this.fAugmentations.setSize(0);
            }
        }

        @Override
        public int addAttribute(QName qname, String attrType, String attrValue) {
            int index = this.fElement.getXercesAttribute(qname.uri, qname.localpart);
            if (index < 0) {
                AttrImpl attr = (AttrImpl)((CoreDocumentImpl)this.fElement.getOwnerDocument()).createAttributeNS(qname.uri, qname.rawname, qname.localpart);
                attr.setNodeValue(attrValue);
                index = this.fElement.setXercesAttributeNode(attr);
                this.fAugmentations.insertElementAt(new AugmentationsImpl(), index);
                attr.setSpecified(false);
            }
            return index;
        }

        @Override
        public void removeAllAttributes() {
        }

        @Override
        public void removeAttributeAt(int attrIndex) {
        }

        @Override
        public int getLength() {
            return this.fAttributes != null ? this.fAttributes.getLength() : 0;
        }

        @Override
        public int getIndex(String qName) {
            return -1;
        }

        @Override
        public int getIndex(String uri, String localPart) {
            return -1;
        }

        @Override
        public void setName(int attrIndex, QName attrName) {
        }

        @Override
        public void getName(int attrIndex, QName attrName) {
            if (this.fAttributes != null) {
                DOMNormalizer.this.updateQName((Node)this.fAttributes.getItem(attrIndex), attrName);
            }
        }

        @Override
        public String getPrefix(int index) {
            return null;
        }

        @Override
        public String getURI(int index) {
            return null;
        }

        @Override
        public String getLocalName(int index) {
            return null;
        }

        @Override
        public String getQName(int index) {
            return null;
        }

        @Override
        public QName getQualifiedName(int index) {
            return null;
        }

        @Override
        public void setType(int attrIndex, String attrType) {
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getType(String qName) {
            return "CDATA";
        }

        @Override
        public String getType(String uri, String localName) {
            return "CDATA";
        }

        @Override
        public void setValue(int attrIndex, String attrValue) {
            if (this.fAttributes != null) {
                AttrImpl attr = (AttrImpl)this.fAttributes.getItem(attrIndex);
                boolean specified = attr.getSpecified();
                attr.setValue(attrValue);
                attr.setSpecified(specified);
            }
        }

        @Override
        public void setValue(int attrIndex, String attrValue, XMLString value) {
            this.setValue(attrIndex, value.toString());
        }

        @Override
        public String getValue(int index) {
            return this.fAttributes != null ? this.fAttributes.item(index).getNodeValue() : "";
        }

        @Override
        public String getValue(String qName) {
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            if (this.fAttributes != null) {
                Node node = this.fAttributes.getNamedItemNS(uri, localName);
                return node != null ? node.getNodeValue() : null;
            }
            return null;
        }

        @Override
        public void setNonNormalizedValue(int attrIndex, String attrValue) {
        }

        @Override
        public String getNonNormalizedValue(int attrIndex) {
            return null;
        }

        @Override
        public void setSpecified(int attrIndex, boolean specified) {
            AttrImpl attr = (AttrImpl)this.fAttributes.getItem(attrIndex);
            attr.setSpecified(specified);
        }

        @Override
        public boolean isSpecified(int attrIndex) {
            return ((Attr)this.fAttributes.getItem(attrIndex)).getSpecified();
        }

        @Override
        public Augmentations getAugmentations(int attributeIndex) {
            return (Augmentations)this.fAugmentations.elementAt(attributeIndex);
        }

        @Override
        public Augmentations getAugmentations(String uri, String localPart) {
            return null;
        }

        @Override
        public Augmentations getAugmentations(String qName) {
            return null;
        }

        @Override
        public void setAugmentations(int attrIndex, Augmentations augs) {
            this.fAugmentations.setElementAt(augs, attrIndex);
        }
    }
}

