/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xerces.external.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jdk7u.jaxp.org.apache.xerces.external.dom.ChildNode;
import jdk7u.jaxp.org.apache.xerces.external.dom.CoreDocumentImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.DOMMessageFormatter;
import jdk7u.jaxp.org.apache.xerces.external.dom.EntityReferenceImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.NodeImpl;
import jdk7u.jaxp.org.apache.xerces.external.dom.TextImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;

public class AttrImpl
extends NodeImpl
implements Attr,
TypeInfo {
    static final long serialVersionUID = 7277707688218972102L;
    static final String DTD_URI = "http://www.w3.org/TR/REC-xml";
    protected Object value = null;
    protected String name;
    transient Object type;
    protected TextImpl textNode = null;

    protected AttrImpl(CoreDocumentImpl ownerDocument, String name) {
        super(ownerDocument);
        this.name = name;
        this.isSpecified(true);
        this.hasStringValue(true);
    }

    protected AttrImpl() {
    }

    void rename(String name) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.name = name;
    }

    protected void makeChildNode() {
        if (this.hasStringValue()) {
            if (this.value != null) {
                TextImpl text = (TextImpl)this.ownerDocument().createTextNode((String)this.value);
                this.value = text;
                text.isFirstChild(true);
                text.previousSibling = text;
                text.ownerNode = this;
                text.isOwned(true);
            }
            this.hasStringValue(false);
        }
    }

    @Override
    void setOwnerDocument(CoreDocumentImpl doc) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        super.setOwnerDocument(doc);
        if (!this.hasStringValue()) {
            ChildNode child = (ChildNode)this.value;
            while (child != null) {
                child.setOwnerDocument(doc);
                child = child.nextSibling;
            }
        }
    }

    public void setIdAttribute(boolean id) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isIdAttribute(id);
    }

    @Override
    public boolean isId() {
        return this.isIdAttribute();
    }

    @Override
    public Node cloneNode(boolean deep) {
        AttrImpl clone;
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (!(clone = (AttrImpl)super.cloneNode(deep)).hasStringValue()) {
            clone.value = null;
            for (Node child = (Node)this.value; child != null; child = child.getNextSibling()) {
                clone.appendChild(child.cloneNode(true));
            }
        }
        clone.isSpecified(true);
        return clone;
    }

    @Override
    public short getNodeType() {
        return 2;
    }

    @Override
    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public void setNodeValue(String value) throws DOMException {
        this.setValue(value);
    }

    @Override
    public String getTypeName() {
        return (String)this.type;
    }

    @Override
    public String getTypeNamespace() {
        if (this.type != null) {
            return DTD_URI;
        }
        return null;
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return this;
    }

    @Override
    public String getNodeValue() {
        return this.getValue();
    }

    @Override
    public String getName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    @Override
    public void setValue(String newvalue) {
        CoreDocumentImpl ownerDocument = this.ownerDocument();
        if (ownerDocument.errorChecking && this.isReadOnly()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
            throw new DOMException(7, msg);
        }
        Element ownerElement = this.getOwnerElement();
        String oldvalue = "";
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.value != null) {
            if (ownerDocument.getMutationEvents()) {
                if (this.hasStringValue()) {
                    oldvalue = (String)this.value;
                    if (this.textNode == null) {
                        this.textNode = (TextImpl)ownerDocument.createTextNode((String)this.value);
                    } else {
                        this.textNode.data = (String)this.value;
                    }
                    this.value = this.textNode;
                    this.textNode.isFirstChild(true);
                    this.textNode.previousSibling = this.textNode;
                    this.textNode.ownerNode = this;
                    this.textNode.isOwned(true);
                    this.hasStringValue(false);
                    this.internalRemoveChild(this.textNode, true);
                } else {
                    oldvalue = this.getValue();
                    while (this.value != null) {
                        this.internalRemoveChild((Node)this.value, true);
                    }
                }
            } else {
                if (this.hasStringValue()) {
                    oldvalue = (String)this.value;
                } else {
                    oldvalue = this.getValue();
                    ChildNode firstChild = (ChildNode)this.value;
                    firstChild.previousSibling = null;
                    firstChild.isFirstChild(false);
                    firstChild.ownerNode = ownerDocument;
                }
                this.value = null;
                this.needsSyncChildren(false);
            }
            if (this.isIdAttribute() && ownerElement != null) {
                ownerDocument.removeIdentifier(oldvalue);
            }
        }
        this.isSpecified(true);
        if (ownerDocument.getMutationEvents()) {
            this.internalInsertBefore(ownerDocument.createTextNode(newvalue), null, true);
            this.hasStringValue(false);
            ownerDocument.modifiedAttrValue(this, oldvalue);
        } else {
            this.value = newvalue;
            this.hasStringValue(true);
            this.changed();
        }
        if (this.isIdAttribute() && ownerElement != null) {
            ownerDocument.putIdentifier(newvalue, ownerElement);
        }
    }

    @Override
    public String getValue() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (this.value == null) {
            return "";
        }
        if (this.hasStringValue()) {
            return (String)this.value;
        }
        ChildNode firstChild = (ChildNode)this.value;
        String data = null;
        data = firstChild.getNodeType() == 5 ? ((EntityReferenceImpl)firstChild).getEntityRefValue() : firstChild.getNodeValue();
        ChildNode node = firstChild.nextSibling;
        if (node == null || data == null) {
            return data == null ? "" : data;
        }
        StringBuffer value = new StringBuffer(data);
        while (node != null) {
            if (node.getNodeType() == 5) {
                data = ((EntityReferenceImpl)node).getEntityRefValue();
                if (data == null) {
                    return "";
                }
                value.append(data);
            } else {
                value.append(node.getNodeValue());
            }
            node = node.nextSibling;
        }
        return value.toString();
    }

    @Override
    public boolean getSpecified() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.isSpecified();
    }

    public Element getElement() {
        return (Element)((Object)(this.isOwned() ? this.ownerNode : null));
    }

    @Override
    public Element getOwnerElement() {
        return (Element)((Object)(this.isOwned() ? this.ownerNode : null));
    }

    @Override
    public void normalize() {
        if (this.isNormalized() || this.hasStringValue()) {
            return;
        }
        ChildNode firstChild = (ChildNode)this.value;
        Node kid = firstChild;
        while (kid != null) {
            Node next = kid.getNextSibling();
            if (kid.getNodeType() == 3) {
                if (next != null && next.getNodeType() == 3) {
                    ((Text)kid).appendData(next.getNodeValue());
                    this.removeChild(next);
                    next = kid;
                } else if (kid.getNodeValue() == null || kid.getNodeValue().length() == 0) {
                    this.removeChild(kid);
                }
            }
            kid = next;
        }
        this.isNormalized(true);
    }

    public void setSpecified(boolean arg) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.isSpecified(arg);
    }

    public void setType(Object type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return this.getName() + "=" + "\"" + this.getValue() + "\"";
    }

    @Override
    public boolean hasChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.value != null;
    }

    @Override
    public NodeList getChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    @Override
    public Node getFirstChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        this.makeChildNode();
        return (Node)this.value;
    }

    @Override
    public Node getLastChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    final ChildNode lastChild() {
        this.makeChildNode();
        return this.value != null ? ((ChildNode)this.value).previousSibling : null;
    }

    final void lastChild(ChildNode node) {
        if (this.value != null) {
            ((ChildNode)this.value).previousSibling = node;
        }
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        return this.internalInsertBefore(newChild, refChild, false);
    }

    Node internalInsertBefore(Node newChild, Node refChild, boolean replace) throws DOMException {
        CoreDocumentImpl ownerDocument = this.ownerDocument();
        boolean errorChecking = ownerDocument.errorChecking;
        if (newChild.getNodeType() == 11) {
            if (errorChecking) {
                for (Node kid = newChild.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                    if (ownerDocument.isKidOK(this, kid)) continue;
                    String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                    throw new DOMException(3, msg);
                }
            }
            while (newChild.hasChildNodes()) {
                this.insertBefore(newChild.getFirstChild(), refChild);
            }
            return newChild;
        }
        if (newChild == refChild) {
            refChild = refChild.getNextSibling();
            this.removeChild(newChild);
            this.insertBefore(newChild, refChild);
            return newChild;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (newChild.getOwnerDocument() != ownerDocument) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "WRONG_DOCUMENT_ERR", null);
                throw new DOMException(4, msg);
            }
            if (!ownerDocument.isKidOK(this, newChild)) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                throw new DOMException(3, msg);
            }
            if (refChild != null && refChild.getParentNode() != this) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, msg);
            }
            boolean treeSafe = true;
            for (NodeImpl a = this; treeSafe && a != null; a = a.parentNode()) {
                treeSafe = newChild != a;
            }
            if (!treeSafe) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "HIERARCHY_REQUEST_ERR", null);
                throw new DOMException(3, msg);
            }
        }
        this.makeChildNode();
        ownerDocument.insertingNode(this, replace);
        ChildNode newInternal = (ChildNode)newChild;
        NodeImpl oldparent = newInternal.parentNode();
        if (oldparent != null) {
            oldparent.removeChild(newInternal);
        }
        ChildNode refInternal = (ChildNode)refChild;
        newInternal.ownerNode = this;
        newInternal.isOwned(true);
        ChildNode firstChild = (ChildNode)this.value;
        if (firstChild == null) {
            this.value = newInternal;
            newInternal.isFirstChild(true);
            newInternal.previousSibling = newInternal;
        } else if (refInternal == null) {
            ChildNode lastChild = firstChild.previousSibling;
            lastChild.nextSibling = newInternal;
            newInternal.previousSibling = lastChild;
            firstChild.previousSibling = newInternal;
        } else if (refChild == firstChild) {
            firstChild.isFirstChild(false);
            newInternal.nextSibling = firstChild;
            newInternal.previousSibling = firstChild.previousSibling;
            firstChild.previousSibling = newInternal;
            this.value = newInternal;
            newInternal.isFirstChild(true);
        } else {
            ChildNode prev = refInternal.previousSibling;
            newInternal.nextSibling = refInternal;
            prev.nextSibling = newInternal;
            refInternal.previousSibling = newInternal;
            newInternal.previousSibling = prev;
        }
        this.changed();
        ownerDocument.insertedNode(this, newInternal, replace);
        this.checkNormalizationAfterInsert(newInternal);
        return newChild;
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        if (this.hasStringValue()) {
            String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
            throw new DOMException(8, msg);
        }
        return this.internalRemoveChild(oldChild, false);
    }

    Node internalRemoveChild(Node oldChild, boolean replace) throws DOMException {
        CoreDocumentImpl ownerDocument = this.ownerDocument();
        if (ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NO_MODIFICATION_ALLOWED_ERR", null);
                throw new DOMException(7, msg);
            }
            if (oldChild != null && oldChild.getParentNode() != this) {
                String msg = DOMMessageFormatter.formatMessage("http://www.w3.org/dom/DOMTR", "NOT_FOUND_ERR", null);
                throw new DOMException(8, msg);
            }
        }
        ChildNode oldInternal = (ChildNode)oldChild;
        ownerDocument.removingNode(this, oldInternal, replace);
        if (oldInternal == this.value) {
            oldInternal.isFirstChild(false);
            this.value = oldInternal.nextSibling;
            ChildNode firstChild = (ChildNode)this.value;
            if (firstChild != null) {
                firstChild.isFirstChild(true);
                firstChild.previousSibling = oldInternal.previousSibling;
            }
        } else {
            ChildNode next;
            ChildNode prev = oldInternal.previousSibling;
            prev.nextSibling = next = oldInternal.nextSibling;
            if (next == null) {
                ChildNode firstChild = (ChildNode)this.value;
                firstChild.previousSibling = prev;
            } else {
                next.previousSibling = prev;
            }
        }
        ChildNode oldPreviousSibling = oldInternal.previousSibling();
        oldInternal.ownerNode = ownerDocument;
        oldInternal.isOwned(false);
        oldInternal.nextSibling = null;
        oldInternal.previousSibling = null;
        this.changed();
        ownerDocument.removedNode(this, replace);
        this.checkNormalizationAfterRemove(oldPreviousSibling);
        return oldInternal;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.makeChildNode();
        CoreDocumentImpl ownerDocument = this.ownerDocument();
        ownerDocument.replacingNode(this);
        this.internalInsertBefore(newChild, oldChild, true);
        if (newChild != oldChild) {
            this.internalRemoveChild(oldChild, true);
        }
        ownerDocument.replacedNode(this);
        return oldChild;
    }

    @Override
    public int getLength() {
        if (this.hasStringValue()) {
            return 1;
        }
        ChildNode node = (ChildNode)this.value;
        int length = 0;
        while (node != null) {
            ++length;
            node = node.nextSibling;
        }
        return length;
    }

    @Override
    public Node item(int index) {
        if (this.hasStringValue()) {
            if (index != 0 || this.value == null) {
                return null;
            }
            this.makeChildNode();
            return (Node)this.value;
        }
        if (index < 0) {
            return null;
        }
        ChildNode node = (ChildNode)this.value;
        for (int i = 0; i < index && node != null; ++i) {
            node = node.nextSibling;
        }
        return node;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        return super.isEqualNode(arg);
    }

    @Override
    public boolean isDerivedFrom(String typeNamespaceArg, String typeNameArg, int derivationMethod) {
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly, boolean deep) {
        super.setReadOnly(readOnly, deep);
        if (deep) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            if (this.hasStringValue()) {
                return;
            }
            ChildNode mykid = (ChildNode)this.value;
            while (mykid != null) {
                if (mykid.getNodeType() != 5) {
                    mykid.setReadOnly(readOnly, true);
                }
                mykid = mykid.nextSibling;
            }
        }
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
    }

    void checkNormalizationAfterInsert(ChildNode insertedChild) {
        if (insertedChild.getNodeType() == 3) {
            ChildNode prev = insertedChild.previousSibling();
            ChildNode next = insertedChild.nextSibling;
            if (prev != null && prev.getNodeType() == 3 || next != null && next.getNodeType() == 3) {
                this.isNormalized(false);
            }
        } else if (!insertedChild.isNormalized()) {
            this.isNormalized(false);
        }
    }

    void checkNormalizationAfterRemove(ChildNode previousSibling) {
        ChildNode next;
        if (previousSibling != null && previousSibling.getNodeType() == 3 && (next = previousSibling.nextSibling) != null && next.getNodeType() == 3) {
            this.isNormalized(false);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.needsSyncChildren(false);
    }
}

