/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler;

import java.util.StringTokenizer;
import java.util.Vector;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.INVOKESPECIAL;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionList;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.AttributeSet;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Instruction;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Parser;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.QName;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SymbolTable;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ClassGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.MethodGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Type;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.TypeCheckError;

final class UseAttributeSets
extends Instruction {
    private static final String ATTR_SET_NOT_FOUND = "";
    private final Vector _sets = new Vector(2);

    public UseAttributeSets(String setNames, Parser parser) {
        this.setParser(parser);
        this.addAttributeSets(setNames);
    }

    public void addAttributeSets(String setNames) {
        if (setNames != null && !setNames.equals(ATTR_SET_NOT_FOUND)) {
            StringTokenizer tokens = new StringTokenizer(setNames);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getParser().getQNameIgnoreDefaultNs(tokens.nextToken());
                this._sets.add(qname);
            }
        }
    }

    @Override
    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        return Type.Void;
    }

    @Override
    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        SymbolTable symbolTable = this.getParser().getSymbolTable();
        for (int i = 0; i < this._sets.size(); ++i) {
            QName name = (QName)this._sets.elementAt(i);
            AttributeSet attrs = symbolTable.lookupAttributeSet(name);
            if (attrs != null) {
                String methodName = attrs.getMethodName();
                il.append(classGen.loadTranslet());
                il.append(methodGen.loadDOM());
                il.append(methodGen.loadIterator());
                il.append(methodGen.loadHandler());
                il.append(methodGen.loadCurrentNode());
                int method = cpg.addMethodref(classGen.getClassName(), methodName, "(Ljdk7u/jaxp/org/apache/xalan/external/xsltc/DOM;Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;Ljdk7u/jaxp/org/apache/xml/external/serializer/SerializationHandler;I)V");
                il.append(new INVOKESPECIAL(method));
                continue;
            }
            Parser parser = this.getParser();
            String atrs = name.toString();
            this.reportError(this, parser, "ATTRIBSET_UNDEF_ERR", atrs);
        }
    }
}

