/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler;

import java.util.Vector;
import jdk7u.jaxp.org.apache.bcel.external.generic.ALOAD;
import jdk7u.jaxp.org.apache.bcel.external.generic.ASTORE;
import jdk7u.jaxp.org.apache.bcel.external.generic.CHECKCAST;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.ICONST;
import jdk7u.jaxp.org.apache.bcel.external.generic.ILOAD;
import jdk7u.jaxp.org.apache.bcel.external.generic.INVOKEINTERFACE;
import jdk7u.jaxp.org.apache.bcel.external.generic.INVOKESPECIAL;
import jdk7u.jaxp.org.apache.bcel.external.generic.ISTORE;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionList;
import jdk7u.jaxp.org.apache.bcel.external.generic.LocalVariableGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.NEW;
import jdk7u.jaxp.org.apache.bcel.external.generic.PUSH;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Expression;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.FilterParentPath;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.ParentLocationPath;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.ParentPattern;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Parser;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Predicate;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.RelativeLocationPath;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SymbolTable;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SyntaxTreeNode;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.UnionPathExpr;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.XSLTC;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ClassGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.MethodGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Type;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.TypeCheckError;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Util;
import jdk7u.jaxp.org.apache.xml.external.dtm.Axis;

final class Step
extends RelativeLocationPath {
    private int _axis;
    private Vector _predicates;
    private boolean _hadPredicates = false;
    private int _nodeType;

    public Step(int axis, int nodeType, Vector predicates) {
        this._axis = axis;
        this._nodeType = nodeType;
        this._predicates = predicates;
    }

    @Override
    public void setParser(Parser parser) {
        super.setParser(parser);
        if (this._predicates != null) {
            int n = this._predicates.size();
            for (int i = 0; i < n; ++i) {
                Predicate exp = (Predicate)this._predicates.elementAt(i);
                exp.setParser(parser);
                exp.setParent(this);
            }
        }
    }

    @Override
    public int getAxis() {
        return this._axis;
    }

    @Override
    public void setAxis(int axis) {
        this._axis = axis;
    }

    public int getNodeType() {
        return this._nodeType;
    }

    public Vector getPredicates() {
        return this._predicates;
    }

    public void addPredicates(Vector predicates) {
        if (this._predicates == null) {
            this._predicates = predicates;
        } else {
            this._predicates.addAll(predicates);
        }
    }

    private boolean hasParentPattern() {
        SyntaxTreeNode parent = this.getParent();
        return parent instanceof ParentPattern || parent instanceof ParentLocationPath || parent instanceof UnionPathExpr || parent instanceof FilterParentPath;
    }

    private boolean hasParentLocationPath() {
        return this.getParent() instanceof ParentLocationPath;
    }

    private boolean hasPredicates() {
        return this._predicates != null && this._predicates.size() > 0;
    }

    private boolean isPredicate() {
        SyntaxTreeNode parent = this;
        while (parent != null) {
            if (!((parent = parent.getParent()) instanceof Predicate)) continue;
            return true;
        }
        return false;
    }

    public boolean isAbbreviatedDot() {
        return this._nodeType == -1 && this._axis == 13;
    }

    public boolean isAbbreviatedDDot() {
        return this._nodeType == -1 && this._axis == 10;
    }

    @Override
    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        this._hadPredicates = this.hasPredicates();
        this._type = this.isAbbreviatedDot() ? (this.hasParentPattern() || this.hasPredicates() || this.hasParentLocationPath() ? Type.NodeSet : Type.Node) : Type.NodeSet;
        if (this._predicates != null) {
            int n = this._predicates.size();
            for (int i = 0; i < n; ++i) {
                Expression pred = (Expression)this._predicates.elementAt(i);
                pred.typeCheck(stable);
            }
        }
        return this._type;
    }

    @Override
    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        this.translateStep(classGen, methodGen, this.hasPredicates() ? this._predicates.size() - 1 : -1);
    }

    private void translateStep(ClassGenerator classGen, MethodGenerator methodGen, int predicateIndex) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (predicateIndex >= 0) {
            this.translatePredicates(classGen, methodGen, predicateIndex);
        } else {
            int star = 0;
            String name = null;
            XSLTC xsltc = this.getParser().getXSLTC();
            if (this._nodeType >= 14) {
                Vector ni = xsltc.getNamesIndex();
                name = (String)ni.elementAt(this._nodeType - 14);
                star = name.lastIndexOf(42);
            }
            if (this._axis == 2 && this._nodeType != 2 && this._nodeType != -1 && !this.hasParentPattern() && star == 0) {
                int iter = cpg.addInterfaceMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.DOM", "getTypedAxisIterator", "(II)Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;");
                il.append(methodGen.loadDOM());
                il.append(new PUSH(cpg, 2));
                il.append(new PUSH(cpg, this._nodeType));
                il.append(new INVOKEINTERFACE(iter, 3));
                return;
            }
            SyntaxTreeNode parent = this.getParent();
            if (this.isAbbreviatedDot()) {
                if (this._type == Type.Node) {
                    il.append(methodGen.loadContextNode());
                } else if (parent instanceof ParentLocationPath) {
                    int init = cpg.addMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.SingletonIterator", "<init>", "(I)V");
                    il.append(new NEW(cpg.addClass("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.SingletonIterator")));
                    il.append(DUP);
                    il.append(methodGen.loadContextNode());
                    il.append(new INVOKESPECIAL(init));
                } else {
                    int git = cpg.addInterfaceMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.DOM", "getAxisIterator", "(I)Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;");
                    il.append(methodGen.loadDOM());
                    il.append(new PUSH(cpg, this._axis));
                    il.append(new INVOKEINTERFACE(git, 2));
                }
                return;
            }
            if (parent instanceof ParentLocationPath && parent.getParent() instanceof ParentLocationPath && this._nodeType == 1 && !this._hadPredicates) {
                this._nodeType = -1;
            }
            switch (this._nodeType) {
                case 2: {
                    this._axis = 2;
                }
                case -1: {
                    int git = cpg.addInterfaceMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.DOM", "getAxisIterator", "(I)Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;");
                    il.append(methodGen.loadDOM());
                    il.append(new PUSH(cpg, this._axis));
                    il.append(new INVOKEINTERFACE(git, 2));
                    break;
                }
                default: {
                    if (star > 1) {
                        String namespace = this._axis == 2 ? name.substring(0, star - 2) : name.substring(0, star - 1);
                        int nsType = xsltc.registerNamespace(namespace);
                        int ns = cpg.addInterfaceMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.DOM", "getNamespaceAxisIterator", "(II)Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;");
                        il.append(methodGen.loadDOM());
                        il.append(new PUSH(cpg, this._axis));
                        il.append(new PUSH(cpg, nsType));
                        il.append(new INVOKEINTERFACE(ns, 3));
                        break;
                    }
                }
                case 1: {
                    int ty = cpg.addInterfaceMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.DOM", "getTypedAxisIterator", "(II)Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;");
                    il.append(methodGen.loadDOM());
                    il.append(new PUSH(cpg, this._axis));
                    il.append(new PUSH(cpg, this._nodeType));
                    il.append(new INVOKEINTERFACE(ty, 3));
                }
            }
        }
    }

    public void translatePredicates(ClassGenerator classGen, MethodGenerator methodGen, int predicateIndex) {
        Predicate predicate;
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        int idx = 0;
        if (predicateIndex < 0) {
            this.translateStep(classGen, methodGen, predicateIndex);
        } else if ((predicate = (Predicate)this._predicates.get(predicateIndex--)).isNodeValueTest()) {
            Step step = predicate.getStep();
            il.append(methodGen.loadDOM());
            if (step.isAbbreviatedDot()) {
                this.translateStep(classGen, methodGen, predicateIndex);
                il.append(new ICONST(0));
            } else {
                ParentLocationPath path = new ParentLocationPath(this, step);
                this._parent = step._parent = path;
                try {
                    path.typeCheck(this.getParser().getSymbolTable());
                }
                catch (TypeCheckError e) {
                    // empty catch block
                }
                this.translateStep(classGen, methodGen, predicateIndex);
                path.translateStep(classGen, methodGen);
                il.append(new ICONST(1));
            }
            predicate.translate(classGen, methodGen);
            idx = cpg.addInterfaceMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.DOM", "getNodeValueIterator", "(Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;ILjava/lang/String;Z)Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;");
            il.append(new INVOKEINTERFACE(idx, 5));
        } else if (predicate.isNthDescendant()) {
            il.append(methodGen.loadDOM());
            il.append(new PUSH(cpg, predicate.getPosType()));
            predicate.translate(classGen, methodGen);
            il.append(new ICONST(0));
            idx = cpg.addInterfaceMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.DOM", "getNthDescendant", "(IIZ)Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;");
            il.append(new INVOKEINTERFACE(idx, 4));
        } else if (predicate.isNthPositionFilter()) {
            idx = cpg.addMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.NthIterator", "<init>", "(Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;I)V");
            this.translatePredicates(classGen, methodGen, predicateIndex);
            LocalVariableGen iteratorTemp = methodGen.addLocalVariable("step_tmp1", Util.getJCRefType("Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;"), null, null);
            iteratorTemp.setStart(il.append(new ASTORE(iteratorTemp.getIndex())));
            predicate.translate(classGen, methodGen);
            LocalVariableGen predicateValueTemp = methodGen.addLocalVariable("step_tmp2", Util.getJCRefType("I"), null, null);
            predicateValueTemp.setStart(il.append(new ISTORE(predicateValueTemp.getIndex())));
            il.append(new NEW(cpg.addClass("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.NthIterator")));
            il.append(DUP);
            iteratorTemp.setEnd(il.append(new ALOAD(iteratorTemp.getIndex())));
            predicateValueTemp.setEnd(il.append(new ILOAD(predicateValueTemp.getIndex())));
            il.append(new INVOKESPECIAL(idx));
        } else {
            idx = cpg.addMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.CurrentNodeListIterator", "<init>", "(Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;Ljdk7u/jaxp/org/apache/xalan/external/xsltc/dom/CurrentNodeListFilter;ILjdk7u/jaxp/org/apache/xalan/external/xsltc/runtime/AbstractTranslet;)V");
            this.translatePredicates(classGen, methodGen, predicateIndex);
            LocalVariableGen iteratorTemp = methodGen.addLocalVariable("step_tmp1", Util.getJCRefType("Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;"), null, null);
            iteratorTemp.setStart(il.append(new ASTORE(iteratorTemp.getIndex())));
            predicate.translateFilter(classGen, methodGen);
            LocalVariableGen filterTemp = methodGen.addLocalVariable("step_tmp2", Util.getJCRefType("Ljdk7u/jaxp/org/apache/xalan/external/xsltc/dom/CurrentNodeListFilter;"), null, null);
            filterTemp.setStart(il.append(new ASTORE(filterTemp.getIndex())));
            il.append(new NEW(cpg.addClass("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.CurrentNodeListIterator")));
            il.append(DUP);
            iteratorTemp.setEnd(il.append(new ALOAD(iteratorTemp.getIndex())));
            filterTemp.setEnd(il.append(new ALOAD(filterTemp.getIndex())));
            il.append(methodGen.loadCurrentNode());
            il.append(classGen.loadTranslet());
            if (classGen.isExternal()) {
                String className = classGen.getClassName();
                il.append(new CHECKCAST(cpg.addClass(className)));
            }
            il.append(new INVOKESPECIAL(idx));
        }
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("step(\"");
        buffer.append(Axis.getNames(this._axis)).append("\", ").append(this._nodeType);
        if (this._predicates != null) {
            int n = this._predicates.size();
            for (int i = 0; i < n; ++i) {
                Predicate pred = (Predicate)this._predicates.elementAt(i);
                buffer.append(", ").append(pred.toString());
            }
        }
        return buffer.append(')').toString();
    }
}

