/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler;

import jdk7u.jaxp.org.apache.bcel.external.generic.ALOAD;
import jdk7u.jaxp.org.apache.bcel.external.generic.ASTORE;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.GETFIELD;
import jdk7u.jaxp.org.apache.bcel.external.generic.INVOKEINTERFACE;
import jdk7u.jaxp.org.apache.bcel.external.generic.INVOKESTATIC;
import jdk7u.jaxp.org.apache.bcel.external.generic.INVOKEVIRTUAL;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionList;
import jdk7u.jaxp.org.apache.bcel.external.generic.LocalVariableGen;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.AttributeValue;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Instruction;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Parser;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SymbolTable;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ClassGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ErrorMsg;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.MethodGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Type;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.TypeCheckError;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Util;
import jdk7u.jaxp.org.apache.xml.external.utils.XML11Char;

final class ProcessingInstruction
extends Instruction {
    private AttributeValue _name;
    private boolean _isLiteral = false;

    ProcessingInstruction() {
    }

    @Override
    public void parseContents(Parser parser) {
        String name = this.getAttribute("name");
        if (name.length() > 0) {
            this._isLiteral = Util.isLiteral(name);
            if (this._isLiteral && !XML11Char.isXML11ValidNCName(name)) {
                ErrorMsg err = new ErrorMsg("INVALID_NCNAME_ERR", (Object)name, this);
                parser.reportError(3, err);
            }
            this._name = AttributeValue.create(this, name, parser);
        } else {
            this.reportError(this, parser, "REQUIRED_ATTR_ERR", "name");
        }
        if (name.equals("xml")) {
            this.reportError(this, parser, "ILLEGAL_PI_ERR", "xml");
        }
        this.parseChildren(parser);
    }

    @Override
    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        this._name.typeCheck(stable);
        this.typeCheckContents(stable);
        return Type.Void;
    }

    @Override
    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (!this._isLiteral) {
            LocalVariableGen nameValue = methodGen.addLocalVariable2("nameValue", Util.getJCRefType("Ljava/lang/String;"), null);
            this._name.translate(classGen, methodGen);
            nameValue.setStart(il.append(new ASTORE(nameValue.getIndex())));
            il.append(new ALOAD(nameValue.getIndex()));
            int check = cpg.addMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.runtime.BasisLibrary", "checkNCName", "(Ljava/lang/String;)V");
            il.append(new INVOKESTATIC(check));
            il.append(methodGen.loadHandler());
            il.append(DUP);
            nameValue.setEnd(il.append(new ALOAD(nameValue.getIndex())));
        } else {
            il.append(methodGen.loadHandler());
            il.append(DUP);
            this._name.translate(classGen, methodGen);
        }
        il.append(classGen.loadTranslet());
        il.append(new GETFIELD(cpg.addFieldref("jdk7u.jaxp.org.apache.xalan.external.xsltc.runtime.AbstractTranslet", "stringValueHandler", "Ljdk7u/jaxp/org/apache/xalan/external/xsltc/runtime/StringValueHandler;")));
        il.append(DUP);
        il.append(methodGen.storeHandler());
        this.translateContents(classGen, methodGen);
        il.append(new INVOKEVIRTUAL(cpg.addMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.runtime.StringValueHandler", "getValueOfPI", "()Ljava/lang/String;")));
        int processingInstruction = cpg.addInterfaceMethodref("jdk7u.jaxp.org.apache.xml.external.serializer.SerializationHandler", "processingInstruction", "(Ljava/lang/String;Ljava/lang/String;)V");
        il.append(new INVOKEINTERFACE(processingInstruction, 3));
        il.append(methodGen.storeHandler());
    }
}

