/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler;

import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionList;
import jdk7u.jaxp.org.apache.bcel.external.generic.PUSH;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.AttributeValue;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Instruction;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.LiteralElement;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Parser;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SimpleAttributeValue;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SymbolTable;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SyntaxTreeNode;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ClassGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.MethodGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Type;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.TypeCheckError;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Util;
import jdk7u.jaxp.org.apache.xml.external.serializer.ElemDesc;

final class LiteralAttribute
extends Instruction {
    private final String _name;
    private final AttributeValue _value;

    public LiteralAttribute(String name, String value, Parser parser, SyntaxTreeNode parent) {
        this._name = name;
        this.setParent(parent);
        this._value = AttributeValue.create(this, value, parser);
    }

    @Override
    public void display(int indent) {
        this.indent(indent);
        Util.println("LiteralAttribute name=" + this._name + " value=" + this._value);
    }

    @Override
    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        this._value.typeCheck(stable);
        this.typeCheckContents(stable);
        return Type.Void;
    }

    @Override
    protected boolean contextDependent() {
        return this._value.contextDependent();
    }

    @Override
    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        il.append(methodGen.loadHandler());
        il.append(new PUSH(cpg, this._name));
        this._value.translate(classGen, methodGen);
        SyntaxTreeNode parent = this.getParent();
        if (parent instanceof LiteralElement && ((LiteralElement)parent).allAttributesUnique()) {
            String attrValue;
            int flags = 0;
            boolean isHTMLAttrEmpty = false;
            ElemDesc elemDesc = ((LiteralElement)parent).getElemDesc();
            if (elemDesc != null) {
                if (elemDesc.isAttrFlagSet(this._name, 4)) {
                    flags |= 2;
                    isHTMLAttrEmpty = true;
                } else if (elemDesc.isAttrFlagSet(this._name, 2)) {
                    flags |= 4;
                }
            }
            if (this._value instanceof SimpleAttributeValue && !this.hasBadChars(attrValue = ((SimpleAttributeValue)this._value).toString()) && !isHTMLAttrEmpty) {
                flags |= 1;
            }
            il.append(new PUSH(cpg, flags));
            il.append(methodGen.uniqueAttribute());
        } else {
            il.append(methodGen.attribute());
        }
    }

    private boolean hasBadChars(String value) {
        for (char ch : value.toCharArray()) {
            if (ch >= ' ' && '~' >= ch && ch != '<' && ch != '>' && ch != '&' && ch != '\"') continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this._name;
    }

    public AttributeValue getValue() {
        return this._value;
    }
}

