/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler;

import java.util.Enumeration;
import jdk7u.jaxp.org.apache.xalan.external.utils.SecuritySupport;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Param;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Parser;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SourceLoader;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Stylesheet;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SymbolTable;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SyntaxTreeNode;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.TopLevelElement;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Variable;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.XSLTC;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ClassGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ErrorMsg;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.MethodGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Type;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.TypeCheckError;
import jdk7u.jaxp.org.apache.xml.external.utils.SystemIDResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

final class Include
extends TopLevelElement {
    private Stylesheet _included = null;

    Include() {
    }

    public Stylesheet getIncludedStylesheet() {
        return this._included;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseContents(Parser parser) {
        XSLTC xsltc = parser.getXSLTC();
        Stylesheet context = parser.getCurrentStylesheet();
        String docToLoad = this.getAttribute("href");
        try {
            if (context.checkForLoop(docToLoad)) {
                ErrorMsg msg = new ErrorMsg("CIRCULAR_INCLUDE_ERR", (Object)docToLoad, this);
                parser.reportError(2, msg);
                return;
            }
            InputSource input = null;
            XMLReader reader = null;
            String currLoadedDoc = context.getSystemId();
            SourceLoader loader = context.getSourceLoader();
            if (loader != null) {
                input = loader.loadSource(docToLoad, currLoadedDoc, xsltc);
                if (input != null) {
                    docToLoad = input.getSystemId();
                    reader = xsltc.getXMLReader();
                } else if (parser.errorsFound()) {
                    return;
                }
            }
            if (input == null) {
                String accessError = SecuritySupport.checkAccess(docToLoad = SystemIDResolver.getAbsoluteURI(docToLoad, currLoadedDoc), (String)xsltc.getProperty("http://javax.xml.XMLConstants/property/accessExternalStylesheet"), "all");
                if (accessError != null) {
                    ErrorMsg msg = new ErrorMsg("ACCESSING_XSLT_TARGET_ERR", SecuritySupport.sanitizePath(docToLoad), accessError, this);
                    parser.reportError(2, msg);
                    return;
                }
                input = new InputSource(docToLoad);
            }
            if (input == null) {
                ErrorMsg msg = new ErrorMsg("FILE_NOT_FOUND_ERR", (Object)docToLoad, this);
                parser.reportError(2, msg);
                return;
            }
            SyntaxTreeNode root = reader != null ? parser.parse(reader, input) : parser.parse(input);
            if (root == null) {
                return;
            }
            this._included = parser.makeStylesheet(root);
            if (this._included == null) {
                return;
            }
            this._included.setSourceLoader(loader);
            this._included.setSystemId(docToLoad);
            this._included.setParentStylesheet(context);
            this._included.setIncludingStylesheet(context);
            this._included.setTemplateInlining(context.getTemplateInlining());
            int precedence = context.getImportPrecedence();
            this._included.setImportPrecedence(precedence);
            parser.setCurrentStylesheet(this._included);
            this._included.parseContents(parser);
            Enumeration elements = this._included.elements();
            Stylesheet topStylesheet = parser.getTopLevelStylesheet();
            while (elements.hasMoreElements()) {
                Object element = elements.nextElement();
                if (!(element instanceof TopLevelElement)) continue;
                if (element instanceof Variable) {
                    topStylesheet.addVariable((Variable)element);
                    continue;
                }
                if (element instanceof Param) {
                    topStylesheet.addParam((Param)element);
                    continue;
                }
                topStylesheet.addElement((TopLevelElement)element);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            parser.setCurrentStylesheet(context);
        }
    }

    @Override
    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        return Type.Void;
    }

    @Override
    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
    }
}

