/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler;

import java.util.Vector;
import jdk7u.jaxp.org.apache.bcel.external.generic.ALOAD;
import jdk7u.jaxp.org.apache.bcel.external.generic.ASTORE;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.ILOAD;
import jdk7u.jaxp.org.apache.bcel.external.generic.INVOKESPECIAL;
import jdk7u.jaxp.org.apache.bcel.external.generic.ISTORE;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionList;
import jdk7u.jaxp.org.apache.bcel.external.generic.LocalVariableGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.NEW;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.CastExpr;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Expression;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.KeyCall;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Parser;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.Predicate;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.SymbolTable;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ClassGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.MethodGenerator;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.NodeSetType;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.ReferenceType;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Type;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.TypeCheckError;
import jdk7u.jaxp.org.apache.xalan.external.xsltc.compiler.util.Util;

class FilterExpr
extends Expression {
    private Expression _primary;
    private final Vector _predicates;

    public FilterExpr(Expression primary, Vector predicates) {
        this._primary = primary;
        this._predicates = predicates;
        primary.setParent(this);
    }

    protected Expression getExpr() {
        if (this._primary instanceof CastExpr) {
            return ((CastExpr)this._primary).getExpr();
        }
        return this._primary;
    }

    @Override
    public void setParser(Parser parser) {
        super.setParser(parser);
        this._primary.setParser(parser);
        if (this._predicates != null) {
            int n = this._predicates.size();
            for (int i = 0; i < n; ++i) {
                Expression exp = (Expression)this._predicates.elementAt(i);
                exp.setParser(parser);
                exp.setParent(this);
            }
        }
    }

    @Override
    public String toString() {
        return "filter-expr(" + this._primary + ", " + this._predicates + ")";
    }

    @Override
    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        Type ptype = this._primary.typeCheck(stable);
        boolean canOptimize = this._primary instanceof KeyCall;
        if (!(ptype instanceof NodeSetType)) {
            if (ptype instanceof ReferenceType) {
                this._primary = new CastExpr(this._primary, Type.NodeSet);
            } else {
                throw new TypeCheckError(this);
            }
        }
        int n = this._predicates.size();
        for (int i = 0; i < n; ++i) {
            Predicate pred = (Predicate)this._predicates.elementAt(i);
            if (!canOptimize) {
                pred.dontOptimize();
            }
            pred.typeCheck(stable);
        }
        this._type = Type.NodeSet;
        return this._type;
    }

    @Override
    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        this.translateFilterExpr(classGen, methodGen, this._predicates == null ? -1 : this._predicates.size() - 1);
    }

    private void translateFilterExpr(ClassGenerator classGen, MethodGenerator methodGen, int predicateIndex) {
        if (predicateIndex >= 0) {
            this.translatePredicates(classGen, methodGen, predicateIndex);
        } else {
            this._primary.translate(classGen, methodGen);
        }
    }

    public void translatePredicates(ClassGenerator classGen, MethodGenerator methodGen, int predicateIndex) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        if (predicateIndex < 0) {
            this.translateFilterExpr(classGen, methodGen, predicateIndex);
        } else {
            Predicate predicate = (Predicate)this._predicates.get(predicateIndex--);
            this.translatePredicates(classGen, methodGen, predicateIndex);
            if (predicate.isNthPositionFilter()) {
                int nthIteratorIdx = cpg.addMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.NthIterator", "<init>", "(Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;I)V");
                LocalVariableGen iteratorTemp = methodGen.addLocalVariable("filter_expr_tmp1", Util.getJCRefType("Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;"), null, null);
                iteratorTemp.setStart(il.append(new ASTORE(iteratorTemp.getIndex())));
                predicate.translate(classGen, methodGen);
                LocalVariableGen predicateValueTemp = methodGen.addLocalVariable("filter_expr_tmp2", Util.getJCRefType("I"), null, null);
                predicateValueTemp.setStart(il.append(new ISTORE(predicateValueTemp.getIndex())));
                il.append(new NEW(cpg.addClass("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.NthIterator")));
                il.append(DUP);
                iteratorTemp.setEnd(il.append(new ALOAD(iteratorTemp.getIndex())));
                predicateValueTemp.setEnd(il.append(new ILOAD(predicateValueTemp.getIndex())));
                il.append(new INVOKESPECIAL(nthIteratorIdx));
            } else {
                int initCNLI = cpg.addMethodref("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.CurrentNodeListIterator", "<init>", "(Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;ZLjdk7u/jaxp/org/apache/xalan/external/xsltc/dom/CurrentNodeListFilter;ILjdk7u/jaxp/org/apache/xalan/external/xsltc/runtime/AbstractTranslet;)V");
                LocalVariableGen nodeIteratorTemp = methodGen.addLocalVariable("filter_expr_tmp1", Util.getJCRefType("Ljdk7u/jaxp/org/apache/xml/external/dtm/DTMAxisIterator;"), null, null);
                nodeIteratorTemp.setStart(il.append(new ASTORE(nodeIteratorTemp.getIndex())));
                predicate.translate(classGen, methodGen);
                LocalVariableGen filterTemp = methodGen.addLocalVariable("filter_expr_tmp2", Util.getJCRefType("Ljdk7u/jaxp/org/apache/xalan/external/xsltc/dom/CurrentNodeListFilter;"), null, null);
                filterTemp.setStart(il.append(new ASTORE(filterTemp.getIndex())));
                il.append(new NEW(cpg.addClass("jdk7u.jaxp.org.apache.xalan.external.xsltc.dom.CurrentNodeListIterator")));
                il.append(DUP);
                nodeIteratorTemp.setEnd(il.append(new ALOAD(nodeIteratorTemp.getIndex())));
                il.append(ICONST_1);
                filterTemp.setEnd(il.append(new ALOAD(filterTemp.getIndex())));
                il.append(methodGen.loadCurrentNode());
                il.append(classGen.loadTranslet());
                il.append(new INVOKESPECIAL(initCNLI));
            }
        }
    }
}

