/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.xalan.external.utils;

import jdk7u.jaxp.org.apache.xalan.external.utils.FeaturePropertyBase;

public final class FeatureManager
extends FeaturePropertyBase {
    public FeatureManager() {
        this.values = new String[Feature.values().length];
        for (Feature feature : Feature.values()) {
            this.values[feature.ordinal()] = feature.defaultValue();
        }
        this.readSystemProperties();
    }

    public boolean isFeatureEnabled(Feature feature) {
        return Boolean.parseBoolean(this.values[feature.ordinal()]);
    }

    public boolean isFeatureEnabled(String propertyName) {
        return Boolean.parseBoolean(this.values[this.getIndex(propertyName)]);
    }

    @Override
    public int getIndex(String propertyName) {
        for (Feature feature : Feature.values()) {
            if (!feature.equalsName(propertyName)) continue;
            return feature.ordinal();
        }
        return -1;
    }

    private void readSystemProperties() {
        this.getSystemProperty(Feature.ORACLE_ENABLE_EXTENSION_FUNCTION, "javax.xml.enableExtensionFunctions");
    }

    public static enum Feature {
        ORACLE_ENABLE_EXTENSION_FUNCTION("http://www.oracle.com/xml/jaxp/properties/enableExtensionFunctions", "true");

        final String name;
        final String defaultValue;

        private Feature(String name, String value) {
            this.name = name;
            this.defaultValue = value;
        }

        public boolean equalsName(String propertyName) {
            return propertyName == null ? false : this.name.equals(propertyName);
        }

        String defaultValue() {
            return this.defaultValue;
        }
    }

    public static enum State {
        DEFAULT,
        FSP,
        JAXPDOTPROPERTIES,
        SYSTEMPROPERTY,
        APIPROPERTY;

    }
}

