/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.regexp.external;

import java.io.IOException;
import java.io.InputStream;
import jdk7u.jaxp.org.apache.regexp.external.CharacterIterator;

public final class StreamCharacterIterator
implements CharacterIterator {
    private final InputStream is;
    private final StringBuffer buff;
    private boolean closed;

    public StreamCharacterIterator(InputStream is) {
        this.is = is;
        this.buff = new StringBuffer(512);
        this.closed = false;
    }

    @Override
    public String substring(int beginIndex, int endIndex) {
        try {
            this.ensure(endIndex);
            return this.buff.toString().substring(beginIndex, endIndex);
        }
        catch (IOException e) {
            throw new StringIndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public String substring(int beginIndex) {
        try {
            this.readAll();
            return this.buff.toString().substring(beginIndex);
        }
        catch (IOException e) {
            throw new StringIndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public char charAt(int pos) {
        try {
            this.ensure(pos);
            return this.buff.charAt(pos);
        }
        catch (IOException e) {
            throw new StringIndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public boolean isEnd(int pos) {
        if (this.buff.length() > pos) {
            return false;
        }
        try {
            this.ensure(pos);
            return this.buff.length() <= pos;
        }
        catch (IOException e) {
            throw new StringIndexOutOfBoundsException(e.getMessage());
        }
    }

    private int read(int n) throws IOException {
        if (this.closed) {
            return 0;
        }
        int i = n;
        while (--i >= 0) {
            int c = this.is.read();
            if (c < 0) {
                this.closed = true;
                break;
            }
            this.buff.append((char)c);
        }
        return n - i;
    }

    private void readAll() throws IOException {
        while (!this.closed) {
            this.read(1000);
        }
    }

    private void ensure(int idx) throws IOException {
        if (this.closed) {
            return;
        }
        if (idx < this.buff.length()) {
            return;
        }
        this.read(idx + 1 - this.buff.length());
    }
}

