/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.regexp.external;

import java.io.Serializable;
import java.util.Vector;
import jdk7u.jaxp.org.apache.regexp.external.CharacterIterator;
import jdk7u.jaxp.org.apache.regexp.external.RECompiler;
import jdk7u.jaxp.org.apache.regexp.external.REProgram;
import jdk7u.jaxp.org.apache.regexp.external.RESyntaxException;
import jdk7u.jaxp.org.apache.regexp.external.StringCharacterIterator;

public class RE
implements Serializable {
    public static final int MATCH_NORMAL = 0;
    public static final int MATCH_CASEINDEPENDENT = 1;
    public static final int MATCH_MULTILINE = 2;
    public static final int MATCH_SINGLELINE = 4;
    static final char OP_END = 'E';
    static final char OP_BOL = '^';
    static final char OP_EOL = '$';
    static final char OP_ANY = '.';
    static final char OP_ANYOF = '[';
    static final char OP_BRANCH = '|';
    static final char OP_ATOM = 'A';
    static final char OP_STAR = '*';
    static final char OP_PLUS = '+';
    static final char OP_MAYBE = '?';
    static final char OP_ESCAPE = '\\';
    static final char OP_OPEN = '(';
    static final char OP_OPEN_CLUSTER = '<';
    static final char OP_CLOSE = ')';
    static final char OP_CLOSE_CLUSTER = '>';
    static final char OP_BACKREF = '#';
    static final char OP_GOTO = 'G';
    static final char OP_NOTHING = 'N';
    static final char OP_RELUCTANTSTAR = '8';
    static final char OP_RELUCTANTPLUS = '=';
    static final char OP_RELUCTANTMAYBE = '/';
    static final char OP_POSIXCLASS = 'P';
    static final char E_ALNUM = 'w';
    static final char E_NALNUM = 'W';
    static final char E_BOUND = 'b';
    static final char E_NBOUND = 'B';
    static final char E_SPACE = 's';
    static final char E_NSPACE = 'S';
    static final char E_DIGIT = 'd';
    static final char E_NDIGIT = 'D';
    static final char POSIX_CLASS_ALNUM = 'w';
    static final char POSIX_CLASS_ALPHA = 'a';
    static final char POSIX_CLASS_BLANK = 'b';
    static final char POSIX_CLASS_CNTRL = 'c';
    static final char POSIX_CLASS_DIGIT = 'd';
    static final char POSIX_CLASS_GRAPH = 'g';
    static final char POSIX_CLASS_LOWER = 'l';
    static final char POSIX_CLASS_PRINT = 'p';
    static final char POSIX_CLASS_PUNCT = '!';
    static final char POSIX_CLASS_SPACE = 's';
    static final char POSIX_CLASS_UPPER = 'u';
    static final char POSIX_CLASS_XDIGIT = 'x';
    static final char POSIX_CLASS_JSTART = 'j';
    static final char POSIX_CLASS_JPART = 'k';
    static final int maxNode = 65536;
    static final int MAX_PAREN = 16;
    static final int offsetOpcode = 0;
    static final int offsetOpdata = 1;
    static final int offsetNext = 2;
    static final int nodeSize = 3;
    REProgram program;
    transient CharacterIterator search;
    int matchFlags;
    int maxParen = 16;
    transient int parenCount;
    transient int start0;
    transient int end0;
    transient int start1;
    transient int end1;
    transient int start2;
    transient int end2;
    transient int[] startn;
    transient int[] endn;
    transient int[] startBackref;
    transient int[] endBackref;
    public static final int REPLACE_ALL = 0;
    public static final int REPLACE_FIRSTONLY = 1;
    public static final int REPLACE_BACKREFERENCES = 2;

    public RE(String pattern) throws RESyntaxException {
        this(pattern, 0);
    }

    public RE(String pattern, int matchFlags) throws RESyntaxException {
        this(new RECompiler().compile(pattern));
        this.setMatchFlags(matchFlags);
    }

    public RE(REProgram program, int matchFlags) {
        this.setProgram(program);
        this.setMatchFlags(matchFlags);
    }

    public RE(REProgram program) {
        this(program, 0);
    }

    public RE() {
        this((REProgram)null, 0);
    }

    public static String simplePatternToFullRegularExpression(String pattern) {
        StringBuffer buf = new StringBuffer();
        block4: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    buf.append(".*");
                    continue block4;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    buf.append('\\');
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    public void setMatchFlags(int matchFlags) {
        this.matchFlags = matchFlags;
    }

    public int getMatchFlags() {
        return this.matchFlags;
    }

    public void setProgram(REProgram program) {
        this.program = program;
        this.maxParen = program != null && program.maxParens != -1 ? program.maxParens : 16;
    }

    public REProgram getProgram() {
        return this.program;
    }

    public int getParenCount() {
        return this.parenCount;
    }

    public String getParen(int which) {
        int start;
        if (which < this.parenCount && (start = this.getParenStart(which)) >= 0) {
            return this.search.substring(start, this.getParenEnd(which));
        }
        return null;
    }

    public final int getParenStart(int which) {
        if (which < this.parenCount) {
            switch (which) {
                case 0: {
                    return this.start0;
                }
                case 1: {
                    return this.start1;
                }
                case 2: {
                    return this.start2;
                }
            }
            if (this.startn == null) {
                this.allocParens();
            }
            return this.startn[which];
        }
        return -1;
    }

    public final int getParenEnd(int which) {
        if (which < this.parenCount) {
            switch (which) {
                case 0: {
                    return this.end0;
                }
                case 1: {
                    return this.end1;
                }
                case 2: {
                    return this.end2;
                }
            }
            if (this.endn == null) {
                this.allocParens();
            }
            return this.endn[which];
        }
        return -1;
    }

    public final int getParenLength(int which) {
        if (which < this.parenCount) {
            return this.getParenEnd(which) - this.getParenStart(which);
        }
        return -1;
    }

    protected final void setParenStart(int which, int i) {
        if (which < this.parenCount) {
            switch (which) {
                case 0: {
                    this.start0 = i;
                    break;
                }
                case 1: {
                    this.start1 = i;
                    break;
                }
                case 2: {
                    this.start2 = i;
                    break;
                }
                default: {
                    if (this.startn == null) {
                        this.allocParens();
                    }
                    this.startn[which] = i;
                }
            }
        }
    }

    protected final void setParenEnd(int which, int i) {
        if (which < this.parenCount) {
            switch (which) {
                case 0: {
                    this.end0 = i;
                    break;
                }
                case 1: {
                    this.end1 = i;
                    break;
                }
                case 2: {
                    this.end2 = i;
                    break;
                }
                default: {
                    if (this.endn == null) {
                        this.allocParens();
                    }
                    this.endn[which] = i;
                }
            }
        }
    }

    protected void internalError(String s) throws Error {
        throw new Error("RE internal error: " + s);
    }

    private final void allocParens() {
        this.startn = new int[this.maxParen];
        this.endn = new int[this.maxParen];
        for (int i = 0; i < this.maxParen; ++i) {
            this.startn[i] = -1;
            this.endn[i] = -1;
        }
    }

    protected int matchNodes(int firstNode, int lastNode, int idxStart) {
        int idx = idxStart;
        char[] instruction = this.program.instruction;
        int node = firstNode;
        block50: while (node < lastNode) {
            char opcode = instruction[node + 0];
            int next = node + (short)instruction[node + 2];
            int opdata = instruction[node + 1];
            block0 : switch (opcode) {
                case '/': {
                    int once = 0;
                    do {
                        int idxNew;
                        if ((idxNew = this.matchNodes(next, 65536, idx)) == -1) continue;
                        return idxNew;
                    } while (once++ == 0 && (idx = this.matchNodes(node + 3, next, idx)) != -1);
                    return -1;
                }
                case '=': {
                    while ((idx = this.matchNodes(node + 3, next, idx)) != -1) {
                        int idxNew = this.matchNodes(next, 65536, idx);
                        if (idxNew == -1) continue;
                        return idxNew;
                    }
                    return -1;
                }
                case '8': {
                    do {
                        int idxNew;
                        if ((idxNew = this.matchNodes(next, 65536, idx)) == -1) continue;
                        return idxNew;
                    } while ((idx = this.matchNodes(node + 3, next, idx)) != -1);
                    return -1;
                }
                case '(': {
                    int idxNew;
                    if ((this.program.flags & 1) != 0) {
                        this.startBackref[opdata] = idx;
                    }
                    if ((idxNew = this.matchNodes(next, 65536, idx)) != -1) {
                        if (opdata + '\u0001' > this.parenCount) {
                            this.parenCount = opdata + '\u0001';
                        }
                        if (this.getParenStart(opdata) == -1) {
                            this.setParenStart(opdata, idx);
                        }
                    }
                    return idxNew;
                }
                case ')': {
                    int idxNew;
                    if ((this.program.flags & 1) != 0) {
                        this.endBackref[opdata] = idx;
                    }
                    if ((idxNew = this.matchNodes(next, 65536, idx)) != -1) {
                        if (opdata + '\u0001' > this.parenCount) {
                            this.parenCount = opdata + '\u0001';
                        }
                        if (this.getParenEnd(opdata) == -1) {
                            this.setParenEnd(opdata, idx);
                        }
                    }
                    return idxNew;
                }
                case '<': 
                case '>': {
                    return this.matchNodes(next, 65536, idx);
                }
                case '#': {
                    int s = this.startBackref[opdata];
                    int e = this.endBackref[opdata];
                    if (s == -1 || e == -1) {
                        return -1;
                    }
                    if (s == e) break;
                    int l = e - s;
                    if (this.search.isEnd(idx + l - 1)) {
                        return -1;
                    }
                    boolean caseFold = (this.matchFlags & 1) != 0;
                    for (int i = 0; i < l; ++i) {
                        if (this.compareChars(this.search.charAt(idx++), this.search.charAt(s + i), caseFold) == 0) continue;
                        return -1;
                    }
                    break;
                }
                case '^': {
                    if (idx == 0) break;
                    if ((this.matchFlags & 2) == 2) {
                        if (idx > 0 && this.isNewline(idx - 1)) break;
                        return -1;
                    }
                    return -1;
                }
                case '$': {
                    if (this.search.isEnd(0) || this.search.isEnd(idx)) break;
                    if ((this.matchFlags & 2) == 2) {
                        if (this.isNewline(idx)) break;
                        return -1;
                    }
                    return -1;
                }
                case '\\': {
                    char c;
                    switch (opdata) {
                        case 66: 
                        case 98: {
                            char cLast = idx == 0 ? (char)'\n' : (char)this.search.charAt(idx - 1);
                            char cNext = this.search.isEnd(idx) ? (char)'\n' : (char)this.search.charAt(idx);
                            if (Character.isLetterOrDigit(cLast) == Character.isLetterOrDigit(cNext) != (opdata == 98)) break block0;
                            return -1;
                        }
                        case 68: 
                        case 83: 
                        case 87: 
                        case 100: 
                        case 115: 
                        case 119: {
                            if (this.search.isEnd(idx)) {
                                return -1;
                            }
                            c = this.search.charAt(idx);
                            switch (opdata) {
                                case 87: 
                                case 119: {
                                    if ((Character.isLetterOrDigit(c) || c == '_') == (opdata == 119)) break;
                                    return -1;
                                }
                                case 68: 
                                case 100: {
                                    if (Character.isDigit(c) == (opdata == 100)) break;
                                    return -1;
                                }
                                case 83: 
                                case 115: {
                                    if (Character.isWhitespace(c) == (opdata == 115)) break;
                                    return -1;
                                }
                            }
                            ++idx;
                            break;
                        }
                        default: {
                            this.internalError("Unrecognized escape '" + opdata + "'");
                            break;
                        }
                    }
                    break;
                }
                case '.': {
                    if ((this.matchFlags & 4) == 4 ? this.search.isEnd(idx) : this.search.isEnd(idx) || this.isNewline(idx)) {
                        return -1;
                    }
                    ++idx;
                    break;
                }
                case 'A': {
                    if (this.search.isEnd(idx)) {
                        return -1;
                    }
                    int lenAtom = opdata;
                    int startAtom = node + 3;
                    if (this.search.isEnd(lenAtom + idx - 1)) {
                        return -1;
                    }
                    boolean caseFold = (this.matchFlags & 1) != 0;
                    for (int i = 0; i < lenAtom; ++i) {
                        if (this.compareChars(this.search.charAt(idx++), instruction[startAtom + i], caseFold) == 0) continue;
                        return -1;
                    }
                    break;
                }
                case 'P': {
                    if (this.search.isEnd(idx)) {
                        return -1;
                    }
                    block28 : switch (opdata) {
                        case 119: {
                            if (Character.isLetterOrDigit(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 97: {
                            if (Character.isLetter(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 100: {
                            if (Character.isDigit(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 98: {
                            if (Character.isSpaceChar(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 115: {
                            if (Character.isWhitespace(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 99: {
                            if (Character.getType(this.search.charAt(idx)) == 15) break;
                            return -1;
                        }
                        case 103: {
                            switch (Character.getType(this.search.charAt(idx))) {
                                case 25: 
                                case 26: 
                                case 27: 
                                case 28: {
                                    break block28;
                                }
                            }
                            return -1;
                        }
                        case 108: {
                            if (Character.getType(this.search.charAt(idx)) == 2) break;
                            return -1;
                        }
                        case 117: {
                            if (Character.getType(this.search.charAt(idx)) == 1) break;
                            return -1;
                        }
                        case 112: {
                            if (Character.getType(this.search.charAt(idx)) != 15) break;
                            return -1;
                        }
                        case 33: {
                            int type = Character.getType(this.search.charAt(idx));
                            switch (type) {
                                case 20: 
                                case 21: 
                                case 22: 
                                case 23: 
                                case 24: {
                                    break block28;
                                }
                            }
                            return -1;
                        }
                        case 120: {
                            boolean isXDigit;
                            boolean bl = isXDigit = this.search.charAt(idx) >= '0' && this.search.charAt(idx) <= '9' || this.search.charAt(idx) >= 'a' && this.search.charAt(idx) <= 'f' || this.search.charAt(idx) >= 'A' && this.search.charAt(idx) <= 'F';
                            if (isXDigit) break;
                            return -1;
                        }
                        case 106: {
                            if (Character.isJavaIdentifierStart(this.search.charAt(idx))) break;
                            return -1;
                        }
                        case 107: {
                            if (Character.isJavaIdentifierPart(this.search.charAt(idx))) break;
                            return -1;
                        }
                        default: {
                            this.internalError("Bad posix class");
                        }
                    }
                    ++idx;
                    break;
                }
                case '[': {
                    if (this.search.isEnd(idx)) {
                        return -1;
                    }
                    char c = this.search.charAt(idx);
                    boolean caseFold = (this.matchFlags & 1) != 0;
                    int idxRange = node + 3;
                    int idxEnd = idxRange + opdata * 2;
                    boolean match = false;
                    int i = idxRange;
                    while (!match && i < idxEnd) {
                        char s = instruction[i++];
                        char e = instruction[i++];
                        match = this.compareChars(c, s, caseFold) >= 0 && this.compareChars(c, e, caseFold) <= 0;
                    }
                    if (!match) {
                        return -1;
                    }
                    ++idx;
                    break;
                }
                case '|': {
                    short nextBranch;
                    if (instruction[next + 0] != '|') {
                        node += 3;
                        continue block50;
                    }
                    do {
                        int idxNew;
                        if ((idxNew = this.matchNodes(node + 3, 65536, idx)) == -1) continue;
                        return idxNew;
                    } while ((nextBranch = (short)instruction[node + 2]) != 0 && instruction[(node += nextBranch) + 0] == '|');
                    return -1;
                }
                case 'G': 
                case 'N': {
                    break;
                }
                case 'E': {
                    this.setParenEnd(0, idx);
                    return idx;
                }
                default: {
                    this.internalError("Invalid opcode '" + opcode + "'");
                }
            }
            node = next;
        }
        this.internalError("Corrupt program");
        return -1;
    }

    protected boolean matchAt(int i) {
        int idx;
        this.start0 = -1;
        this.end0 = -1;
        this.start1 = -1;
        this.end1 = -1;
        this.start2 = -1;
        this.end2 = -1;
        this.startn = null;
        this.endn = null;
        this.parenCount = 1;
        this.setParenStart(0, i);
        if ((this.program.flags & 1) != 0) {
            this.startBackref = new int[this.maxParen];
            this.endBackref = new int[this.maxParen];
        }
        if ((idx = this.matchNodes(0, 65536, i)) != -1) {
            this.setParenEnd(0, idx);
            return true;
        }
        this.parenCount = 0;
        return false;
    }

    public boolean match(String search, int i) {
        return this.match(new StringCharacterIterator(search), i);
    }

    public boolean match(CharacterIterator search, int i) {
        if (this.program == null) {
            this.internalError("No RE program to run!");
        }
        this.search = search;
        if (this.program.prefix == null) {
            while (!search.isEnd(i - 1)) {
                if (this.matchAt(i)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        boolean caseIndependent = (this.matchFlags & 1) != 0;
        char[] prefix = this.program.prefix;
        while (!search.isEnd(i + prefix.length - 1)) {
            boolean match;
            int j = i;
            int k = 0;
            do {
                boolean bl = match = this.compareChars(search.charAt(j++), prefix[k++], caseIndependent) == 0;
            } while (match && k < prefix.length);
            if (k == prefix.length && this.matchAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean match(String search) {
        return this.match(search, 0);
    }

    public String[] split(String s) {
        Vector<String> v = new Vector<String>();
        int pos = 0;
        int len = s.length();
        while (pos < len && this.match(s, pos)) {
            int start = this.getParenStart(0);
            int newpos = this.getParenEnd(0);
            if (newpos == pos) {
                v.addElement(s.substring(pos, start + 1));
            } else {
                v.addElement(s.substring(pos, start));
            }
            pos = ++newpos;
        }
        String remainder = s.substring(pos);
        if (remainder.length() != 0) {
            v.addElement(remainder);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public String subst(String substituteIn, String substitution) {
        return this.subst(substituteIn, substitution, 0);
    }

    public String subst(String substituteIn, String substitution, int flags) {
        StringBuffer ret = new StringBuffer();
        int pos = 0;
        int len = substituteIn.length();
        while (pos < len && this.match(substituteIn, pos)) {
            ret.append(substituteIn.substring(pos, this.getParenStart(0)));
            if ((flags & 2) != 0) {
                int lCurrentPosition = 0;
                int lLastPosition = -2;
                int lLength = substitution.length();
                boolean bAddedPrefix = false;
                while ((lCurrentPosition = substitution.indexOf("$", lCurrentPosition)) >= 0) {
                    char c;
                    if ((lCurrentPosition == 0 || substitution.charAt(lCurrentPosition - 1) != '\\') && lCurrentPosition + 1 < lLength && (c = substitution.charAt(lCurrentPosition + 1)) >= '0' && c <= '9') {
                        if (!bAddedPrefix) {
                            ret.append(substitution.substring(0, lCurrentPosition));
                            bAddedPrefix = true;
                        } else {
                            ret.append(substitution.substring(lLastPosition + 2, lCurrentPosition));
                        }
                        ret.append(this.getParen(c - 48));
                        lLastPosition = lCurrentPosition;
                    }
                    ++lCurrentPosition;
                }
                ret.append(substitution.substring(lLastPosition + 2, lLength));
            } else {
                ret.append(substitution);
            }
            int newpos = this.getParenEnd(0);
            if (newpos == pos) {
                // empty if block
            }
            pos = ++newpos;
            if ((flags & 1) == 0) continue;
            break;
        }
        if (pos < len) {
            ret.append(substituteIn.substring(pos));
        }
        return ret.toString();
    }

    public String[] grep(Object[] search) {
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < search.length; ++i) {
            String s = search[i].toString();
            if (!this.match(s)) continue;
            v.addElement(s);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    private boolean isNewline(int i) {
        char nextChar = this.search.charAt(i);
        return nextChar == '\n' || nextChar == '\r' || nextChar == '\u0085' || nextChar == '\u2028' || nextChar == '\u2029';
    }

    private int compareChars(char c1, char c2, boolean caseIndependent) {
        if (caseIndependent) {
            c1 = Character.toLowerCase(c1);
            c2 = Character.toLowerCase(c2);
        }
        return c1 - c2;
    }
}

