/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import jdk7u.jaxp.org.apache.bcel.external.Constants;
import jdk7u.jaxp.org.apache.bcel.external.ExceptionConstants;
import jdk7u.jaxp.org.apache.bcel.external.generic.AllocationInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.ArrayType;
import jdk7u.jaxp.org.apache.bcel.external.generic.BasicType;
import jdk7u.jaxp.org.apache.bcel.external.generic.ExceptionThrower;
import jdk7u.jaxp.org.apache.bcel.external.generic.Instruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.StackProducer;
import jdk7u.jaxp.org.apache.bcel.external.generic.Type;
import jdk7u.jaxp.org.apache.bcel.external.generic.Visitor;
import jdk7u.jaxp.org.apache.bcel.external.util.ByteSequence;

public class NEWARRAY
extends Instruction
implements AllocationInstruction,
ExceptionThrower,
StackProducer {
    private byte type;

    NEWARRAY() {
    }

    public NEWARRAY(byte type) {
        super((short)188, (short)2);
        this.type = type;
    }

    public NEWARRAY(BasicType type) {
        this(type.getType());
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeByte(this.type);
    }

    public final byte getTypecode() {
        return this.type;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.type), 1);
    }

    @Override
    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + Constants.TYPE_NAMES[this.type];
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.type = bytes.readByte();
        this.length = (short)2;
    }

    @Override
    public Class[] getExceptions() {
        return new Class[]{ExceptionConstants.NEGATIVE_ARRAY_SIZE_EXCEPTION};
    }

    @Override
    public void accept(Visitor v) {
        v.visitAllocationInstruction(this);
        v.visitExceptionThrower(this);
        v.visitStackProducer(this);
        v.visitNEWARRAY(this);
    }
}

