/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.generic;

import java.io.Serializable;
import jdk7u.jaxp.org.apache.bcel.external.classfile.LineNumber;
import jdk7u.jaxp.org.apache.bcel.external.generic.BranchInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.ClassGenException;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionHandle;
import jdk7u.jaxp.org.apache.bcel.external.generic.InstructionTargeter;

public class LineNumberGen
implements InstructionTargeter,
Cloneable,
Serializable {
    private InstructionHandle ih;
    private int src_line;

    public LineNumberGen(InstructionHandle ih, int src_line) {
        this.setInstruction(ih);
        this.setSourceLine(src_line);
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        return this.ih == ih;
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        if (old_ih != this.ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.ih + "}");
        }
        this.setInstruction(new_ih);
    }

    public LineNumber getLineNumber() {
        return new LineNumber(this.ih.getPosition(), this.src_line);
    }

    public final void setInstruction(InstructionHandle ih) {
        BranchInstruction.notifyTargetChanging(this.ih, this);
        this.ih = ih;
        BranchInstruction.notifyTargetChanged(this.ih, this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println(e);
            return null;
        }
    }

    public InstructionHandle getInstruction() {
        return this.ih;
    }

    public void setSourceLine(int src_line) {
        this.src_line = src_line;
    }

    public int getSourceLine() {
        return this.src_line;
    }
}

