/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import jdk7u.jaxp.org.apache.bcel.external.ExceptionConstants;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Constant;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantFloat;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantInteger;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantString;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantUtf8;
import jdk7u.jaxp.org.apache.bcel.external.generic.CPInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.ExceptionThrower;
import jdk7u.jaxp.org.apache.bcel.external.generic.PushInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.Type;
import jdk7u.jaxp.org.apache.bcel.external.generic.TypedInstruction;
import jdk7u.jaxp.org.apache.bcel.external.generic.Visitor;
import jdk7u.jaxp.org.apache.bcel.external.util.ByteSequence;

public class LDC
extends CPInstruction
implements PushInstruction,
ExceptionThrower,
TypedInstruction {
    LDC() {
    }

    public LDC(int index) {
        super((short)19, index);
        this.setSize();
    }

    protected final void setSize() {
        if (this.index <= 255) {
            this.opcode = (short)18;
            this.length = (short)2;
        } else {
            this.opcode = (short)19;
            this.length = (short)3;
        }
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        if (this.length == 2) {
            out.writeByte(this.index);
        } else {
            out.writeShort(this.index);
        }
    }

    @Override
    public final void setIndex(int index) {
        super.setIndex(index);
        this.setSize();
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.length = (short)2;
        this.index = bytes.readUnsignedByte();
    }

    public Object getValue(ConstantPoolGen cpg) {
        Constant c = cpg.getConstantPool().getConstant(this.index);
        switch (c.getTag()) {
            case 8: {
                int i = ((ConstantString)c).getStringIndex();
                c = cpg.getConstantPool().getConstant(i);
                return ((ConstantUtf8)c).getBytes();
            }
            case 4: {
                return new Float(((ConstantFloat)c).getBytes());
            }
            case 3: {
                return new Integer(((ConstantInteger)c).getBytes());
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    @Override
    public Type getType(ConstantPoolGen cpg) {
        switch (cpg.getConstantPool().getConstant(this.index).getTag()) {
            case 8: {
                return Type.STRING;
            }
            case 4: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.INT;
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    @Override
    public Class[] getExceptions() {
        return ExceptionConstants.EXCS_STRING_RESOLUTION;
    }

    @Override
    public void accept(Visitor v) {
        v.visitStackProducer(this);
        v.visitPushInstruction(this);
        v.visitExceptionThrower(this);
        v.visitTypedInstruction(this);
        v.visitCPInstruction(this);
        v.visitLDC(this);
    }
}

