/*
 * Decompiled with CFR 0.152.
 */
package jdk7u.jaxp.org.apache.bcel.external.generic;

import java.util.StringTokenizer;
import jdk7u.jaxp.org.apache.bcel.external.Constants;
import jdk7u.jaxp.org.apache.bcel.external.classfile.Constant;
import jdk7u.jaxp.org.apache.bcel.external.classfile.ConstantPool;
import jdk7u.jaxp.org.apache.bcel.external.generic.ConstantPoolGen;
import jdk7u.jaxp.org.apache.bcel.external.generic.ExceptionThrower;
import jdk7u.jaxp.org.apache.bcel.external.generic.FieldOrMethod;
import jdk7u.jaxp.org.apache.bcel.external.generic.StackConsumer;
import jdk7u.jaxp.org.apache.bcel.external.generic.StackProducer;
import jdk7u.jaxp.org.apache.bcel.external.generic.Type;
import jdk7u.jaxp.org.apache.bcel.external.generic.TypedInstruction;

public abstract class InvokeInstruction
extends FieldOrMethod
implements ExceptionThrower,
TypedInstruction,
StackConsumer,
StackProducer {
    InvokeInstruction() {
    }

    protected InvokeInstruction(short opcode, int index) {
        super(opcode, index);
    }

    @Override
    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return Constants.OPCODE_NAMES[this.opcode] + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }

    @Override
    public int consumeStack(ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        Type[] args = Type.getArgumentTypes(signature);
        int sum = this.opcode == 184 ? 0 : 1;
        int n = args.length;
        for (int i = 0; i < n; ++i) {
            sum += args[i].getSize();
        }
        return sum;
    }

    @Override
    public int produceStack(ConstantPoolGen cpg) {
        return this.getReturnType(cpg).getSize();
    }

    @Override
    public Type getType(ConstantPoolGen cpg) {
        return this.getReturnType(cpg);
    }

    public String getMethodName(ConstantPoolGen cpg) {
        return this.getName(cpg);
    }

    public Type getReturnType(ConstantPoolGen cpg) {
        return Type.getReturnType(this.getSignature(cpg));
    }

    public Type[] getArgumentTypes(ConstantPoolGen cpg) {
        return Type.getArgumentTypes(this.getSignature(cpg));
    }
}

